/*
 * Copyright (C) 1996   Silicon Graphics, Inc.
 *
 _______________________________________________________________________
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 |
 |   $Revision: 1.5 $
 |
 |   Classes:
 |      HvWebField
 |
 |   Author(s)          : Horst Vollhardt
 |
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 _______________________________________________________________________
 */

#include <stdlib.h>
#include <iostream.h>
#include <malloc.h>
#include <netinet/in.h>

#include <Xm/AtomMgr.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/MwmUtil.h>
#include <Xm/Protocols.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>
#include <Xm/Separator.h>
#include <Xm/Scale.h>


#include <Inventor/actions/SoSearchAction.h>
#include <Inventor/actions/SoWriteAction.h>
#include <Inventor/fields/SoMFFloat.h>
#include <Inventor/fields/SoMFVec3f.h>
#include <Inventor/fields/SoMFColor.h>
#include <Inventor/fields/SoMFInt32.h>
#include <Inventor/fields/SoMFShort.h>
#include <Inventor/fields/SoMFString.h>
#include <Inventor/fields/SoMFEnum.h>
#include <Inventor/fields/SoMFBool.h>
#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/fields/SoSFFloat.h>
#include <Inventor/fields/SoSFEnum.h>
#include <Inventor/fields/SoSFBool.h>
#include <Inventor/fields/SoSFVec3f.h>
#include <Inventor/nodes/SoNode.h>
#include <Inventor/nodes/SoGroup.h>

#include "HvWebField.h"
#include "HvWebFunction.h"


enum WidgetIds {
    CONTAINER,

    TOGGLE_BUTTON,
    VALUE_LABEL,

    WIDGET_NUM, // must be last
};

#define HvUIOffset 1

#define TOGGLE_ON(BUTTON) \
    XmToggleButtonSetState((Widget) BUTTON, TRUE, FALSE)
#define TOGGLE_OFF(BUTTON) \
    XmToggleButtonSetState((Widget) BUTTON, FALSE, FALSE)

#define SLIDER_MAX   1000

#include "HvWebFieldDefs.h"

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Constructor
//
// Use: public

HvWebField::HvWebField()
//
////////////////////////////////////////////////////////////////////////
{
    field  = NULL;
    value  = 0;
    type   = OUTPUT_STRING;
    setSlider();

    widgetList = new Widget[WIDGET_NUM];
    for (int i = 0; i < WIDGET_NUM; i++) {
        widgetList[i] = NULL;
    }

    connected = TRUE;
    hidden = FALSE;
    nodeType = SoNode::getClassTypeId();
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Destructor
//
// Use: private

HvWebField::~HvWebField()
//
////////////////////////////////////////////////////////////////////////
{
    // destroy widgets ?
    delete [] widgetList;

    int n = listItems.getLength();
    for (int i = 0; i < n; i++) delete (SbString *)listItems[i];
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//   callback for new connection requests
//
// Use: private

void
HvWebField::connectionChangedCB(Widget, HvWebField *wf, void *cd)
//
////////////////////////////////////////////////////////////////////////
{
XmToggleButtonCallbackStruct *cbs = (XmToggleButtonCallbackStruct *)cd;

wf->connected = cbs->set;
}


////////////////////////////////////////////////////////////////////////
//
// Description:
//   update the values of a field
//   returns pointer to the next field in the array
//
// Use: public

const char *
HvWebField::update(const char *buff, SbBool NeedUpdate)
//
////////////////////////////////////////////////////////////////////////
{
   int *iBuff = (int *) buff;
   int len    = iBuff[0];
//cerr << label.getString() << " : " << len << "\n";
//   int id     = iBuff[1];
   int nItem  = iBuff[2];

   char *cBuff = (char *)&iBuff[3];

   if ((type == HvWebField::OUTPUT_FLOAT)&&(! hidden)) {
      char text[256];
      value = *(float *)cBuff;
      sprintf(text, "%-10g", value);
      XmString xstring = XmStringCreateSimple(text);
      XtVaSetValues(widgetList[VALUE_LABEL], XmNlabelString, xstring, NULL);
      XmStringFree(xstring);
   }
   else if ((type == HvWebField::OUTPUT_STRING)&&(! hidden)) {
      string = cBuff;
      XmString xstring = XmStringCreateSimple((char *)string.getString());
      XtVaSetValues(widgetList[VALUE_LABEL], XmNlabelString, xstring, NULL);
      XmStringFree(xstring);
   }
   else if ((type == HvWebField::OUTPUT_FIELD)&&
            ((isConnected())||(NeedUpdate))) {
      if (field->isOfType(SoSFFloat::getClassTypeId())) {
         UNPACK_SFIELD_SCALAR(SoSFFloat,float)
      }
      else if (field->isOfType(SoSFInt32::getClassTypeId())) {
         UNPACK_SFIELD_SCALAR(SoSFInt32,int32_t)
      }
      else if (field->isOfType(SoSFEnum::getClassTypeId())) {
         UNPACK_SFIELD_SCALAR(SoSFEnum,int)
      }
      else if (field->isOfType(SoSFBool::getClassTypeId())) {
         UNPACK_SFIELD_SCALAR(SoSFBool,int)
      }
      else if (field->isOfType(SoSFVec3f::getClassTypeId())) {
         UNPACK_SFIELD_VECTOR(SoSFVec3f,float)
      }
      else if (field->isOfType(SoMFFloat::getClassTypeId())) {
         UNPACK_MFIELD_SCALAR(SoMFFloat,float)
      }
      else if (field->isOfType(SoMFInt32::getClassTypeId())) {
         UNPACK_MFIELD_SCALAR(SoMFInt32,int32_t)
      }
      else if (field->isOfType(SoMFShort::getClassTypeId())) {
         UNPACK_MFIELD_SCALAR(SoMFShort,short)
      }
      else if (field->isOfType(SoMFEnum::getClassTypeId())) {
         UNPACK_MFIELD_SCALAR(SoMFEnum,int)
      }
      else if (field->isOfType(SoMFBool::getClassTypeId())) {
         UNPACK_MFIELD_SCALAR(SoMFBool,int)
      }
      else if (field->isOfType(SoMFVec3f::getClassTypeId())) {
         UNPACK_MFIELD_VECTOR(SoMFVec3f,3,SbVec3f,float)
      }
      else if (field->isOfType(SoMFColor::getClassTypeId())) {
         UNPACK_MFIELD_VECTOR(SoMFColor,3,SbColor,float)
      }
    //  else if (field->isOfType(MFVec2i::getClassTypeId())) {
    //     UNPACK_MFIELD_VECTOR(MFVec2i,2,SbVec2i,int32_t)
    //  }
      else if (field->isOfType(SoMFString::getClassTypeId())) {
         UNPACK_MFIELD_STRING(SoMFString,SbString,char)
      }
   }

   return (&buff[len]);
}


////////////////////////////////////////////////////////////////////////
//
// Description:
//   pack field content into an array
//
// Use: public

void
HvWebField::pack(char * &cBuff, int &s)
//
////////////////////////////////////////////////////////////////////////
{
   if ((type == HvWebField::OUTPUT_FLOAT)  ||
       (type == HvWebField::OUTPUT_STRING) ||
       (type == HvWebField::OUTPUT_FIELD)) return;

   if (type == HvWebField::INPUT_FLOAT) {
      if (widgetList[VALUE_LABEL])
         value = atof(XmTextFieldGetString(widgetList[VALUE_LABEL]));

      HvTmpFloat *field = new HvTmpFloat;  // overload HvWebField's field
      field->value = value;
      PACK_SFIELD_SCALAR(HvTmpFloat,float)
   }
   if (type == HvWebField::INPUT_SLIDER) {
      if (widgetList[VALUE_LABEL]) {
         int sc;
	 XmScaleGetValue(widgetList[VALUE_LABEL], &sc);
         value = sliderMin + (float)sc * (sliderMax - sliderMin) / SLIDER_MAX;
      }

      HvTmpFloat *field = new HvTmpFloat;  // overload HvWebField's field
      field->value = value;
      PACK_SFIELD_SCALAR(HvTmpFloat,float)
   }
   else if (type == HvWebField::INPUT_STRING) {
      if (widgetList[VALUE_LABEL])
         string = XmTextFieldGetString(widgetList[VALUE_LABEL]);

      PACK_SFIELD_STRING()
   }
   else if (type == HvWebField::INPUT_LIST) {
      SoMFString *field = new SoMFString;   // overload HvWebField's field
      if (widgetList[VALUE_LABEL]) {
         int ni, *il = NULL;
	 XmListGetSelectedPos(widgetList[VALUE_LABEL], &il, &ni);
	 field->setNum(ni);
	 for(int i = 0; i < ni; i++)
	    field->set1Value(i, *((SbString *)listItems[il[i]-1]));
	 if (il != NULL) XtFree((char *)il);
      }

      PACK_MFIELD_STRING(SoMFString,char)
   }
   else if (type == HvWebField::INPUT_FIELD) {
      if (field->isOfType(SoSFFloat::getClassTypeId())) {
	 PACK_SFIELD_SCALAR(SoSFFloat,float)
      }
      else if (field->isOfType(SoSFInt32::getClassTypeId())) {
	 PACK_SFIELD_SCALAR(SoSFInt32,int32_t)
      }
      else if (field->isOfType(SoSFEnum::getClassTypeId())) {
	 PACK_SFIELD_SCALAR(SoSFEnum,int)
      }
      else if (field->isOfType(SoSFBool::getClassTypeId())) {
	 PACK_SFIELD_SCALAR(SoSFBool,int)
      }
      else if (field->isOfType(SoSFVec3f::getClassTypeId())) {
	 PACK_SFIELD_VECTOR(SoSFVec3f,3,float)
      }
      else if (field->isOfType(SoMFFloat::getClassTypeId())) {
	 PACK_MFIELD_SCALAR(SoMFFloat,float)
      }
      else if (field->isOfType(SoMFInt32::getClassTypeId())) {
	 PACK_MFIELD_SCALAR(SoMFInt32,int32_t)
      }
      else if (field->isOfType(SoMFShort::getClassTypeId())) {
	 PACK_MFIELD_SCALAR(SoMFShort,short)
      }
      else if (field->isOfType(SoMFEnum::getClassTypeId())) {
	 PACK_MFIELD_SCALAR(SoMFEnum,int)
      }
      else if (field->isOfType(SoMFBool::getClassTypeId())) {
	 PACK_MFIELD_SCALAR(SoMFBool,int)
      }
//      else if (field->isOfType(MFVec2i::getClassTypeId())) {
//	 PACK_MFIELD_VECTOR(MFVec2i,2,int32_t)
//      }
      else if (field->isOfType(SoMFVec3f::getClassTypeId())) {
	 PACK_MFIELD_VECTOR(SoMFVec3f,3,float)
      }
      else if (field->isOfType(SoMFColor::getClassTypeId())) {
	 PACK_MFIELD_VECTOR(SoMFColor,3,float)
      }
      else if (field->isOfType(SoMFString::getClassTypeId())) {
	 PACK_MFIELD_STRING(SoMFString,char)
      }
   }
//   else if (type == HvWebField::SELECTION) {
//      PACK_MFIELD_SELECTION(MFVec2i,2,int32_t)
//   }
}


////////////////////////////////////////////////////////////////////////
//
// Description:
//   build all widgets for this field
//
// Use: public

Widget
HvWebField::buildWidgets(Widget parent, HvWebFunction *wfn)
//
////////////////////////////////////////////////////////////////////////
{
   Widget form = widgetList[CONTAINER] =
      XtVaCreateManagedWidget("connectItem",
         xmFormWidgetClass, parent,
         NULL);

   XmString emptyString = XmStringCreateSimple("");

   if (type == HvWebField::OUTPUT_FIELD) {
      Widget button = widgetList[TOGGLE_BUTTON] =
         XtVaCreateManagedWidget("outputField",
            xmToggleButtonWidgetClass, form,
            XmNlabelString,      emptyString,
            XmNset,              False,
            XmNleftAttachment,   XmATTACH_FORM,
            XmNleftOffset,       HvUIOffset,
            XmNbottomAttachment, XmATTACH_FORM,
            XmNbottomOffset,     HvUIOffset,
            XmNtopAttachment,    XmATTACH_FORM,
            XmNtopOffset,        HvUIOffset,
            NULL);
      XmToggleButtonSetState((Widget)button, isConnected(), FALSE);
      XtAddCallback(button, XmNvalueChangedCallback,
         (XtCallbackProc) HvWebField::connectionChangedCB, this);
   }
   else if ((type == HvWebField::OUTPUT_FLOAT)||
            (type == HvWebField::INPUT_FLOAT)) {
      XmString xstring = XmStringCreateSimple((char *)label.getString());
      Widget button = widgetList[TOGGLE_BUTTON] =
         XtVaCreateManagedWidget("outputFloat",
            xmLabelWidgetClass, form,
            XmNlabelString,      xstring,
            XmNset,              False,
            XmNleftAttachment,   XmATTACH_FORM,
            XmNleftOffset,       HvUIOffset,
            XmNbottomAttachment, XmATTACH_FORM,
            XmNbottomOffset,     HvUIOffset,
            XmNtopAttachment,    XmATTACH_FORM,
            XmNtopOffset,        HvUIOffset,
            NULL);
      XmStringFree(xstring);
   }
   else if ((type == HvWebField::OUTPUT_STRING)||
            (type == HvWebField::INPUT_STRING) ||
	    (type == HvWebField::INPUT_SLIDER)) {
      XmString xstring = XmStringCreateSimple((char *)label.getString());
      Widget button = widgetList[TOGGLE_BUTTON] =
         XtVaCreateManagedWidget("outputFloat",
            xmLabelWidgetClass, form,
            XmNlabelString,      xstring,
            XmNset,              False,
            XmNleftAttachment,   XmATTACH_FORM,
            XmNleftOffset,       HvUIOffset,
            XmNbottomAttachment, XmATTACH_FORM,
            XmNbottomOffset,     HvUIOffset,
            XmNtopAttachment,    XmATTACH_FORM,
            XmNtopOffset,        HvUIOffset,
            NULL);
      XmStringFree(xstring);
   }
   else if ((type == HvWebField::INPUT_LIST)) {
      XmString xstring = XmStringCreateSimple((char *)label.getString());
      Widget button = widgetList[TOGGLE_BUTTON] =
         XtVaCreateManagedWidget("outputFloat",
            xmLabelWidgetClass, form,
            XmNlabelString,      xstring,
            XmNset,              False,
            XmNleftAttachment,   XmATTACH_FORM,
            XmNleftOffset,       HvUIOffset,
            XmNrightAttachment,  XmATTACH_FORM,
            XmNrightOffset,      HvUIOffset,
            XmNtopAttachment,    XmATTACH_FORM,
            XmNtopOffset,        HvUIOffset,
            NULL);
      XmStringFree(xstring);
   }

   if (type == HvWebField::OUTPUT_FLOAT) {
      char text[40]; sprintf(text, "%-10g", value);
      XmString xstring = XmStringCreateSimple(text);
      Widget labelW = widgetList[VALUE_LABEL] =
         XtVaCreateManagedWidget("label",
            xmLabelWidgetClass, form,
            XmNlabelString,      xstring,
            XmNleftAttachment,   XmATTACH_POSITION,
            XmNleftOffset,       HvUIOffset,
            XmNleftPosition,     60,
            XmNbottomAttachment, XmATTACH_FORM,
            XmNbottomOffset,     HvUIOffset,
            XmNtopAttachment,    XmATTACH_FORM,
            XmNtopOffset,        HvUIOffset,
            NULL);
      XmStringFree(xstring);
   }
   else if (type == HvWebField::OUTPUT_STRING) {
      XmString xstring = XmStringCreateSimple((char *)string.getString());
      Widget labelW = widgetList[VALUE_LABEL] =
         XtVaCreateManagedWidget("label",
            xmLabelWidgetClass, form,
            XmNlabelString,      xstring,
            XmNleftAttachment,   XmATTACH_POSITION,
            XmNleftOffset,       HvUIOffset,
            XmNleftPosition,     60,
            XmNbottomAttachment, XmATTACH_FORM,
            XmNbottomOffset,     HvUIOffset,
            XmNtopAttachment,    XmATTACH_FORM,
            XmNtopOffset,        HvUIOffset,
            NULL);
      XmStringFree(xstring);
   }
   else if (type == HvWebField::INPUT_FLOAT) {
      char text[40]; sprintf(text, "%g", value);
      Widget labelW = widgetList[VALUE_LABEL] =
         XtVaCreateManagedWidget("label",
            xmTextFieldWidgetClass, form,
            XmNvalue,            text,
            XmNcolumns,          12,
            XmNleftAttachment,   XmATTACH_POSITION,
            XmNleftOffset,       HvUIOffset,
            XmNleftPosition,     50,
            XmNrightAttachment,  XmATTACH_FORM,
            XmNrightOffset,      HvUIOffset,
            XmNbottomAttachment, XmATTACH_FORM,
            XmNbottomOffset,     HvUIOffset,
            XmNtopAttachment,    XmATTACH_FORM,
            XmNtopOffset,        HvUIOffset,
            NULL);
   }
   else if (type == HvWebField::INPUT_STRING) {
      Widget labelW = widgetList[VALUE_LABEL] =
         XtVaCreateManagedWidget("label",
            xmTextFieldWidgetClass, form,
            XmNvalue,            (char *)string.getString(),
            XmNcolumns,          12,
            XmNleftAttachment,   XmATTACH_POSITION,
            XmNleftOffset,       HvUIOffset,
            XmNleftPosition,     50,
            XmNrightAttachment,  XmATTACH_FORM,
            XmNrightOffset,      HvUIOffset,
            XmNbottomAttachment, XmATTACH_FORM,
            XmNbottomOffset,     HvUIOffset,
            XmNtopAttachment,    XmATTACH_FORM,
            XmNtopOffset,        HvUIOffset,
            NULL);
   }
   else if (type == HvWebField::INPUT_SLIDER) {
      int val =
         (int)((sliderValue - sliderMin)/(sliderMax - sliderMin)*SLIDER_MAX);
      Widget labelW = widgetList[VALUE_LABEL] =
         XtVaCreateManagedWidget("label",
            xmScaleWidgetClass, form,
            XmNvalue,            val,
            XmNminimum,          0,
            XmNmaximum,          SLIDER_MAX,
            XmNorientation,      XmHORIZONTAL,
            XmNleftAttachment,   XmATTACH_POSITION,
            XmNleftOffset,       HvUIOffset,
            XmNleftPosition,     40,
            XmNrightAttachment,  XmATTACH_FORM,
            XmNrightOffset,      HvUIOffset,
            XmNbottomAttachment, XmATTACH_FORM,
            XmNbottomOffset,     HvUIOffset,
            XmNtopAttachment,    XmATTACH_FORM,
            XmNtopOffset,        HvUIOffset,
            NULL);
      XtAddCallback(labelW, XmNvalueChangedCallback,
            (XtCallbackProc) HvWebFunction::startCB,
	    (XtPointer) wfn); 
//      XtAddCallback(labelW, XmNdragCallback,
//            (XtCallbackProc) HvWebFunction::startCB,
//	    (XtPointer) wfn); 
   }
   else if (type == HvWebField::INPUT_LIST) {
      int nVis = listItems.getLength();
      if (nVis > 15) nVis = 15;
      Cardinal n = 0;
      Arg args[20];
      XtSetArg(args[n], XmNselectionPolicy,  XmEXTENDED_SELECT); n++;
      XtSetArg(args[n], XmNvisibleItemCount, nVis); n++;
      XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED); n++;
      XtSetArg(args[n], XmNlistSizePolicy,   XmRESIZE_IF_POSSIBLE); n++;
      XtSetArg(args[n], XmNleftAttachment,   XmATTACH_FORM); n++;
      XtSetArg(args[n], XmNleftOffset,       HvUIOffset); n++;
      XtSetArg(args[n], XmNrightAttachment,  XmATTACH_FORM); n++;
      XtSetArg(args[n], XmNrightOffset,      HvUIOffset); n++;
      XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
      XtSetArg(args[n], XmNbottomOffset,     HvUIOffset); n++;
      XtSetArg(args[n], XmNtopAttachment,    XmATTACH_WIDGET); n++;
      XtSetArg(args[n], XmNtopWidget,        widgetList[TOGGLE_BUTTON]); n++;
      XtSetArg(args[n], XmNtopOffset,        HvUIOffset); n++;
      Widget labelW = widgetList[VALUE_LABEL] =
         XmCreateScrolledList(form, "label", args, n);
      XtManageChild(labelW);
      XtAddCallback(labelW, XmNextendedSelectionCallback,
            (XtCallbackProc) HvWebFunction::startCB,
	    (XtPointer) wfn);
      int ni = listItems.getLength();
      for (int i = 0; i < ni; i++) {
         XmString str =
	    XmStringCreateSimple((char *)((SbString *)listItems[i])->getString());
      	 XmListAddItem(labelW, str, 0);
	 XmStringFree(str);
      }
   }
   else if (type == HvWebField::OUTPUT_FIELD) {
      XmString xstring = XmStringCreateSimple((char *)label.getString());
      Widget label = widgetList[VALUE_LABEL] =
         XtVaCreateManagedWidget("label",
            xmLabelWidgetClass, form,
            XmNlabelString,      xstring,
            XmNleftAttachment,   XmATTACH_WIDGET,
            XmNleftOffset,       HvUIOffset,
            XmNleftWidget,     	 widgetList[TOGGLE_BUTTON],
            XmNbottomAttachment, XmATTACH_FORM,
            XmNbottomOffset,     HvUIOffset,
            XmNtopAttachment,    XmATTACH_FORM,
            XmNtopOffset,        HvUIOffset,
            NULL);
      XmStringFree(xstring);
   }

   XmStringFree(emptyString);

   return form;
}

SoNode *searchNodeType(SoNode *node, SoType type)
{
    if (node->getTypeId() == type) return node;

    if (node->getTypeId().isDerivedFrom(SoGroup::getClassTypeId())) {
    	SoGroup *group = (SoGroup *) node;
	int numChildren = group->getNumChildren();
    	for (int i = 0; i < numChildren; i++) {
	    SoNode *n = group->getChild(i);
	    SoNode *ret = searchNodeType(n, type);
	    if (ret != NULL) return ret;
	}
    }

    return NULL;
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//
// Use: public

void
HvWebField::updateFieldReference(void)
//
////////////////////////////////////////////////////////////////////////
{
    if (fieldName == "") {	// special field
//	cerr << "HvWebField: can't update, no field name given\n";
	return;
    }
    if (nodeType == SoNode::getClassTypeId()) {
	cerr << "HvWebField: can't update, no node type given\n";
	return;
    }

//    SoSearchAction sa;
//    sa.setType(nodeType, FALSE);
//    sa.apply(parentNode);
    SoNode *node = searchNodeType((SoNode*) parentNode, nodeType);
    if (node == NULL) {
	cerr << "HvWebField: can't update, no node of type (" <<
	    nodeType.getName().getString() << ") found\n";
	return;
    }
    SoField *f = node->getField(SbName(fieldName.getString()));
    if (f != NULL) field = f;
    else
	cerr << "HvWebField: couldn't update field (" <<
	    fieldName.getString() << ")\n";
}



#ifdef UNDO
////////////////////////////////////////////////////////////////////////
//
// Description:
//   make a backup for the undo function
//   to store the actual content in a String is elegant but
//   not effective/fast/efficient
//
// Use: public

void
HvWebField::makeBackup()
//
////////////////////////////////////////////////////////////////////////
{
   if (!field) return;

   field->get(undoCopy);
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//   restore backup values
//
// Use: public

void
HvWebField::undo()
//
////////////////////////////////////////////////////////////////////////
{
   if (!field) return;

   field->get(redoCopy);
   field->set(undoCopy.getString());
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//   restore backup values
//
// Use: public

void
HvWebField::redo()
//
////////////////////////////////////////////////////////////////////////
{
   if (!field) return;

   field->set(redoCopy.getString());
}
#endif /* UNDO */
