/*
 * Copyright (C) 1996   Silicon Graphics, Inc.
 *
 _______________________________________________________________________
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 |
 |   $Revision: 1.0 $
 |
 |   Classes:
 |      HvURLHandler
 |
 |   Author(s)          : Horst Vollhardt
 |
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 _______________________________________________________________________
 */

#include <iostream.h>

#include "HvURLHandler.h"


////////////////////////////////////////////////////////////////////////
//
// Description:
//    Constructor
//
// Use: public

HvURLHandler::HvURLHandler(const char *url) : HvURLClient(url)
//
////////////////////////////////////////////////////////////////////////
{
   state = FIRST_CALL;
   binaryOutput = FALSE;
   bytesSend = 0;
}


////////////////////////////////////////////////////////////////////////
//
// Description:
//    Destructor
//
// Use: public

HvURLHandler::~HvURLHandler()
//
////////////////////////////////////////////////////////////////////////
{
}


////////////////////////////////////////////////////////////////////////
//
// Description:
//    connects to httpd, sends GET, and receives buffer
//    returns TRUE if session is completed
//    (there are intentionally no breaks used)
//
// Use: public

SbBool
HvURLHandler::run(const char *query)
//
////////////////////////////////////////////////////////////////////////
{
   switch (state) {
      case HvURLHandler::FIRST_CALL:
         state = HvURLHandler::BINDING;

      case HvURLHandler::BINDING:
         if (bindSocket() < 0)      return FALSE;
         state = HvURLHandler::NON_BLOCKING;

      case HvURLHandler::NON_BLOCKING:
         if (makeNonblocking() < 0) return FALSE;
         state = HvURLHandler::CONNECTING;

      case HvURLHandler::CONNECTING:
         if (connectSocket() <= 0) return FALSE;
         state = HvURLHandler::SET_BUFFER;

      case HvURLHandler::SET_BUFFER:
	 set("GET ");
         append(getFilename());
	 appendQueryToURL(query);
	 append("\n");
	 bytesSend = 0;
         state = HvURLHandler::SENDING;

      case HvURLHandler::SENDING:
         bytesSend += send(bytesSend, TRUE);   // ASCII mode
	 if (bytesSend < getLength()) return FALSE;
         state = HvURLHandler::CLEAR_BUFFER;

      case HvURLHandler::CLEAR_BUFFER:
      	 if (clear() == -1) return FALSE;
         state = HvURLHandler::RECEIVING;

      case HvURLHandler::RECEIVING:
         int ret = receive(returnsBinary());  // ASCII or "Binary"
         if (ret < 0) return FALSE;
	 
         if (ret > 0) {
  	    if (returnsBinary()) {
	       if (!isComplete()) return FALSE;
	    }
	    else {
	       return FALSE;
	    }
	 }
         state = HvURLHandler::FINISHING;

      case HvURLHandler::FINISHING:
         closeConnection();
         state = HvURLHandler::LAST_CALL;
	 return TRUE;

      case HvURLHandler::LAST_CALL:

      default:
         cerr << "You shouldn't show up here !\n";
         break;
   }

   // shouldn't show up here
   return TRUE;
}
