//  -*- C++ -*-

/*
 * HvURLClient.h
 *
 *	This file defines the HvURLClient class.
 *
 * Copyright 1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
 */

#ident "$Revision: 1.0 $"

#ifndef  __HV_URL_CLIENT_H__
#define  __HV_URL_CLIENT_H__


#include "HvClient.h"


//////////////////////////////////////////////////////////////////////////////
//
//  Class: HvURLClient
//
//	network client connecting to a http daemon
//
//////////////////////////////////////////////////////////////////////////////

class HvURLClient : public HvClient {

   public:

      // Constructors
      HvURLClient(const char *url = NULL);

      // Destructor
      ~HvURLClient();

      int setURL(const char *url);
      const char *getURL() { return URL.getString(); }

      // set file name part of the url
      void setFilename(const char *file) { filename = file; }
      const char *getFilename() { return filename.getString(); }

      // return query string which can be appended to the URL
      void appendQueryToURL(const char *str);

   private:

      SbString			URL, filename;

      int splitURL(char* &host, int &port, char* &file);
};

#endif  /* !__HV_URL_CLIENT_H__ */
