/*
 * Copyright (C) 1996   Silicon Graphics, Inc.
 *
 _______________________________________________________________________
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 |
 |   $Revision: 1.0 $
 |
 |   Classes:
 |      HvURLClient
 |
 |   Author(s)          : Horst Vollhardt
 |
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 _______________________________________________________________________
 */

#include "HvURLClient.h"


////////////////////////////////////////////////////////////////////////
//
// Description:
//    Constructor
//
// Use: public

HvURLClient::HvURLClient(const char *url) : HvClient()
//
////////////////////////////////////////////////////////////////////////
{
   if (url != NULL) setURL(url);
}


////////////////////////////////////////////////////////////////////////
//
// Description:
//    Destructor
//
// Use: public

HvURLClient::~HvURLClient()
//
////////////////////////////////////////////////////////////////////////
{
}


////////////////////////////////////////////////////////////////////////
//
// Description:
//    sets the URL and splits it
//    returns -1 on error
//
// Use: public

int
HvURLClient::setURL(const char *url)
//
////////////////////////////////////////////////////////////////////////
{
   URL = url;

   int p;
   char *host, *file;
   if (splitURL(host, p, file) < 0) return -1;

   setHostname(host);
   setFilename(file);
   setPort(p);

   delete [] host;
   delete [] file;

   return 0;
}


////////////////////////////////////////////////////////////////////////
//
//  split given URL into host, port and file
//  returns -1 on error
//  
// Use: public

int
HvURLClient::splitURL(char* &host, int &port, char* &file)
//
////////////////////////////////////////////////////////////////////////
{
   char* http = "http://";
   int httpLen = strlen(http);
   const char *url = URL.getString();
   if (!SbString(url)) return -1;
   if (strncmp(http, url, httpLen)) return -1;  // no http protocol

   // get the host name
   const char *s;
   for (s = url + strlen(http) + 1; *s && (*s != ':') && (*s != '/'); s++);

   int hostnameLen = s - url;
   hostnameLen -= httpLen;
   host = new char[hostnameLen + 1];  // no error checking

   strncpy(host, url + httpLen, hostnameLen);
   host[hostnameLen] = '\0';

   // get port number
   if (*s == ':') {
      port = atoi(++s);
      while (*s && (*s != '/')) s++;
   }
   else { port = 80; }

   // get the file name
   if (*s == '/') {
      int filenameLen = strlen(s);
      file = new char[filenameLen + 1];
      strncpy(file, s, filenameLen);
      file[filenameLen] = '\0';
   }
   else {
      file = new char[2];
      file[0] = '/'; file[1] = '\0';
   }
return 0;
}


////////////////////////////////////////////////////////////////////////
//
//  appends query string to the data in the buffer
//
//  URL    :=  http://HOST[:PORT][/FILE[?QUERY]]
//  QUERY  :=  [VAL1=]QUERY1[&VAL2=QUERY2][...]
//  
// Use: public

void
HvURLClient::appendQueryToURL(const char *str)
//
////////////////////////////////////////////////////////////////////////
{
   if (str == NULL) return;

   SbString newURL = "";

   // no URL defined
   if (!URL) return;

   // filename part of URL is empty
   if (!filename) return;

   // does the filename part already contain a query string ?
   if (strchr(filename.getString(), '?'))
      append("&", 1);
   else
      append("?", 1);

   append(str);
}

