/*
 * HvSocket.h
 *
 *	This file defines network functions.
 *
 * Copyright 1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
 */

#ident "$Revision: 1.0 $"

#ifndef  __HV_SOCKET_H__
#define  __HV_SOCKET_H__

#include <unistd.h>
#include <netinet/in.h>

#include <Inventor/SbString.h>
#include <Inventor/SbBasic.h>


class HvSocket {
    public:
       // Constructor / Destructor
       HvSocket();
       HvSocket(const char *url);
       ~HvSocket();

       // set/get network connection parameter
       const char *getHostname() { return hostname.getString(); }
       void setHostname(const char *host) { hostname = host; }

       const char *getFilename() { return filename.getString(); }
       void setFilename(const char *file) { filename = file; }

       int  getPort()      { return port; }
       void setPort(int p) { port = p; }

       int  getSocket()    { return sock; }

       // networking functions
       int sendData(const char *data, int len);
       int receiveData();
       int makeNonblocking();
       int bindSocket();
       int connectSocket();
       void close() { ::close(sock); }


       // function to manipulate the buffer
       const char *getBuffer() { return buffer; }
       int getActLength() { return actLength; }
       int getMaxLength() { return maxLength; }

       SbBool isComplete();

       void clearBuffer() { actLength = 0; }

       // pop one block from the top of the buffer (see below)
       void popBuffer();
       void appendBuffer(const char *str, int len);

       // append string to the filename part of the URL
       SbString appendQueryToURL(const char *str);

    private:
       // networking stuff
       int 			sock, port;
       SbString 		hostname, filename;
       struct sockaddr_in 	sin;

       // network buffer
       // general structure :=  |1. Block|2. Block|...|n. Block|
       // Block :=  |(int) len|(char[len-4]) data|
       char 			*buffer;
       int			actLength, maxLength;

       // URL used to construct this instance
       SbString			URL;

       int splitURL(char* &host, int &port, char* &file);
};

#endif  /* !__HV_SOCKET_H__ */
