/*
 * Copyright (C) 1996   Silicon Graphics, Inc.
 *
 _______________________________________________________________________
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 |
 |   $Revision: 1.0 $
 |
 |   Classes:
 |      HvServer
 |
 |   Author(s)          : Horst Vollhardt
 |
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 _______________________________________________________________________
 */

#include <errno.h>
#include <iostream.h>
#include <stdio.h>


#include "HvServer.h"


////////////////////////////////////////////////////////////////////////
//
// Description:
//    Constructor
//
// Use: public

HvServer::HvServer(int port)
//
////////////////////////////////////////////////////////////////////////
{
   setPort(port);
   sock = -1;
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Destructor
//
// Use: public

HvServer::~HvServer()
//
////////////////////////////////////////////////////////////////////////
{
   closeConnection();
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    create a socket, bind it to a name and listen at it
//    returns -1 on error or the new socket descriptor
//
// Use: public

int
HvServer::createSocket()
//
////////////////////////////////////////////////////////////////////////
{
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
#ifdef DEBUG
       perror("\tsocket");
#endif
       return -1;
    }

    bzero(&sin, sizeof(sin));
    sin.sin_family = AF_INET;
    sin.sin_addr.s_addr = INADDR_ANY;
    sin.sin_port = port;
    if (bind(sock, &sin, sizeof(sin)) < 0) {
#ifdef DEBUG
       perror("\tbind");
#endif
       return -1;
    }

    if (listen(sock, 5) < 0) {
#ifdef DEBUG
       perror("\tlisten");
#endif
       return -1;
    }

    return sock;
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    waiting for a client to connect
//    returns -1 on error or the new socket descriptor
//
// Use: public

int
HvServer::acceptConnection()
//
////////////////////////////////////////////////////////////////////////
{
    int len = sizeof(sin);

    int s = accept(sock, &sin, &len);
    if (s < 0) {
#ifdef DEBUG
       perror("\taccept");
#endif
       return -1;
    }

    return s;
}


////////////////////////////////////////////////////////////////////////
//
// Description:
//    close one connection and remove socket from list
//
// Use: public

void
HvServer::closeConnection()
//
////////////////////////////////////////////////////////////////////////
{
    close(sock);
}
