/*
 * HvNetBuffer.h
 *
 *	This file defines the HvNetBuffer class.
 *
 * Copyright 1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
 */

#ident "$Revision: 1.0 $"

#ifndef  __HV_NET_BUFFER_H__
#define  __HV_NET_BUFFER_H__


#include <Inventor/SbBasic.h>
#include <Inventor/SbString.h>

#define S_INT		sizeof(int)
#define INITIAL_LENGTH	256


//////////////////////////////////////////////////////////////////////////////
//
//  Class: HvNetBuffer
//
//	Standalone buffer which can send and receive data over
//	the network and implements its own "protocol" 
//
// 	general structure :=  |(int) len|(char[len-S_INT]) data|
//
//////////////////////////////////////////////////////////////////////////////

class HvNetBuffer {

    public:
       // Constructor
       HvNetBuffer(int s = -1);

       // Destructor
       ~HvNetBuffer();

       void setSocket(int s) { sock = s; }
       int getSocket() { return sock; }

       // send buffer, returns bytes sent or -1 on error
       // because of non-blocking sockets this functions may has to be
       // called several times until it everything is send
       int send(int offset = 0, SbBool dataOnly = FALSE);
       int sendPipe(int offset = 0, SbBool dataOnly = FALSE);
       
       // first call clear(); returns -1 on error, bytes read, or 0 for EOF
       // because of non-blocking sockets this functions may has to be
       // called several times until isComplete() returns TRUE
       int receive(SbBool binaryMode = TRUE);

       // functions to manipulate the buffer
       int set(const void *data, int len = 0);
       int set(const char data);
       int set(const short data);
       int set(const int data);
       int set(const long data);
       int set(const float data);
       int set(const double data);
       int set(const char *data, int len);
       int set(const short *data, int len);
       int set(const int *data, int len);
       int set(const long *data, int len);
       int set(const float *data, int len);
       int set(const double *data, int len);
       int append(const void *data, int len = 0);
       int append(const char data);
       int append(const short data);
       int append(const int data);
       int append(const long data);
       int append(const float data);
       int append(const double data);
       int append(const char *data, int len);
       int append(const short *data, int len);
       int append(const int *data, int len);
       int append(const long *data, int len);
       int append(const float *data, int len);
       int append(const double *data, int len);

       int clear();

       // return length of the data part
       int getLength() { return length; }

       // return data part of the buffer (see below)
       const void *get(int &len);

       SbBool isComplete();

	   SbBool addPipe(SbString name);
	   SbBool isPiped() {return ispiped;}
	   
    protected:

       // socket
       int 			sock;
	   
	   // pipes
	   int			pipe[4];
	   int			numPipes;


    private:

       // network buffer
       char 			*buffer;
       int			length, maxLength;
	   int			ispiped;
	   
       // read defined portion of the buffer (or less)
       int reallyRead(int bytesToRead, int offset);
};

#endif  /* !__HV_NET_BUFFER_H__ */

