//  -*- C++ -*-

/*
 * Copyright (C) 1995   Silicon Graphics, Inc.
 *
 _______________________________________________________________________
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 |
 |   $Revision: 1.10 $
 |
 |   Description:
 |      This file defines the HvManagerP node class
 |
 |   Author(s)      : Horst Vollhardt, Mark Benzel
 |
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 _______________________________________________________________________
 */

#ifndef  __HV_MANAGER_P_H__
#define  __HV_MANAGER_P_H__

#include <Xm/Xm.h>
#include <Vk/xpm.h> // stuff to build color icons pixmaps

#include <Inventor/SoLists.h>
#include <Inventor/SbLinear.h>
#include <Inventor/SoOutput.h>
#include <Inventor/fields/SoSFBool.h>
#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/fields/SoMFString.h>
#include <Inventor/fields/SoSFString.h>
#include <Inventor/fields/SoSFNode.h>
#include <Inventor/sensors/SoFieldSensor.h>
#include <Inventor/actions/SoGLRenderAction.h>
#include <Inventor/nodes/SoOrthographicCamera.h>
#include <Inventor/nodes/SoSeparator.h>

#include "HvWebFunction.h"
#include "HvClientHandlerP.h"
#include "HvGraph.h"
#include "tsTopology.h"


//////////////////////////////////////////////////////////////////////////////
//
//  Class: HvManagerP
//
//  SoNode class that manages a user interface for Molecular Inventor
//
//////////////////////////////////////////////////////////////////////////////

class HvManagerP : public SoSeparator {

    SO_NODE_HEADER(HvManagerP);

  public:

    // Fields:
    SoSFString pipe;		// list of function server
    SoSFBool monitor;		// monitor some performance statistics
	SoSFInt32 _grphstate;	// the current graph state, this field
							// should not be used in a scene graph
							// it is used to sync child viewers

    // Constructor
    HvManagerP();
    HvManagerP(int numChildren);

  SoEXTENDER public:
    virtual void GLRender(SoGLRenderAction *action);
    virtual void GLRenderBelowPath(SoGLRenderAction *action);
    virtual void GLRenderInPath(SoGLRenderAction *action);
    virtual void GLRenderOffPath(SoGLRenderAction *action);

  SoINTERNAL public:
    static void     initClass();

  protected:
    virtual ~HvManagerP();

  private:

    enum State {
       FIRST_CALL,
       BUILD_GRAPH,
       SEND_GRAPH,
       SEND_PATH,
       BUILD_PATH,
       LAST_CALL
    };

    // actual camera used by the viewer
    SoCamera		*actualCamera;
    SoGroup		*cameraParent, *cameraRoot;
    // reference camera to check for differences
    SoOrthographicCamera	*refCamera;

    // Sensors
    SoFieldSensor 	timeSensor;
    SoFieldSensor 	delayedSensor;


	// topology of the graph
	tsTopology		topology;
	
    // associated state
    int			delayedState;

    // handle server connections
    HvClientHandlerP	delayedHandler;

    // network statistic data
    HvGraph graphIn, graphInSec;

    // output buffer to store the scene graphs temp.
    SoOutput		output;
    void		*outputBuffer;
  //  const void *writeSceneGraph(SoNode *node, size_t &size);
  //  void writePath(const SoPath *path, SbIntList &list);

    int readSceneGraph(const char *buffer, int len);
    int readPath(const char *buffer);

	SoNode* readSubGraph(int *buf);
	void	readChange(int *buf);
	SoPath*	readSoPath(int *buf);

    void attachDelayedSensor();
    void detachDelayedSensor();
    static void delayedCB(HvManagerP *manager, SoSensor *s);
    void synchronizeGraph();
    void readServerOutput();

    void setNodeDefault(SoNode *node, SoFieldList &fieldList);
    void setAllDefault(SoPath *path, SoFieldList &fieldList,
                       SbIntList &saveList, SbIntList &notifyList);
    void resetAllDefault(SoPath *path, SoFieldList &fieldList,
                         SbIntList &saveList, SbIntList &notifyList);

    void constructorCommon();

    virtual void renderButton(SoGLRenderAction *action);

	// is started. this one is true, after the first glrenderactin
	int isStarted;
};

#endif  /* !__HV_MANAGER_P_H__ */
