//  -*- C++ -*-

/*
 * Copyright (C) 1995   Silicon Graphics, Inc.
 *
 _______________________________________________________________________
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 |
 |   $Revision: 1.10 $
 |
 |   Description:
 |      This file defines the HvManager node class
 |
 |   Author(s)      : Horst Vollhardt, Mark Benzel
 |
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 _______________________________________________________________________
 */

#ifndef  __HV_MANAGER_H__
#define  __HV_MANAGER_H__

#include <Xm/Xm.h>
#include <Vk/xpm.h> // stuff to build color icons pixmaps

#include <Inventor/SoLists.h>
#include <Inventor/SbLinear.h>
#include <Inventor/SoOutput.h>
#include <Inventor/fields/SoSFBool.h>
#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/fields/SoMFString.h>
#include <Inventor/fields/SoSFString.h>
#include <Inventor/sensors/SoFieldSensor.h>
#include <Inventor/sensors/SoNodeSensor.h>
#include <Inventor/actions/SoGLRenderAction.h>
#include <Inventor/nodes/SoOrthographicCamera.h>
#include <Inventor/nodes/SoSeparator.h>

#include "HvWebFunction.h"
#include "HvClientHandler.h"
#include "HvGraph.h"
#include "tsTopology.h"

//////////////////////////////////////////////////////////////////////////////
//
//  Class: HvManager
//
//  SoNode class that manages a user interface
//
//////////////////////////////////////////////////////////////////////////////

class HvManager : public SoSeparator {

    SO_NODE_HEADER(HvManager);

  public:

    // Fields:
    SoMFString url;		// list of function server
    SoSFString server;		// collaboration server
    SoSFInt32 id;		// session id
    SoSFBool autoConnect;	// automatically connect to servers ?
    SoSFBool monitor;		// monitor some performance statistics
	SoMFString pipes;       // list of filenames to write changes
	SoSFBool webButton;     // show the web button ?
	SoSFInt32 _grphstate;	// the current graph state, this field
							// should not be used in a scene graph
							// it is used to sync child viewers
    // Constructor
    HvManager();
    HvManager(int numChildren);

  SoEXTENDER public:
    virtual void GLRender(SoGLRenderAction *action);
    virtual void GLRenderBelowPath(SoGLRenderAction *action);
    virtual void GLRenderInPath(SoGLRenderAction *action);
    virtual void GLRenderOffPath(SoGLRenderAction *action);

  SoINTERNAL public:
    static void     initClass();

    // Get information regarding the popup or overlay planes
#ifdef IV2_0
    static void getPopupArgs(Display *d, int scr, ArgList args, int *n);
    static void registerColormapLoad(Widget widget, Widget shell);
    static void addColormapToShell(Widget widget, Widget shell);
    static void removeColormapFromShell(Widget widget, Widget shell);
#endif

    // Builds the pixmaps
    static void buildColorPixmaps(Widget button, char **data, Pixmap pixmap[3]);

    // Apply pixmaps
    static void setPixmaps(Widget button, Pixmap pixmap[3]);


  protected:
    virtual ~HvManager();

  private:
    // glx Windows
    SbIntList		windowList;
    SbPList		glxList, buttonGlxList, parentGlxList;

    SbBool removeEventHandler;

    // widgets
    Widget		*widgetList;

    //pixmaps
    Pixmap stopPixmap[3], goPixmap[3];

    // Each time a HvManager is made, it is added to the instanceList.
    static SbPList *instanceList;

    // This keep track of the size of the menu.
    static int menuWidth;
    static int menuHeight;

    // Create the user interface
    Widget		createGlxWindowButtons(Widget parent);

    // Builds the icons
    Widget buildColorButton(Widget parent, int id, char **data);

    // Callbacks
    // When click on an icon, iconCB is invoked
    static void iconCB(Widget w, int id, void *);

    // Make sure the user interface stays on top
    static void glxStackingOrderChangeCB(Widget, Widget, XAnyEvent *, 
					Boolean *);

    // Cleanup when finished
    static void glxDestroyedCB(Widget, HvManager *, XtPointer);
    static void glxButtonsDestroyedCB(Widget, HvManager *, XtPointer);

    // Handle structure notify events 
    static void shellStructureNotifyCB(Widget, HvManager *p, XEvent *xe,
                    Boolean *);

    // Get information regarding the popup or overlay planes
#ifdef IV2_0
    static void getPopupArgs(Display *d, int scr, ArgList args, int *n);
#endif

    // Layout the menus if one has been removed
    static void layoutInstances();
    static void positionMenu(HvManager *cui, const Widget &parent,
        int whichInstance);



  public:

#ifdef UNDO
    // add a function to the call stack;
    void registerWebFunction(HvWebFunction *wfn);
#endif /* UNDO */

  private:
    enum State {
       FIRST_CALL,
       BUILD_GRAPH,
       SEND_GRAPH,
       SEND_PATH,
       BUILD_PATH,
       LAST_CALL
    };

    // actual camera used by the viewer
    SoCamera		*actualCamera, *sharedCamera;
    SoGroup		*cameraParent, *cameraRoot;
    // reference camera to check for differences
    SoOrthographicCamera	*refCamera;

    // Sensors
    SoFieldSensor 	timeSensor;
    SoNodeSensor	nodeSensor;
    SoFieldSensor 	delayedSensor;

    // lists to store changed nodes for delayed transmission
    SoNodeList		delayedNodeList;
    SoPathList		delayedPathList;
    SbPList			delayedNodeFieldList;

	// topology of the graph
	tsTopology		topology;
	
    // associated state
    int			delayedState;

    // handle server connections
    HvClientHandler	delayedHandler;

    // network statistic data
    HvGraph graphIn, graphInSec;

    // output buffer to store the scene graphs temp.
    SoOutput		output;
    void		*outputBuffer;
    const void *writeSceneGraph(SoNode *node, size_t &size);
    void writePath(const SoPath *path, SbIntList &list);

    int readSceneGraph(const char *buffer, int len);
    int readPath(const char *buffer);

	SoNode* readSubGraph(int *buf);
	void	readChange(int *buf);
	SoPath*	readSoPath(int *buf);

    void attachDelayedSensor();
    void detachDelayedSensor();
    void attachNodeSensor();
    void detachNodeSensor();
    static void delayedCB(HvManager *manager, SoSensor *s);
    void synchronizeGraph();
    void readServerOutput();

    void setNodeDefault(SoNode *node, SoFieldList &fieldList);
    void setAllDefault(SoPath *path, SoFieldList &fieldList,
                       SbIntList &saveList, SbIntList &notifyList);
    void resetAllDefault(SoPath *path, SoFieldList &fieldList,
                         SbIntList &saveList, SbIntList &notifyList);

    void constructorCommon();
    static void nodeSensorCB(void *data, SoSensor *s);

    virtual void renderButton(SoGLRenderAction *action);

    static void readWebFunctionInterfaceCB(HvManager *, SoSensor *);

    // Invoked by the web menu button
    static void webButtonCB(Widget w, int id, void *);

    // Close the preferences dialog
    static void webMenuClosedCB(Widget, void *info, XmAnyCallbackStruct *);

    // undo/redo function
    static void webMenuUndoCB(Widget, void *, void *);
    static void webMenuRedoCB(Widget, void *, void *);

    // Dialog iconify variables
    SbBool      webMenuVisible;
    SbBool	menuNeedToDeiconify;

    // description of function interfaces
    SbPList		webFunctionList, wfnLoadList, urlList;

    void buildWebMenuDialog();

    // Creates and/or opens the web menu
    void   openWebMenu();

    // Builds the web menu button
    Widget buildWebButton(Widget parent);

    // last called webFunction
    HvWebFunction *lastFunction;
		
	// isStarted
	int isStarted;
};

#endif  /* !__HV_MANAGER_H__ */
