//  -*- C++ -*-

/*
 * Copyright (C) 1997   Silicon Graphics, Inc.
 *
 _______________________________________________________________________
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 |
 |   $Revision: 1.1 $
 |
 |   Description:
 |      This file defines the HvGroup node class
 |
 |   Author(s)      : Horst Vollhardt
 |
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 _______________________________________________________________________
 */

#ifndef  __HV_GROUP_H__
#define  __HV_GROUP_H__


#include <Inventor/fields/SoMFColor.h>
#include <Inventor/fields/SoMFFloat.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/sensors/SoFieldSensor.h>


//////////////////////////////////////////////////////////////////////////////
//
//  Class: HvGroup
//
//  SoSeparator class that manipulates its SoCube children
//
//////////////////////////////////////////////////////////////////////////////

class HvGroup : public SoSeparator {

    SO_NODE_HEADER(HvGroup);

  public:

    // Fields:
    SoMFFloat values;		// list of cube depth values
    SoMFColor colors;		// list of cube depth values

    // Constructor
    HvGroup();
    HvGroup(int numChildren);
    void constructorCommon(void);

  SoINTERNAL public:
    static void     initClass();

  protected:
    virtual ~HvGroup();

  private:
    SoFieldSensor valuesSensor;
    SoFieldSensor colorsSensor;

    static void valuesChangedCB(void *data, SoSensor *sensor);
    static void colorsChangedCB(void *data, SoSensor *sensor);
};

#endif   /* !__HV_GROUP_H__ */
