/*
 * Copyright (C) 1997   Silicon Graphics, Inc.
 *
 _______________________________________________________________________
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 |
 |   $Revision: 1.1 $
 |
 |   Classes:
 |      HvGroup
 |
 |   Author(s)          : Horst Vollhardt
 |
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 _______________________________________________________________________
 */

#include <iostream.h>

#include <Inventor/actions/SoSearchAction.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoMaterial.h>

#include "HvGroup.h"


SO_NODE_SOURCE(HvGroup);

////////////////////////////////////////////////////////////////////////
//
//  Initialize the class
//  
void HvGroup::initClass()
//
////////////////////////////////////////////////////////////////////////
{
    SO_NODE_INIT_CLASS(HvGroup, SoSeparator, "Separator");
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Constructor
//
// Use: public

HvGroup::HvGroup()
//
////////////////////////////////////////////////////////////////////////
{
   constructorCommon();
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Constructor
//
// Use: public

HvGroup::HvGroup(int numChildren) : SoSeparator(numChildren)
//
////////////////////////////////////////////////////////////////////////
{
   constructorCommon();
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    common part of all constructor
//
// Use: private

void
HvGroup::constructorCommon(void)
//
////////////////////////////////////////////////////////////////////////
{
    SO_NODE_CONSTRUCTOR(HvGroup);

    SO_NODE_ADD_FIELD(values, (0.0));
    SO_NODE_ADD_FIELD(colors, (0.0, 0.0, 0.0));

    valuesSensor.setFunction((SoSensorCB *)valuesChangedCB);
    valuesSensor.setData(this);
    valuesSensor.attach(&values);

    colorsSensor.setFunction((SoSensorCB *)colorsChangedCB);
    colorsSensor.setData(this);
    colorsSensor.attach(&colors);
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    Destructor
//
// Use: private

HvGroup::~HvGroup()
//
////////////////////////////////////////////////////////////////////////
{
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    change children if values have changed
//
// Use: private

void
HvGroup::valuesChangedCB(void *data, SoSensor *s)
//
////////////////////////////////////////////////////////////////////////
{
    HvGroup *This = (HvGroup *)data;
    SoFieldSensor &sensor = *(SoFieldSensor *)s;

//    if (sensor.getTriggerField() == &This->values) {
	SoSearchAction sa;
	sa.setType(SoCube::getClassTypeId(), TRUE);
	sa.setInterest(SoSearchAction::ALL);
	sa.apply(This);
	SoPathList pathList = sa.getPaths();
	for (int i = 0; i < pathList.getLength(); i++) {
	    SoCube *cube = (SoCube *)pathList[i]->getTail();
	    cube->depth = This->values[i];
	}
//    }
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    change children if colors have changed
//
// Use: private

void
HvGroup::colorsChangedCB(void *data, SoSensor *s)
//
////////////////////////////////////////////////////////////////////////
{
    HvGroup *This = (HvGroup *)data;
    SoFieldSensor &sensor = *(SoFieldSensor *)s;

//    if (sensor.getTriggerField() == &This->colors) {
	SoSearchAction sa;
	sa.setType(SoMaterial::getClassTypeId(), TRUE);
	sa.setInterest(SoSearchAction::ALL);
	sa.apply(This);
	SoPathList pathList = sa.getPaths();
	for (int i = 0; i < pathList.getLength(); i++) {
	    SoMaterial *material = (SoMaterial *)pathList[i]->getTail();
	    material->diffuseColor = This->colors[i];
	}
//    }
}
