//  -*- C++ -*-

/*
 * Copyright (C) 1996   Silicon Graphics, Inc.
 *
 _______________________________________________________________________
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 |
 |   $Revision: 1.1 $
 |
 |   Description:
 |	Class for rendering data y(time).
 |	The data is stored in a cyclic, constant size array.
 |	A new item replaces the oldest item.
 |      
 |
 |   Author(s)      : Horst Vollhardt
 |
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 _______________________________________________________________________
 */

#ifndef  __HV_GRAPH_H__
#define  __HV_GRAPH_H__

#include <Inventor/SbColor.h>
#include <Inventor/SbString.h>
#include <GL/gl.h>

#define HV_MAX_DATA	256	// must be power of 2


class SbPList;

//////////////////////////////////////////////////////////////////////////////
//
//  Class: HvGraph
//
//  
//
//////////////////////////////////////////////////////////////////////////////

class HvGraph {

  public:

    // Constructor
    HvGraph();

    // Destructor
    ~HvGraph();

    // set the accumulation time in mseconds
    void setInterval(int msec) { interval = msec; }

    // set the color of the graph
    void setColor(float r, float g, float b) { color.setValue(r, g, b); }

    // render graph
    void render();

    // append a new data value
    void append(long value);

  private:

    long x[HV_MAX_DATA];
    long y[HV_MAX_DATA];
    long time0;			// reference time to avoid overflows
    double average;		// average value;
    int  yMaxIndex;		// index to the larges y value
    int  start;			// first x,y pair
    int  interval;		// average over this time frame
    SbColor color;
    char maxText[40];		// don't expect more than 40 digits

    // Each time a HvGraph is made, it is added to the instanceList.
    static SbPList *instanceList;

    // private raster font for digits, offset into display list
    static GLuint fontOffset;
};

#endif  /* !__HV_GRAPH_H__ */
