//  -*- C++ -*-

/*
 * HvClientP.h
 *
 *	This file defines the HvClientP class.
 *
 * Copyright 1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
 */

#ident "$Revision: 1.0 $"

#ifndef  __HV_CLIENT_P_H__
#define  __HV_CLIENT_P_H__


#include <Inventor/SbString.h>

#include "HvNetBuffer.h"


//////////////////////////////////////////////////////////////////////////////
//
//  Class: HvClientP
//
//	Base class for managing a named pipe connection
//
//////////////////////////////////////////////////////////////////////////////

class HvClientP : public HvNetBuffer {

   public:

      // Constructors
      HvClientP(const char *pipe = NULL);

      // Destructor
      ~HvClientP();

      void setPipename(SbString pipe) { pipename = pipe; }
      const char *getPipename() { return pipename.getString(); }

      // networking functions
      int makeNonblocking();
      //int bindPipe();
      int connectPipe();

      // close socket
      void closeConnection();


   private:

      SbString			pipename;
};

#endif  /* !__HV_CLIENT_P_H__ */
