/*
 * Copyright (C) 1996   Silicon Graphics, Inc.
 *
 _______________________________________________________________________
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 |
 |   $Revision: 1.0 $
 |
 |   Classes:
 |      HvClientP
 |
 |   Author(s)          : Horst Vollhardt
 |
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 _______________________________________________________________________
 */

#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <stdio.h>
#include <errno.h>

#include "HvClientP.h"


////////////////////////////////////////////////////////////////////////
//
// Description:
//    Constructor
//
// Use: public

HvClientP::HvClientP(const char *pipe)
//
////////////////////////////////////////////////////////////////////////
{
   if (pipe != NULL) setPipename(pipe);
}


////////////////////////////////////////////////////////////////////////
//
// Description:
//    Destructor
//
// Use: public

HvClientP::~HvClientP()
//
////////////////////////////////////////////////////////////////////////
{
   closeConnection();
}


////////////////////////////////////////////////////////////////////////
//
// Description:
//    close one connection and remove socket from list
//
// Use: public

void
HvClientP::closeConnection()
//
////////////////////////////////////////////////////////////////////////
{
    //close(sock);
}


////////////////////////////////////////////////////////////////////////
//
//  make socket nonblocking
//  returns -1 on otherwise 0
//
// Use: public

int
HvClientP::makeNonblocking()
//
////////////////////////////////////////////////////////////////////////
{
   if (fcntl(sock, F_SETFL, FNDELAY) < 0) {

//#ifdef DEBUG
      perror("\tfcntl F_SETFL, FNDELAY");
//#endif
      return -1;
   }
   return 0;
}



////////////////////////////////////////////////////////////////////////
//
//  connect pipe 
//  returns -1 on error, socket id
//  
// Use: public

int
HvClientP::connectPipe()
//
////////////////////////////////////////////////////////////////////////
{
	fprintf(stderr, "client connect %s...\n", pipename.getString());
    sock = open(pipename.getString(),O_RDONLY);
	if (sock!=-1)
		fprintf(stderr, "client         %s ok\n", pipename.getString());
	else
		fprintf(stderr, "client         %s failed\n", pipename.getString());
	return sock;
}

