//  -*- C++ -*-

/*
 * HvClientList.h
 *
 *	This file defines the HvClientList class.
 *
 * Copyright 1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
 */

#ident "$Revision: 1.0 $"

#ifndef  __HV_CLIENT_LIST_H__
#define  __HV_CLIENT_LIST_H__


#include <unistd.h>

#include<Inventor/SbPList.h>

#include "HvNetBuffer.h"
#include "tsTopology.h"

class SoSeparator;
class SoNode;
class SoGroup;

#define B_CAST (HvNetBuffer *)

#include "HvCommId.h"

//////////////////////////////////////////////////////////////////////////////
//
//  Class: HvClientList
//
//	Base class for managing several network connections
//
//////////////////////////////////////////////////////////////////////////////

class HvClientList {

   public:

      // Constructors
      HvClientList(unsigned long id = 0);

      // Destructor
      ~HvClientList();

      void setId(unsigned long id) { systemId = id; }
      unsigned long getId() { return systemId; }

      int append(int s);

      void remove(int idx);

      int getSocket(int i) { return socketList[i]; }
      int getNum() { return socketList.getLength(); }

      void setPID(int p) { pid = p; }
      int getPID() { return pid; }

      void writeSceneGraph(const SbString &file);

      void closeConnection(int s) { close(s); }

      void closeAllConnections();

      // indexed access to the NetBuffer methods
      int receive(int i, SbBool binaryMode = TRUE) {
         return (B_CAST bufferList[i])->receive(binaryMode); }

      SbBool isComplete(int i) {
         return (B_CAST bufferList[i])->isComplete(); }

      int clear(int i) {
         return (B_CAST bufferList[i])->clear(); }

      const void *get(int i, int &len) {
         return (B_CAST bufferList[i])->get(len); }


      // methods to analyse requests
      int readSceneGraph(const char *data);
      int readPath(const char *data);
      SoNode* readSubGraph(int *buf);
      void    readChange(int *buf);
      SoPath* readSoPath(int *buf);
   
      // send data to client
      int sendSceneGraph(int sock);
      int sendPath(int client, const void *data, int len);
      int requestSceneGraph(int sock);


   private:
      unsigned long	systemId;

      // my own process id
      int		pid;

      SbIntList		socketList;
      SbPList		bufferList;

      HvNetBuffer	writeBuffer;

      // scene grap to manage
      SoSeparator	*sceneGraph;

      // directory where the final scene graph is stored
      SbString		dbDir;

      int makeNonblocking(int s);

#ifdef DEBUG2
      static void viewGraph(void *arg);
#endif

};


#endif  /* !__HV_CLIENT_LIST_H__ */
