//  -*- C++ -*-

/*
 * HvClientHandlerP.h
 *
 *	This file defines the HvClientHandlerP class.
 *
 * Copyright 1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
 */

#ident "$Revision: 1.0 $"

#ifndef  __HV_CLIENT_HANDLER_P_H__
#define  __HV_CLIENT_HANDLER_P_H__


#include "HvClientP.h"


//////////////////////////////////////////////////////////////////////////////
//
//  Class: HvClientHandlerP
//
//	handles one network session
//
//////////////////////////////////////////////////////////////////////////////

class HvClientHandlerP : public HvClientP {

   public:

      // Constructors
      HvClientHandlerP(const char *pipe = NULL);

      // Destructor
      ~HvClientHandlerP();


      enum State {
         FIRST_CALL,
         BINDING,
         NON_BLOCKING,
         CONNECTING,
         SET_BUFFER,
         SENDING,
         CLEAR_BUFFER,
         RECEIVING,
         FINISHING,
         LAST_CALL
      };

      // functions for receiving data
      SbBool read(SbBool binaryMode = TRUE);
      int getReadState() { return readState; }

      // additional read buffer, the build in buffer is used
      // for writing, therefore the get(), and isComplete() methods
      // must be overloaded
      HvNetBuffer	readBuffer;

      // overloaded methods to have read and write simultaniously
      const void *get(int &len) { return readBuffer.get(len); }
      SbBool isComplete() { return readBuffer.isComplete(); }
      void setSocket(int s) { sock = s; readBuffer.setSocket(s); }
     int getReadLength() { return readBuffer.getLength(); }



      // functions for sending data
      SbBool write(SbBool dataOnly = FALSE);
      SbBool flush();
      int getWriteState() { return writeState; }
      int getWriteLength() { return getLength(); }
 
      SbBool connect();
      SbBool isConnected() { return connected; }
	  SbBool isFinished()  { return finished; }
      // overloaded close connection method
      void closeConnection() {
         HvClientP::closeConnection(); connected = FALSE;
	 state = readState = writeState = FIRST_CALL;
      }
	
   protected:
      void setConnected(SbBool con) { connected = con; }


   private:

      int		state, readState, writeState;
      int		bytesSend;
      SbBool		connected;
      SbBool		writeMode;
	  SbBool		finished;
};

#endif  /* !__HV_CLIENT_HANDLER_H__ */
