/*
 * Copyright (C) 1996   Silicon Graphics, Inc.
 *
 _______________________________________________________________________
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 |
 |   $Revision: 1.1 $
 |
 |   Classes:
 |      HvClientHandlerP
 |
 |   Author(s)          : Horst Vollhardt
 |
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 _______________________________________________________________________
 */

#include <iostream.h>

#include "HvClientHandlerP.h"


////////////////////////////////////////////////////////////////////////
//
// Description:
//    Constructor
//
// Use: public

HvClientHandlerP::HvClientHandlerP(const char *pipe)
               : HvClientP(pipe)
//
////////////////////////////////////////////////////////////////////////
{
   state = FIRST_CALL;
   readState = FIRST_CALL;
   writeState = FIRST_CALL;
   bytesSend = 0;
   connected = FALSE;
   finished=TRUE;
}


////////////////////////////////////////////////////////////////////////
//
// Description:
//    Destructor
//
// Use: public

HvClientHandlerP::~HvClientHandlerP()
//
////////////////////////////////////////////////////////////////////////
{
}


////////////////////////////////////////////////////////////////////////
//
// Description:
//    connects to server
//    returns TRUE if completed
//    (there are intentionally no breaks used)
//
// Use: public

SbBool
HvClientHandlerP::connect()
//
////////////////////////////////////////////////////////////////////////
{
   if (isConnected()) return TRUE;

   switch (state) {
      case HvClientHandlerP::FIRST_CALL:
         state = HvClientHandlerP::CONNECTING;

      case HvClientHandlerP::CONNECTING:
         if (connectPipe() <= 0) return FALSE;
		 setSocket(getSocket());
         state = HvClientHandlerP::NON_BLOCKING;

      case HvClientHandlerP::NON_BLOCKING:
         if (makeNonblocking() < 0) return FALSE;
         state = HvClientHandlerP::SET_BUFFER;

      case HvClientHandlerP::SET_BUFFER:
	 if (clear() == -1)            return FALSE;
	 if (readBuffer.clear() == -1) return FALSE;
         state = HvClientHandlerP::FINISHING;

      case HvClientHandlerP::FINISHING:
         connected = TRUE;
         state = HvClientHandlerP::FIRST_CALL;
	 return TRUE;

      case HvClientHandlerP::LAST_CALL:

      default:
         cerr << "You shouldn't show up here !\n";
         break;
   }

   // shouldn't show up here
   return TRUE;
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    read from server
//    returns TRUE if buffer is completed or EOF is reached
//    (there are intentionally no breaks used)
//
// Use: public

SbBool
HvClientHandlerP::read(SbBool binaryMode)
//
////////////////////////////////////////////////////////////////////////
{
   if (!isConnected()) return FALSE;

   int ret;
   switch (readState) {
      case HvClientHandlerP::FIRST_CALL:
         readState = HvClientHandlerP::SET_BUFFER;

      case HvClientHandlerP::SET_BUFFER:
         readState = HvClientHandlerP::CLEAR_BUFFER;

      case HvClientHandlerP::CLEAR_BUFFER:
      	 if (readBuffer.clear() == -1) return FALSE;
         readState = HvClientHandlerP::RECEIVING;

      case HvClientHandlerP::RECEIVING:
         ret = readBuffer.receive(binaryMode);
	 //fprintf(stderr,"     received %d bytes\n",ret);
        if (ret<=0) // we have to check LE cause, this is a pipe
			{
			return FALSE;
			}
         readState = HvClientHandlerP::FINISHING;

      case HvClientHandlerP::FINISHING:
         readState = HvClientHandlerP::FIRST_CALL;
	 return TRUE;

      case HvClientHandlerP::LAST_CALL:

      default:
         cerr << "You shouldn't show up here !\n";
         break;
   }

   // should show up here
   return TRUE;
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//    send buffer to server
//    returns TRUE if session is completed
//    (there are intentionally no breaks used)
//
// Use: public

SbBool
HvClientHandlerP::write(SbBool dataOnly)
//
////////////////////////////////////////////////////////////////////////
{
	return 1; // we never write
   if (!isConnected()) return TRUE;	// nowhere to write

   writeMode = dataOnly;

   switch (writeState) {
      case HvClientHandlerP::FIRST_CALL:
         bytesSend = 0;
         writeState = HvClientHandlerP::SENDING;

      case HvClientHandlerP::SENDING:
         bytesSend += send(bytesSend, dataOnly);
	 if (bytesSend < getLength()) return FALSE;
         writeState = HvClientHandlerP::FINISHING;

     case HvClientHandlerP::FINISHING:
         writeState = HvClientHandlerP::FIRST_CALL;
	 clear();
	 return TRUE;

      case HvClientHandlerP::LAST_CALL:

      default:
         cerr << "You shouldn't show up here !\n";
         break;
   }

   // should show up here
   return TRUE;
}


////////////////////////////////////////////////////////////////////////
//
// Description:
//    flush the write buffer if it is not empty
//    returns TRUE if the buffer is flushed
//    (there are intentionally no breaks used)
//
// Use: public

SbBool
HvClientHandlerP::flush()
//
////////////////////////////////////////////////////////////////////////
{
	// we never flush
	return 1;
	
   if (!isConnected()) return TRUE;	// nowhere to write

   switch (writeState) {
      case HvClientHandlerP::FIRST_CALL:
         return TRUE;

      case HvClientHandlerP::SENDING:
         return write(writeMode);

      case HvClientHandlerP::FINISHING:
      case HvClientHandlerP::LAST_CALL:
      default:
	 return TRUE;
   }
}
