//  -*- C++ -*-

/*
 * HvClient.h
 *
 *	This file defines the HvClient class.
 *
 * Copyright 1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
 */

#ident "$Revision: 1.0 $"

#ifndef  __HV_CLIENT_H__
#define  __HV_CLIENT_H__


#include <netinet/in.h>

#include <Inventor/SbString.h>

#include "HvNetBuffer.h"


//////////////////////////////////////////////////////////////////////////////
//
//  Class: HvClient
//
//	Base class for managing a client network connection
//
//////////////////////////////////////////////////////////////////////////////

class HvClient : public HvNetBuffer {

   public:

      // Constructors
      HvClient(const char *host = NULL, int p = 0);

      // Destructor
      ~HvClient();

      void setPort(int p) { sin.sin_port = port = p; }
      int getPort() { return port; }

      void setHostname(const char *host) { hostname = host; }
      const char *getHostname() { return hostname.getString(); }

      // networking functions
      int makeNonblocking();
      int bindSocket();
      int connectSocket();

      // close socket
      void closeConnection();


   private:

      int			port;
      struct sockaddr_in	sin;
      SbString			hostname;
};

#endif  /* !__HV_CLIENT_H__ */
