/*
 * Copyright (C) 1996   Silicon Graphics, Inc.
 *
 _______________________________________________________________________
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 |
 |   $Revision: 1.0 $
 |
 |   Classes:
 |      HvClient
 |
 |   Author(s)          : Horst Vollhardt
 |
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 _______________________________________________________________________
 */

#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdio.h>
#include <errno.h>

#include "HvClient.h"


////////////////////////////////////////////////////////////////////////
//
// Description:
//    Constructor
//
// Use: public

HvClient::HvClient(const char *host, int port)
//
////////////////////////////////////////////////////////////////////////
{
   if (host != NULL) setHostname(host);
   setPort(port);
}


////////////////////////////////////////////////////////////////////////
//
// Description:
//    Destructor
//
// Use: public

HvClient::~HvClient()
//
////////////////////////////////////////////////////////////////////////
{
   closeConnection();
}


////////////////////////////////////////////////////////////////////////
//
// Description:
//    close one connection and remove socket from list
//
// Use: public

void
HvClient::closeConnection()
//
////////////////////////////////////////////////////////////////////////
{
    close(sock);
}


////////////////////////////////////////////////////////////////////////
//
//  make socket nonblocking
//  returns -1 on otherwise 0
//
// Use: public

int
HvClient::makeNonblocking()
//
////////////////////////////////////////////////////////////////////////
{
   if (fcntl(sock, F_SETFL, FNDELAY) < 0) {

#ifdef DEBUG
      perror("\tfcntl F_SETFL, FNDELAY");
#endif
      return -1;
   }
   return 0;
}


////////////////////////////////////////////////////////////////////////
//
//  bind socket to name
//  returns -1 on otherwise else new socket id
//  
// Use: public

int
HvClient::bindSocket()
//
////////////////////////////////////////////////////////////////////////
{
   struct hostent *he;
   if (!(he = gethostbyname(hostname.getString()))) {

#ifdef DEBUG
      perror("\tgethostbyname");
#endif
      return -1;
   }


   if ((sock = socket(he->h_addrtype, SOCK_STREAM, 0)) < 0) {

#ifdef DEBUG
      perror("\tsocket");
#endif
      return -1;
   }


   bzero((caddr_t)&sin, sizeof(sin));
   sin.sin_family = he->h_addrtype;
   if (bind(sock, &sin, sizeof(sin)) < 0) {

#ifdef DEBUG
      perror("\tbind");
#endif
      return -1;
   }
   bcopy(he->h_addr, &sin.sin_addr, he->h_length);
   sin.sin_port = port;

   return sock;
}


////////////////////////////////////////////////////////////////////////
//
//  connect socket to remote server
//  returns -1 on error, 0 on EINPROGRESS else socket id
//  
// Use: public

int
HvClient::connectSocket()
//
////////////////////////////////////////////////////////////////////////
{
   if (connect(sock, &sin, sizeof(sin)) < 0) {
      if ((errno == EINPROGRESS)||(errno == EALREADY)) return 0;
      if (errno == EISCONN) return sock;

#ifdef DEBUG
      perror("\tconnect");
#endif
      return -1;
   }

   return sock;
}

