//  -*- C++ -*-

/*
 * Copyright (C) 1997   Silicon Graphics, Inc.
 *
 _______________________________________________________________________
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 |
 |   $Revision: 1.2 $
 |
 |   Description:
 |      This file defines the HvChart node class
 |
 |   Author(s)      : Horst Vollhardt
 |
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 _______________________________________________________________________
 */

#ifndef  __HV_CHART_H__
#define  __HV_CHART_H__

#include <Inventor/nodes/SoShape.h>
#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/fields/SoMFInt32.h>
#include <Inventor/fields/SoSFFloat.h>
#include <Inventor/fields/SoMFFloat.h>
#include <Inventor/fields/SoMFShort.h>
#include <Inventor/fields/SoSFString.h>
#include <Inventor/fields/SoSFNode.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: HvChart
//
//////////////////////////////////////////////////////////////////////////////

class HvChart : public SoShape {

    SO_NODE_HEADER(HvChart);

  public:

    // Fields:
    SoSFFloat	width;
    SoSFFloat	height;
    SoSFFloat	depth;
    SoSFFloat	spacing;
    SoSFInt32	numRows;
    SoSFInt32	numColumns;
    SoSFInt32	numSlices;
    SoSFFloat	slice;
    SoMFFloat	heights;
    SoMFShort	colors;
    SoMFInt32	selected;
    SoSFString	url;
    SoSFNode	rowLabel;
    SoSFNode	columnLabel;
    SoSFNode	sectionLabel;
    SoSFNode	description;

    // Constructor
    HvChart();

  SoINTERNAL public:
    static void     initClass();

  protected:
    virtual ~HvChart();

    virtual void generatePrimitives(SoAction *action);

    virtual void computeBBox(SoAction *action, SbBox3f &box, SbVec3f &center);

    virtual void GLRender(SoGLRenderAction *action);

  private:
    GLfloat cubeCoord[8][3], cubeNorm[6][3];
};

#endif   /* !__HV_CHART_H__ */
