c INTERFACE statements.  The following functions require INTERFACE
c statements or the [value] attribute on the formal argument when
c the function is declared.  The functions in this source are
c declared with the [value] attribute so the INTERFACE statements 
c are optional and are commented out.
c
c Please note that compiling this DLL with the /4Yb compiler switch will 
c elicit an Internal Compiler Error.  Microsoft has confirmed this to be 
c a problem with version 5.10 of FORTRAN.
c
***********************************************************************
*
*      interface to logical*2 function TestBool(a)
*      logical*2 a[value]
*      end
*
*      interface to real*8 function TestDouble(a)
*      real*8 a[value]
*      end
*
*      interface to integer*2 function TestInt(a)
*      integer*2 a[value]
*      end
*
*      interface to integer*4 function TestLong(a)
*      integer*4 a[value]
*      end
*
*      interface to double precision function testBBB(a,b)
*      double precision a[value]
*      double precision b[value] 
*      end
*
*
***********************************************************************

c NOTE: Arrays in FORTRAN are stored in column major format: columns
c are stored contiguously in memory.  In C and in Excel arrays are
c stored in row major format: rows are stored contiguously in memory.
c You must transpose arrays passed to FORTRAN, either on the FORTRAN
c side or on the Excel side using the TRANSPOSE() function to avoid
c using rows for columns and columns for rows.


c The Excel macro for this function looks like:
c 
c =REGISTER("fortxl.dll","TestBool","AA","TestBool")

      logical*2 function TestBool(a)
      logical*2 a[value]
      TestBool = .not.a
      return
      end

c Excel macro:
c
c =REGISTER("fortxl.dll","TestDouble","BB","TestDouble")
      
      real*8 function TestDouble(a)
      real*8 a[value]
      TestDouble = 2.0d0 * a
      return
      end
      
      
c =REGISTER("fortxl.dll","TestChar",">C","TestChar")
            
      subroutine TestChar(s)
      character*20 s

      i = 1
      do while(s(i:i).ne.char(0))
        s(i:i) = '$'
        i = i + 1
      end do

      return
      end         
                                                    

c =REGISTER("fortxl.dll","TestByte",">D","TestByte")      
      
      subroutine TestByte(c)
      character*24 c
      c = ' Hi There'
      c(1:1) = char(8)
      return
      end

c =REGISTER("fortxl.dll","TestFloatBuff","BE","TestFloatBuff")

      real*8 function TestFloatBuff(a)
      real*8 a
      TestFloatBuff = 3.0*a
      return
      end 
          

c =REGISTER("fortxl.dll","TestZBuff",">F","TestZBuf")      
      
      subroutine TestZBuff(a)
      character*10 a
      a = 'Greetings'c
      return
      end
       

c =REGISTER("fortxl.dll","TestByteBuff",">G","TestByteBuff")
            
      subroutine TestByteBuff(a)
      character*11 a
      a = ' Good Day'
      a(1:1) = char(8)
      return
      end

      
c =REGISTER("fortxl.dll","TestInt","II","TestInt")
                  
      integer*2 function TestInt(a)
      integer*2 a[value]
      TestInt = 2*a
      return
      end


c =REGISTER("fortxl.dll","TestLong","JJ","TestLong")
      
      integer*4 function TestLong(a)
      integer*4 a[value]
      TestLong = a*2
      return
      end


c One of the limitations of using the "K" argument type instead of
c "O" is that the structure in FORTRAN cannot have completely
c variably dimensioned arrays. With the "*" as the second dimension
c you can at least vary the number of columns.
c
c =REGISTER("fortxl.dll","TestAddK","BK","TestAddK")

      
      real*8 function TestAddK(a)
      structure /FP/
        integer*2 rows
        integer*2 cols
        real*8    Array(2,*)
      end structure
      record /FP/ a
      real*8 value
      integer*2 i, j
      
      value = 0.0
      do i=1,a.rows
        do j=1,a.cols
          value = value + a.array(i,j)
        end do
      end do   
      TestAddK = value
      return
      end


      
c Since you can't return structures as function return values in
c FORTRAN, return the structure in the argument and use a ">K" in
c the macro.
c
c =REGISTER("fortxl.dll","ChangeK",">K","ChangeK")
      
      subroutine ChangeK(a)
      structure /FP/
        integer*2 rows
        integer*2 cols
        real*8    array(2,*)
      end structure
      record /FP/ a
      
      do i=1,a.rows
        do j=1,a.cols
          a.array(i,j) = a.array(i,j) + 1.0D0
        end do
      end do
      return 
      end


c =REGISTER("fortxl.dll","TestBufBool","AL","TestBufBool")                                              

      logical*2 function TestBufBool(a)
      logical*2 a       
      TestBufBool = .not.a
      return
      end


c =REGISTER("fortxl.dll","TestBufInt","IM","TestBufInt")      
      
      integer*2 function TestBufInt(a)
      integer*2 a
      TestBufInt = 2*a
      return
      end


c =REGISTER("fortxl.dll","TestBufLong","JN","TestBufLong")

      integer*4 function TestBufLong(a)
      integer*4 a
      TestBufLong = a*2
      return
      end


c The following subroutine has a region of the spreadsheet as
c input and returns an array where every element is incremented
c by 2.
c
c =REGISTER("fortxl.dll","ChangeValueO",">O","ChangeValueO")

      subroutine ChangeValueO(rows, cols, a)
      integer*2 rows, cols, i, j
      real*8    a(rows,cols)
      
      do i=1,rows
        do j=1,cols
          a(i,j) = a(i,j) + 2.0D0
        end do
      end do
      
      return
      end
      

c The following subroutine changes the size of the returned
c array from a 2 dimensional array to a one-dimensional array.
c It doubles all the elements and returns a single row array.
c
c =REGISTER("fortxl.dll","ChangeSizeO",">O","ChangeSizeO")      
      
      subroutine ChangeSizeO(rows,cols,a)
      integer*2 rows, cols
      real*8 a(rows,cols) 
      integer*2 items

      do i=1,rows
        do j=1,cols
          a(i,j) = a(i,j) * 2.0
        end do
      end do

      items = rows * cols
      rows = 1
      cols = items
      return
      end


c If you want to pass things in using the B option you must
c have the [value] attribute on the formal argument that 
c allows arguments to be received by value.  The following 
c function uses all B argument types in Excel.
c
c =REGISTER("fortxl.dll","testBBB","BBB","testBBB")
      
      
      double precision function testBBB(a,b)
      double precision a[value], b[value]
      
      testBBB = a * b
      return
      end


c An easier way is to use the E Excel argument type to pass
c numbers in.  This passes the arguments by reference which is 
c the default with FORTRAN. Note that the function return value 
c is still using a B and must be this way.  No INTERFACE 
c statements or [value] attribute are required using this method.
c
c =REGISTER("fortxl.dll","testBEE","BEE","testBEE")
      
      double precision function testBEE(a,b)
      double precision a, b
      
      testBEE = a * b
      return
      end


c Now an example of passing several arrays and an integer
c in to a subroutine and returning an array.  Note how the O 
c argument type alway passes three things in: 2 INTEGER*2 
c variables with the row and column size and a two-dimensional
c array of double precision numbers.
c
c =REGISTER("fortxl.dll","ARRAY",">OON","array")
      
      
      subroutine array(rows_x,cols_x,x,rows_y,cols_y,y,n)
      integer*2 rows_x,cols_x,rows_y,cols_y
      real*8 x(rows_x,cols_x),y(rows_y,cols_y) 
      integer n
      
      nrows = max(rows_x, rows_y)
      ncols = max(cols_y, cols_y)
      
      do k=1,ncols
        do j=1,nrows
          x(j,k) = x(j,k) + y(j,k) * 2.0d0 + n
        end do
      end do
      return
      end

                        
      
c This is the same as the above function but it returns the 
c return value in the second argument. This uses the new
c Excel 4.0 feature of specifying the argument that the 
c return value is going to be returned in.  The Excel macro
c looks like: 
c
c =REGISTER("fortxl.dll","ARRAY2","2OON","array2")

      
      subroutine array2(rows_x,cols_x,x,rows_y,cols_y,y,n)
      integer*2 rows_x,cols_x,rows_y,cols_y
      real*8 x(rows_x,cols_x),y(rows_y,cols_y)
      integer n
                     
      
      nrows = max(rows_x, rows_y)
      ncols = max(cols_y, cols_y)
      
      do k=1,ncols
        do j=1,nrows
          y(j,k) =  x(j,k) + y(j,k) * 2.0d0 + n
        end do
      end do  
     
      return
      end


c The following routine accepts an array, two double precision
c numbers and another array.  The return is going out in the second
c array.  The routine adds the first scalar to all the elements of
c the first array, adds the second scalar to all the elements of the
c second array and then adds the equivalent elements of each array.
c
c Note: if the arrays are going to be sent in transposed then the
c row and column indexes should also be transposed on the FORTRAN
c side.  The transpose on the Excel side is arranging the array
c correctly for FORTRAN to access as if it wasn't transposed. So 
c the column and row indexes come in reversed. The easiest thing
c is simply to reverse the variables in the argument list as 
c below.  
c
c Excel macro:
c
c =REGISTER("fortxl.dll","TESTOEEO","4OEEO","testOEEO")

      
      subroutine testOEEO(cx,rx,x,a,b,cy,ry,y)
c Excel parameters        {  O  } E E {  O  }
      
      integer*2 rx,cx,ry,cy
      real*8 x(rx,cx),y(ry,cy),a,b

      do i=1,rx
        do j=1, cx
          x(i,j) = x(i,j) + a
        end do
      end do
      
      do i=1,ry
        do j=1, cy
          y(i,j) = y(i,j) + b
        end do
      end do                 
      
      do i=1,min(rx,ry)
        do j=1,min(cx,cy)
          y(i,j) = y(i,j) + x(i,j)
        end do
      end do
      
      return
      end


c The following subroutine is used in the normalize macro.
c It takes an array and returns it with the columns normalized.
c It is expecting the array to come in transposed from Excel.
c The rows and columns are specified in reverse in the argument
c list as explained above.
c
c Excel macro:
c
c =REGISTER("fortxl.dll","NORMAL",">O","normal")

      
      subroutine normal(cx,rx,x)
      integer*2 cx,rx
      real*8 x(rx,cx), factor
                      
      do j=1,cx  
        factor = 0.
        do i=1,rx
          factor = factor + x(i,j)*x(i,j)
        end do      
        factor = sqrt(factor)                     
        do i=1,rx               
          if (factor.ne.0.) x(i,j) = x(i,j)/factor
        end do
      end do
      return
      end
