/****************************** Module Header *****************************
* Module Name: tvmain.c
*
* Copyright (c) 1994, Microsoft Corporation
*
* TreeView test app - main module
*
* History:
* 01-20-94 dhan        Created.
**************************************************************************/

#include "global.h"      
#include "item.h"
#include "tv.h" 

const char g_szStubAppClass[] = "StubAppClass";

#define WID_TABS    1

HWND hwndTree = NULL;               // treeview window handle
HWND hwndMain = NULL;               // Main window handle
HINSTANCE hInst = NULL;             // Instance of the app
HIMAGELIST hImageList = NULL;       // handle to the imagelist - no longer used ??
char szShortFilter[5];              // Short filter for formating Edit window output/input
char szLongFilter[5];               // Long filter for formatting Edit window output/input
char lpText[MAXPATHLEN];            // global storing the text for the Treeview item

HINSTANCE g_hinst = NULL;           // globals for specifying index of images
UINT g_indexFolder = 0; 
UINT g_selectedImage = 0;                      
UINT g_disabledImage = 0;
HFILE ghfptr = NULL;               // log file handle
static char const g_szTreeViewClass[] = WC_TREEVIEW;   // the Treeview classs

HIMAGELIST g_him=NULL;              // Two imagelists for the treeview
HIMAGELIST g_him2=NULL;
HIMAGELIST g_himState=NULL;			// State imagelist

HIMAGELIST g_himlDrag = NULL;		// ImageList for the drag image
BOOL g_bDragging = FALSE;			// whether we are dragging now
HTREEITEM g_hDragItem = NULL;		// Item being dragged

/*
 * Forward declarations.
 */                                                                   
 
BOOL InitializeApp(void);
LONG CALLBACK App_WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
LONG CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
void InitGlobals(void);
void HandleTheCommand(HWND, UINT, UINT, LONG);
void App_OnLButtonDown(HWND, LPARAM);
void App_OnMMove(HWND, LPARAM);                        
void App_OnLButtonUp(HWND, LPARAM);
void App_OnContextMenu(HWND, LPARAM);
void OpenLogFile(LPCSTR);

//--------------------------------------------------------------------------
UINT wDebugMask = 0x00ff;

void WINCAPI MyDebugMsg(UINT mask, LPCSTR pszMsg, ...)
{
    char ach[256];

//    if (wDebugMask & mask)
//    {
//    wvsprintf(ach, pszMsg, ((LPCSTR FAR*)&pszMsg + 1));  
    wvsprintf(ach, pszMsg, &pszMsg+1);
    OutputDebugString("****MESSAGE****");
    OutputDebugString(ach);
    OutputDebugString("\r\n");
//    }
}


/***************************************************************************\
* winmain
*
*
* History:
* 01-20-94  dhan      Created.
\***************************************************************************/
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
           LPSTR lpszCmdParam, int nCmdShow)
{
    MSG msg;
    int ret=0;

    g_hinst = hInstance;
    MyDebugMsg(DM_TRACE, "WinMain: App started (%x)", g_hinst);

#ifndef WIN32
    if (!Shell_Initialize())
    return 1;
#endif
    if (InitializeApp())
    {
    while (GetMessage(&msg, NULL, 0, 0))
    {
         TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    }
    else
    {
    ret=1;                                                                         
    }
         
// destroy the imagelists created. Actually, this better be done on WM_QUIT message
    
    if (g_him) {
        ImageList_Destroy(g_him);
    }

    if (g_him2) {
        ImageList_Destroy(g_him2);
    }
#ifndef WIN32
    Shell_Terminate();
#endif
    return 0;
}

/***************************************************************************\
* InitializeApp
*
* History:
* 01-20-94 Dhan       Created.
\***************************************************************************/

BOOL InitializeApp(void)
{
    WNDCLASS wc;
    HICON hSmallIcon;
    UINT cxIcon, cyIcon;
    int cx, cy; 
    // get the icon sizes and set up the imagelists
    cxIcon = GetSystemMetrics(SM_CXICON);
    cyIcon = GetSystemMetrics(SM_CYICON);

    g_him=ImageList_Create(cxIcon/2, cxIcon/2, TRUE, 3, 8);
    g_him2=ImageList_Create(32, 32, ILC_MASK, 3, 8);
    g_himState = ImageList_Create(16, 16, ILC_MASK, 3, 0);

    if (g_him==NULL) {
        return FALSE;
    }                                    
    
    if (g_him2==NULL) {
        return FALSE;
    }

    // three images to be added to the imagelist
////  hSmallIcon = LoadIcon(g_hinst, MAKEINTRESOURCE(IDI_FOLDER));
    if (ImageList_AddMasked (g_himState, 
                         LoadBitmap (g_hinst,MAKEINTRESOURCE(IDB_CHECKSTATES)), 
                         RGB (255,0,0))== -1)
                         MessageBox(NULL, "Cannot load state imagelist", "InitApp", MB_ICONSTOP);
	if (ImageList_GetImageCount(g_himState)<1) 
	{
		MessageBox(NULL, "State imagelist not init", "InitApp", MB_ICONSTOP);	
	}
    
    ImageList_GetIconSize(g_himState, &cx,&cy);
     
    hSmallIcon = LoadIcon(NULL, MAKEINTRESOURCE(IDI_APPLICATION));
    g_indexFolder=ImageList_AddIcon(g_him, hSmallIcon);                    // assume index
    DestroyIcon(hSmallIcon);                             
    
    hSmallIcon = LoadIcon(NULL, MAKEINTRESOURCE(IDI_ASTERISK));
    g_selectedImage=ImageList_AddIcon(g_him, hSmallIcon);
    DestroyIcon(hSmallIcon);
    
    hSmallIcon = LoadIcon(NULL, MAKEINTRESOURCE(IDI_HAND)); 
    g_disabledImage=ImageList_AddIcon(g_him, hSmallIcon);
    DestroyIcon(hSmallIcon);              
    
    // add 3 more to the next imagelist from the resource
    hSmallIcon = LoadIcon(g_hinst, MAKEINTRESOURCE(IDI_ICON2));
    ImageList_AddIcon(g_him2, hSmallIcon);
    DestroyIcon(hSmallIcon);
    
    hSmallIcon = LoadIcon(g_hinst, MAKEINTRESOURCE(IDI_ICON3));
    ImageList_AddIcon(g_him2, hSmallIcon);
    DestroyIcon(hSmallIcon);
    
    hSmallIcon = LoadIcon(g_hinst, MAKEINTRESOURCE(IDI_ICON4));
    ImageList_AddIcon(g_him2, hSmallIcon);
    DestroyIcon(hSmallIcon);    
    
    // register the class for the main window
    cxIcon = GetSystemMetrics(SM_CXICON);
    cyIcon = GetSystemMetrics(SM_CYICON);
    wc.style            = CS_OWNDC | CS_DBLCLKS | CS_VREDRAW | CS_HREDRAW;
    wc.lpfnWndProc      = App_WndProc;
    wc.cbClsExtra       = 0;
    wc.cbWndExtra       = 0;
    wc.hInstance        = g_hinst;
    wc.hIcon            = LoadIcon(g_hinst, MAKEINTRESOURCE(IDI_ICON1));;
    wc.hCursor          = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground    = (HBRUSH)COLOR_APPWORKSPACE;
    wc.lpszMenuName     = MAKEINTRESOURCE(IDR_MENU1);
    wc.lpszClassName    = g_szStubAppClass;
    
    InitGlobals();
    
 
    if (!RegisterClass(&wc))
    {
    MyDebugMsg(DM_TRACE, "%s: Can't register class (%x)",
         wc.lpszClassName, g_hinst);
    return FALSE;
    }
    
    // Create the main window
    hwndMain = CreateWindowEx(0L, g_szStubAppClass, "Treeview Control" WC_SUFFIX32,
        WS_OVERLAPPED | WS_CAPTION | WS_BORDER | WS_THICKFRAME |
        WS_MAXIMIZEBOX | WS_MINIMIZEBOX | WS_CLIPCHILDREN |
        WS_VISIBLE | WS_SYSMENU,
        80, 70, 700, 500,
        NULL, NULL, g_hinst, NULL);

    if (hwndMain == NULL)
    return FALSE;
    ShowWindow(hwndMain, SW_SHOWNORMAL) ;
    UpdateWindow(hwndMain);

    SetFocus(hwndMain);    /* set initial focus */
    
    
    return TRUE;
}


void App_OnPaint(HWND hwnd)
{
    PAINTSTRUCT ps;
    HDC hdc=BeginPaint(hwnd, &ps);
    EndPaint(hwnd, &ps);
}

   
/*
 * TreeView_AddItem
 * Adds 6 items to the Treeview control.
 * Currently used only during the creation of the Control
 */
 
HTREEITEM NEAR PASCAL TreeView_AddItem(HWND hwndTree, HTREEITEM htiParent,
    HTREEITEM htiInsertAfter, int iImage, LPCSTR lpszText, int cChildren, UINT state,
    LPARAM lParam)
{                     
        TV_INSERTSTRUCT tcAdd;

		// Initialize the struct        
        tcAdd.hParent = htiParent;
        tcAdd.hInsertAfter = htiInsertAfter;
        tcAdd.item.cChildren = cChildren;              

        tcAdd.item.iImage = g_indexFolder;
        tcAdd.item.iSelectedImage = g_selectedImage;
        

        tcAdd.item.pszText = (LPSTR) lpszText;
        tcAdd.item.lParam = lParam;                     
        // set all the fields possible.
        tcAdd.item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_PARAM |TVIF_STATE | TVIF_SELECTEDIMAGE 
                            | TVIF_CHILDREN;

        tcAdd.item.state = state;
        tcAdd.item.stateMask = 0xFFFF; // mask set for all flags 
        
        // Now give a parent if not given. These are the first few items inserted, you 
        // wouldnt want to mess things up rightaway.
        
        if (htiParent == NULL)
                {
                tcAdd.hParent = TVI_ROOT;
                }

        return TreeView_InsertItem(hwndTree, &tcAdd);
}


/*
 * App_OnSize : handle sizing. havent changed this procedure
 */
    
void App_OnSize(HWND hwnd, UINT cx, UINT cy)
{
    HWND hwndTV=GetDlgItem(hwnd, WID_TABS);
    if (hwndTV)
    {
        SetWindowPos(hwndTV, NULL, 0, 0, cx, cy, SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE);
    }
}                                             

static void
App_OnPress(HWND hwnd, HD_NOTIFY FAR *NotifyStruct, int HDNMsg)
{

  return;
}
                                            
                      
 /*
  * Just beep in case someone asks for Display Info on that item
  */
  
void NEAR PASCAL Tree_GetDispInfo(HWND hwnd, NM_TREEVIEW FAR * lpnm)
{
    MessageBeep(0);
}

/*
 * Tree_HandleNotify
 * handle all the notify messages
 * Output the NMHDR passed according to the message
 */
 
LRESULT NEAR PASCAL Tree_HandleNotify(HWND hwnd, LPNMHDR lpnmhdr)
{
    RECT rcItem; 
	TV_DISPINFO *lpDispInfo = NULL;
    NM_TREEVIEW *lpnm_treeview = NULL;
    TV_KEYDOWN *lpKeyDown = NULL;
    
	lpDispInfo	= (TV_DISPINFO *)lpnmhdr;
    lpnm_treeview = (NM_TREEVIEW *)lpnmhdr;        
    lpKeyDown = (TV_KEYDOWN *)lpnmhdr;
    
    switch (lpnmhdr->code)
    {

    case NM_SETFOCUS:
    case NM_KILLFOCUS:
        MyDebugMsg(DM_TRACE,
                 "tree.c - Set/KillFocus ");
        break;

    case NM_RCLICK:
    	MyDebugMsg(DM_TRACE, "NM_CLICK");
        return(FALSE);
        
        // `return Tree_HandleRClick(pfc, lpnmhdr);
//    case TVN_BEGINDRAG:
//    case TVN_BEGINRDRAG:
//        return Tree_HandleBeginDrag(pfc->hwndMain, lpnmhdr->code == TVN_BEGINRDRAG, (LPNM_TREEVIEW)lpnmhdr);
//    case TVN_ITEMEXPANDING:
//        return Tree_HandleExpanding(pfc, pfc->hwndMain, (LPNM_TREEVIEW) lpnmhdr);
//    case TVN_SELCHANGED:
//        return Tree_HandleSelChange(pfc, (LPNM_TREEVIEW)lpnmhdr);

    case NM_CLICK:
	MyDebugMsg(DM_TRACE, "NM_CLICK");
	return FALSE;

	case TVN_KEYDOWN:
    	MyDebugMsg(DM_TRACE, "TVN_KEYDOWN wVKey = %d flags = %lx", lpKeyDown->wVKey, lpKeyDown->flags); 
		break;	
        
    case TVN_SELCHANGING:        
        MyDebugMsg(DM_TRACE, "TVN_SELCHANGING action=0x%lx itemNew.hItem = %lx itemOld.hItem = %lx"
        	, lpnm_treeview->action, lpnm_treeview->itemNew.hItem, lpnm_treeview->itemOld.hItem);
        return FALSE;
    case TVN_SELCHANGED:
        MyDebugMsg(DM_TRACE, "TVN_SELCHANGED action=0x%lx itemNew.hItem = %lx itemOld.hItem = %lx"
        	, lpnm_treeview->action, lpnm_treeview->itemNew.hItem, lpnm_treeview->itemOld.hItem);
        return FALSE;
                                             
    case TVN_ITEMEXPANDING:
        MyDebugMsg(DM_TRACE, "TVN_ITEMEXPANDING: itemNew.hItem = %lx itemNew.state = %lx action = %lx",
        	lpnm_treeview->itemNew.hItem, lpnm_treeview->itemNew.state, lpnm_treeview->action);
        return FALSE;
                                                     
    case TVN_ITEMEXPANDED:                
        MyDebugMsg(DM_TRACE, "TVN_ITEMEXPANDED: itemNew.hItem = %lx itemNew.state = %lx action = %lx",
        	lpnm_treeview->itemNew.hItem, lpnm_treeview->itemNew.state, lpnm_treeview->action);
        return FALSE;

    case TVN_GETDISPINFO:             
    MyDebugMsg(DM_TRACE, "TVN_GETDISPINFO: item.hItem = %lx", lpDispInfo->item.hItem);
    Tree_GetDispInfo(hwnd, (LPNM_TREEVIEW)lpnmhdr);
    break;
    
    case TVN_SETDISPINFO:             
    MyDebugMsg(DM_TRACE, "TVN_SETDISPINFO: item.hItem = %lx", lpDispInfo->item.hItem);
    break;

    case TVN_BEGINDRAG:
        MyDebugMsg(DM_TRACE, "TVN_BEGINDRAG: itemNew.hItem = %lx ptDrag.x = %ld ptDrag.y = %ld",
        	lpnm_treeview->itemNew.hItem, lpnm_treeview->ptDrag.x, lpnm_treeview->ptDrag.y);
        	
        // Create the imagelist to drag
		g_himlDrag = TreeView_CreateDragImage(hwndTree, lpnm_treeview->itemNew.hItem);
        TreeView_GetItemRect(hwndTree, lpnm_treeview->itemNew.hItem, &rcItem, TRUE);
        g_hDragItem = lpnm_treeview->itemNew.hItem;
        // start the drag
        // ImageList_SetDragCursorImage(g_himlDrag, 0, 8, 8);
        if (ImageList_BeginDrag(g_himlDrag, 0, 16, 16)) {
            // lock updates to the window
        	ImageList_DragEnter(hwndTree, lpnm_treeview->ptDrag.x, lpnm_treeview->ptDrag.y);	
//        	ShowCursor(FALSE);
			// capture the mouse
        	SetCapture(hwnd);
        	g_bDragging = TRUE; 
        } else
        {
        	ImageList_Destroy(g_himlDrag); 
            g_himlDrag = NULL;
        }
		return(0L);
		

                           
    case TVN_BEGINLABELEDIT:    
        MyDebugMsg(DM_TRACE, "TVN_BEGINLABELEDIT: item.hItem = %lx item.State = %lx pszText = %s",
        	lpDispInfo->item.hItem, lpDispInfo->item.state, lpDispInfo->item.pszText );
        return FALSE;
    
    case TVN_BEGINRDRAG:
        MyDebugMsg(DM_TRACE, "TVN_BEGINRDRAG: itemNew.hItem = %lx ptDrag.x = %ld ptDrag.y = %ld",
        	lpnm_treeview->itemNew.hItem, lpnm_treeview->ptDrag.x, lpnm_treeview->ptDrag.y);
        return 0L;
        
    case TVN_ENDLABELEDIT:
        MyDebugMsg(DM_TRACE, "TVN_ENDLABELEDIT: item.hItem = %lx item.State = %lx pszText = %s",
        	lpDispInfo->item.hItem, lpDispInfo->item.state, lpDispInfo->item.pszText );
        // Set the text of the item edited
        if (lpDispInfo->item.pszText) {
        	lpDispInfo->item.mask = TVIF_TEXT;
            TreeView_SetItem(lpnmhdr->hwndFrom, &(lpDispInfo->item));
        } 
        return TRUE; //should this be true ?
        
    case TVN_DELETEITEM:
        MyDebugMsg(DM_TRACE, "TVN_REMOVEITEM");
        break;
 
    }
}

                      
//--------------------------------------------------------------------------
// App_WndProc
//
// History:
//  01-20-94 Satona      Created
//--------------------------------------------------------------------------

LONG CALLBACK App_WndProc(
    HWND hwnd,
    UINT message,
    WPARAM wParam,
    LPARAM lParam)                                 
{
    switch (message)
    {
    case WM_CREATE:  
//    DoCreateDialog(hwnd);  for creation do not do anything - wait for the menu to be selected.
//    App_OnCreate(hwnd, (LPCREATESTRUCT)lParam);
    hwndClient = hwnd;
    break;  // should return 0.
               
    case WM_COMMAND:
    HandleTheCommand(hwnd, message, wParam, lParam);
    break;
                   
    case WM_DESTROY:
    PostQuitMessage(0);
    break;

    case WM_PAINT:
    App_OnPaint(hwnd);
    break;                                
    
    case WM_NOTIFY:
        return Tree_HandleNotify(hwnd, (LPNMHDR)lParam);
        // return DefWindowProc(hwnd, message, wParam, lParam);
        break;
    
    case WM_SIZE:
    App_OnSize(hwnd, LOWORD(lParam), HIWORD(lParam));
    break;
           
    case WM_LBUTTONDOWN:
    App_OnLButtonDown(hwnd, lParam);
    break;

    case WM_MOUSEMOVE:
    App_OnMMove(hwnd, lParam);
    break;
               
    case WM_LBUTTONUP:
    App_OnLButtonUp(hwnd, lParam);
    break;

    case WM_CONTEXTMENU:
	App_OnContextMenu(hwnd, lParam);
    	break;               
        
    case WM_SYSCOLORCHANGE:
		SendMessage(hwndTree, message, wParam, lParam);

    default:
    return DefWindowProc(hwnd, message, wParam, lParam);
    }

    return 0L;
}






void InitGlobals(void)
{
    
  /* not really too much to do here.  Create a hex wsprintf() filter since
     the app starts off in Hex mode. */

  lstrcpy(szShortFilter, "%x") ;
  lstrcpy(szLongFilter, "%lx") ;    
  hInst = g_hinst;         
}



void HandleTheCommand(HWND hWnd, UINT message, UINT wParam, LONG lParam)
{
  
  switch (LOWORD(wParam))
  {
    case IDM_CREATE:
      DoCreateDialog(hWnd);
      break;

    case IDM_DESTROY:
      TreeView_DeleteAllItems(hwndTree);
      DestroyWindow(hwndTree);
      break;
            
    case IDM_EXIT:
      PostQuitMessage(0);
      break;
                                  
    case IDM_ADDITEM:
      DoAddItemDialog(hWnd);
      break;

    case IDM_REMOVEITEM:
    case IDM_CREATEDRAGIMAGE:
    case IDM_EDITLABEL:
    case IDM_ENSUREVISIBLE:
      DoRemoveItemDialog(hWnd, wParam);
      break;
    
    case IDM_ENABLEITEM:
      // DoEnableItemDialog(hWnd);
      break;
                                             
    case IDM_EXPANDCHILDREN:
      DoExpandCDialog(hWnd);        
      break;
                                    
    case IDM_GETSELECT:
      DoGetSDialog(hWnd, wParam);
      break;
                                         
    case IDM_SETSELECT:
      DoGetSDialog(hWnd, wParam);
      break;
         
    case IDM_GETITEMINFO:
      DoGetIIDialog(hWnd, wParam);
      break;
      
    case IDM_SETITEMINFO:
      DoGetIIDialog(hWnd, wParam);
      break;
                            
    case IDM_GETFIRSTVISIBLE:
      // discontinued DoGFV(hWnd);
      break;
                                  
    case IDM_SETFIRSTVISIBLE:
      DoRemoveItemDialog(hWnd, wParam);
      break;
      
    case IDM_GETTEXTLEN:                        
      DoRemoveItemDialog(hWnd, wParam);
      break;
                
    case IDM_SORTCHILDREN:
      DoRemoveItemDialog(hWnd, wParam);
      break;
    
    case IDM_SHOWLINEST:
    case IDM_SHOWLINESF:
      DoShowLines(hWnd, (LOWORD(wParam)==IDM_SHOWLINEST));
      break;
    
    case IDM_SHOWBUTTONST:
    case IDM_SHOWBUTTONSF:
      DoShowButtons(hWnd, (LOWORD(wParam)==IDM_SHOWBUTTONST));
      break;
    
    case IDM_LINESATROOTT:
    case IDM_LINESATROOTF:
      DoLinesAtRoot(hWnd, (LOWORD(wParam)==IDM_LINESATROOTT));
      break;
      
    case IDM_REMOVEALL:
      DoRemoveAll(hWnd);
      break;
    
    case IDM_HITTEST:
      DoHitDialog(hWnd);
      break;

    case IDM_GETINDENT:
    case IDM_SETINDENT:
      DoGetIndDialog(hWnd, wParam);
      break;
      
    case IDM_GETCOUNT:
      DoGetCount(hWnd);
      break;
      
                    
    case IDM_GETITEM:
      // DoGetIDialog(hWnd); Instead in GetItem which is under GetItemInfo!
      break;
    
    case IDM_SETIMAGELIST: 
      DoSetImglstDialog(hWnd);
      break;
                           
    case IDM_GETIMAGELIST:
      DoGetImageList(hWnd);                                  
      break;
      
    case IDM_STRESSADD:
      DoStAddDialog(hWnd);
      break;
       
	case IDM_GETITEMRECT:
    	DoGetItemRect(hWnd);
		break;
        
    case IDM_SETREDRAWT:
      SendMessage(hwndTree,WM_SETREDRAW, TRUE, 0L);
      break;
       
    case IDM_SETREDRAWF:
      SendMessage(hwndTree, WM_SETREDRAW, FALSE, 0L);
      break;
	case IDM_GETISEARCHSTRING:
		DoGetISSDialog(hWnd, wParam);
		break;      
		
    case IDM_GETVISIBLECOUNT:
    	DoGVCDialog(hWnd);
    	break;
    default:
      break;
  }                  
  return ;
}


/*
 * MyAtol - converts the szString into the Long equivalent depending on whether the 
 *          string is in hex or decimal
 */

LONG MyAtol(LPSTR szString, BOOL bHex,/*was LPBOOL*/ BOOL bSuccess)
{
  LPSTR p ;
  LONG l ;
  LONG lMultiplier ;
  BOOL bDigit ;

  if (bHex)
    lMultiplier = 16 ;
  else
    lMultiplier = 10 ;

  p = szString ;
  l = 0 ;

  while (*p)      //while chars
  {
     bDigit = FALSE ;  //set to false for each char that we look at

     if (*p >= (char) '0' && *p <= (char) '9')  //is it an ascii char ?
     {
       bDigit = TRUE ;
       l+=(*p - (char) '0') ;
     }

     if (bHex)
     {
       if (*p >= (char) 'A' && *p <= (char) 'F')  //or hex?
       {
     l+=(*p - (char) 'A' + 10) ;
     bDigit = TRUE ;
       }

       if (*p >= (char) 'a' && *p <= (char) 'f') 
       {
     l+=(*p - (char) 'a' + 10) ;
     bDigit = TRUE ;
       }

     }

     if (bDigit == FALSE)
     {
       bSuccess = FALSE ;
       return 0 ;
     }

     p++ ;               //get next char

     if (*p)             //if there is going to be at least one more char
       l*=lMultiplier ;  //then multiply what we have by the multiplier...
  }

  bSuccess = TRUE ;

  return l ;             //success! return the value.
}



void DisplayError(HWND hwnd, LPSTR pszMsg, LPSTR pszCaption) 
{
    MessageBox(hwnd, pszMsg, pszCaption, MB_OK|MB_ICONSTOP);
}


void App_OnLButtonDown(HWND hwnd, LPARAM lParam)
{                
}


void App_OnMMove(HWND hwnd, LPARAM lParam)
{       
    if (g_bDragging) {
    	HTREEITEM hTarget;
        TV_HITTESTINFO tvht;
        
        ImageList_DragMove(LOWORD(lParam), HIWORD(lParam));
        
        tvht.pt.x = LOWORD(lParam);
        tvht.pt.y = HIWORD(lParam);
        
        // Check to see if an item lives under the mouse
        
        if (hTarget = TreeView_HitTest(hwndTree, &tvht))
        {
//        	ImageList_DragShow(FALSE);
			ImageList_DragLeave(hwndTree);
            TreeView_SelectDropTarget(hwndTree, hTarget);
            ImageList_DragEnter(hwndTree, tvht.pt.x, tvht.pt.y);
//            ImageList_DragShow(TRUE);
        }
    }
}                     


/*
 * App_OnLButtonUp
 * Respond to Left button up message by completing the Drag-drop
 */
 
void App_OnLButtonUp(HWND hwnd, LPARAM lParam)
{                                
	
	if (g_bDragging) {
		HTREEITEM hTarget;
        TV_HITTESTINFO tvht;
        TV_ITEM tvi;
        TV_INSERTSTRUCT tvIns;
        char szBuffer[MAX_PATH];
        
        // Clear the drop target
        TreeView_SelectDropTarget (hwndTree, NULL);
        ImageList_DragLeave(hwndTree);
        ImageList_EndDrag();
        // ShowCursor(TRUE);
        // release the capture of the mouse
        ReleaseCapture();
        // clean up any flags and globals set
        g_bDragging = FALSE;
        ImageList_Destroy(g_himlDrag);
        g_himlDrag = NULL;
        
        tvht.pt.x = LOWORD(lParam);
        tvht.pt.y = HIWORD(lParam);
        
        // if Target is  valid item then
        //		delete item from its original parent
        // 		add drag item to parent of target
        if (hTarget = TreeView_HitTest(hwndTree, &tvht)) 
        {
        	tvi.mask = TVIF_HANDLE | TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
            tvi.hItem = g_hDragItem;
            tvi.pszText = szBuffer;
            tvi.cchTextMax = sizeof(szBuffer);
            
            TreeView_GetItem(hwndTree, &tvi);
            tvIns.hParent = TreeView_GetParent(hwndTree, hTarget);
            tvIns.hInsertAfter = hTarget;
            tvi.mask &= ~TVIF_HANDLE;
            tvIns.item = tvi;
            
            TreeView_DeleteItem(hwndTree, g_hDragItem);
            TreeView_InsertItem(hwndTree, &tvIns);
        }
        
    }
}

void App_OnContextMenu(HWND hwnd, LPARAM lParam)
{                                
    MyDebugMsg(DM_TRACE, "WM_CONTEXTMENU hwnd = %lx xpos = %d ypos = %d",
    		hwnd, LOWORD(lParam), HIWORD(lParam));
}
/*
 * OpenLogFile : opens a file by the name pszFileName and stores the handle in
 *               global pointer hfptr
 */
void OpenLogFile(LPSTR pszFileName)
{                                     
 OFSTRUCT OpenBuf;
 
 if (!(ghfptr = OpenFile(pszFileName, &OpenBuf, OF_CREATE|OF_WRITE))) {
 }  
}
