// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
//
// Copyright (C) 1993, 1994  Microsoft Corporation.  All Rights Reserved.
//
//  MODULE:   listview.c
//
//  PURPOSE:   Implement the windows procedure for the main application
//    windows.  Also implement the generic message and command dispatchers.
//
//  FUNCTIONS:
//    WndProc      - Processes messages for the main window.
//    MsgCreate    - Handle the WM_CREATE message 
//    MsgCommand   - Handle the WM_COMMAND messages for the main window.
//    MsgDestroy   - Handles the WM_DESTROY message by calling 
//                   PostQuitMessage().
//    CmdLargeIcons- Switch main view to large icons
//    CmdSmallIcons- Switch main view to small icons
//    CmdList      - Switch main view to list view
//    CmdDetails   - Switch main view to details view
//    CmdDragList  - Displays the "DragList" dialog box
//    CmdExit      - Handles the file exit command by calling destory 
//                   window on the main window.
//
//  COMMENTS:
//

#include <windows.h>            // required for all Windows applications
#include <windowsx.h>
#include <commctrl.h>
#include "globals.h"            // prototypes specific to this application
#include "listview.h"           // prototypes and defines specific to the
                                // listview control
int        gItemToDrag;
BOOL       gbDragging = FALSE;
HWND       ghwndLV = NULL;
HIMAGELIST ghimlDrag;

// Module specific globals

SAMPLEINFO rgSampleInfo[]=
{
    {"TERMWAIT", "Demos how to spawn a task and wait for its termination."        ,  
     "VinooC", 
     "KERNEL", 
     "\\\\PSSMAX\\DSSAMPLES"},

    {"WINCAP"  , "Demos how to capture a screen as a DIB and print it."              ,  
     "PatSch/MarkBad",
     "GDI",
     "MSVC\\SAMPLES"},

    {"BACKGRND", "Demos background processing using PeekMessage().",  
     "KrishnaN",
     "USER",
     "\\\\PSSMAX\\DSSAMPLES"},

    {"CDDEML"  , "Implements a DDEML Client/Server Sample using MFC"       ,  
     "BrianSc/SaraW",
     "USER",
     "MSVC\\MFC\\SAMPLES"    },

    {"BLANDMDI", "Implements a basic no-brainer MDI Application"        ,  
     "Author Unknown",
     "USER",
     "MSVC\\SAMPLES"    },

    {"ONEEDIT" , "Demos how to save system resources using one edit control"       ,  
     "Li Zhou",
     "USER",
     "\\\\ONLINE\\ARCHIVE"    }
};


//
//  FUNCTION: MsgListViewNotify(HWND, UINT, WPARAM, LPARAM)
//
//  PURPOSE: Processes the WM_MOUSEMOVE message 
//
//  PARAMETERS:
//
//    hwnd      - Window handle  (Unused)
//    uMessage  - Message number (Unused)
//    wparam    - Extra data     (Unused)
//    lparam    - Extra data     (Unused)
//
//  RETURN VALUE:
//
//    Always returns 0 - Message handled
//
//  COMMENTS:
//
//

LRESULT MsgMouseMove (HWND   hwnd, 
                      UINT   uMessage, 
                      WPARAM wparam, 
                      LPARAM lparam)
{
	if (gbDragging)
	{
        LV_HITTESTINFO lvhti;
        int iWhichItem;

		ImageList_DragMove ( LOWORD(lparam), HIWORD (lparam));

        lvhti.pt.x = LOWORD (lparam);
		lvhti.pt.y = HIWORD (lparam);
		
        iWhichItem = ListView_HitTest (ghwndLV, &lvhti);
        if (iWhichItem != -1)  // if an item is under the mouse
        {
            ImageList_DragLeave (ghwndLV);
            
            ImageList_DragEnter (ghwndLV, LOWORD (lparam), HIWORD (lparam));
        }
	}

	return 0;
}  

LRESULT MsgLButtonUp (HWND   hwnd, 
                      UINT   uMessage, 
                      WPARAM wparam, 
                      LPARAM lparam)
{
	char szBuffer [20];

    if (gbDragging)
	{
	    LV_HITTESTINFO lvhti;
		int iWhichItem;
		LV_ITEM lvi;
        SAMPLEINFO *pi;

        ImageList_DragLeave (ghwndLV);
		ImageList_EndDrag();

	    ReleaseCapture();
		gbDragging = FALSE;
		ImageList_Destroy (ghimlDrag);
        ghimlDrag  = NULL;

		// Now we need to destroy the item and re-insert it to the new position.
		lvhti.pt.x = LOWORD (lparam);
		lvhti.pt.y = HIWORD (lparam);
		iWhichItem= ListView_HitTest (ghwndLV, &lvhti);

		wsprintf (szBuffer, "WhichItem = %d\r\n", iWhichItem);
		OutputDebugString (szBuffer);
		

	   
        lvi.iItem    = gItemToDrag;
        lvi.iSubItem = 0;
		lvi.mask  = LVIF_IMAGE | LVIF_PARAM;
		
		ListView_GetItem (ghwndLV, &lvi);

        pi = (SAMPLEINFO *)(lvi.lParam);
	   //wsprintf (szBuffer2, 
       //          "Company Name = %s", 
       //          pi->szCompany);
       // MessageBox (NULL, szBuffer2, "Guess what!",MB_OK);



		ListView_DeleteItem (ghwndLV, gItemToDrag);

		if (iWhichItem == -1)
        iWhichItem = ListView_GetItemCount (ghwndLV) - 1 + 1;

		lvi.iItem       = iWhichItem;
		lvi.state       = LVIS_GCNOCHECK;
        lvi.stateMask   = LVIS_USERMASK;
		lvi.pszText     = LPSTR_TEXTCALLBACK;
        lvi.cchTextMax  = IDC_MAXSAMPLENAME;
		lvi.mask  = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM | LVIF_STATE;
        
        if(ListView_InsertItem(ghwndLV, &lvi) == -1)
              MessageBox (NULL, "InsertItem Failed.\r\n", "Guess what!",MB_OK);
	}
	return 0;
}  

//
//  FUNCTION: MsgListViewNotify(HWND, UINT, WPARAM, LPARAM)
//
//  PURPOSE: Processes the WM_NOTIFY message sent by the listview control
//
//  PARAMETERS:
//
//    hwnd      - Window handle  (Unused)
//    uMessage  - Message number (Unused)
//    wparam    - Extra data     (Unused)
//    lparam    - Extra data     (Unused)
//
//  RETURN VALUE:
//
//    Always returns 0 - Message handled
//
//  COMMENTS:
//
//

LRESULT MsgNotify(HWND   hwnd, 
                  UINT   uMessage, 
                  WPARAM wparam, 
                  LPARAM lparam)
{
    LV_DISPINFO *plvdi = (LV_DISPINFO *)lparam;
    NM_LISTVIEW *pnm   = (NM_LISTVIEW *)lparam;
    SAMPLEINFO   *pi   = (SAMPLEINFO *)(plvdi->item.lParam);
    static char szText[10];
    HWND        hwndLV = plvdi->hdr.hwndFrom;
    UINT        state;
    DWORD       dwpos;
    LV_HITTESTINFO lvhti;
    int            iItemClicked;

    if (wparam != IDD_LISTVIEW)
       return 0L;

    switch (plvdi->hdr.code)
    {

       // This code implements drag-n-drop within the listview.
	    case LVN_BEGINDRAG:
		   {
                DWORD dwCursorPos;
                POINT ptCursor;
                POINT ptHotSpot;

				gItemToDrag = pnm->iItem;


                ptCursor.x = pnm->ptAction.x;
                ptCursor.y = pnm->ptAction.y;
				ghimlDrag = ListView_CreateDragImage (ghwndLV, 
                                                      gItemToDrag, 
                                                      &ptCursor);

                //  Calculate hotspot correctly?

                dwCursorPos = GetMessagePos ();
                ptCursor.x = LOWORD (dwCursorPos);
                ptCursor.y = HIWORD (dwCursorPos);
                ScreenToClient (ghwndLV, &ptCursor);


                // Calc location of hotspot and save it.
                ptHotSpot.x = ptCursor.x - pnm->ptAction.x;
                ptHotSpot.y = ptCursor.y - pnm->ptAction.y;
                if (ImageList_BeginDrag (ghimlDrag,
                                         0, 
                                         ptHotSpot.x, 
                                         ptHotSpot.y))
                {
                    ImageList_DragEnter (ghwndLV,
                                         pnm->ptAction.x,
                                         pnm->ptAction.y);

                    SetCapture (hwnd);
    				gbDragging = TRUE;
                }
                else
                {
                    ImageList_Destroy (ghimlDrag);
                    ghimlDrag = NULL;
                }

                return 0L;

           }
        case LVN_GETDISPINFO:

            switch (plvdi->item.iSubItem)
            {
                case 0:
 
                    plvdi->item.pszText = pi->szSampleName;
                    break;

                case 1:

                    plvdi->item.pszText = pi->szDescription;
                    break;

                case 2:

                    plvdi->item.pszText = pi->szAuthor;
                    break;

                case 3:

                    plvdi->item.pszText = pi->szArea;
                    break;

                case 4:

                    plvdi->item.pszText = pi->szLocation;
                    break;

                  
                default:
                    break;
            }

            break;

        case LVN_COLUMNCLICK:

            ListView_SortItems(pnm->hdr.hwndFrom,
                               ListViewCompareProc,
                               (LPARAM)(pnm->iSubItem));
            break;

        case NM_CLICK:

            // This code does the check box stuff...

            // Find out where the cursor was
            dwpos = GetMessagePos();
            lvhti.pt.x = LOWORD(dwpos);
            lvhti.pt.y = HIWORD(dwpos);

            MapWindowPoints(HWND_DESKTOP, hwndLV, &lvhti.pt, 1);

            // Now do a hittest with this point.
            iItemClicked = ListView_HitTest(hwndLV, &lvhti);

            if (lvhti.flags & LVHT_ONITEM)
            {
                // Now lets get the state from the item and toggle it.
                state = ListView_GetItemState(hwndLV, 
                                              iItemClicked, 
                                              LVIS_USERMASK);

                state = (state == LVIS_GCNOCHECK) ? LVIS_GCCHECK : LVIS_GCNOCHECK;

                ListView_SetItemState(hwndLV,
                                      iItemClicked,
                                      state, 
                                      LVIS_USERMASK);
            }
            break;

        default:
            break;
    }

    return 0;
}


//
//  FUNCTION: ListViewCompareProc(LPARAM, LPARAM, LPARAM)
//
//  PURPOSE: Callback routine for sorting list
//
//  PARAMETERS:
//
//    lparam1    - Pointer to SAMPLEINFO structure
//    lparam2    - Pointer to SAMPLEINFO structure
//    lparamSort - Column being sorted.  Same value that was
//                 passed in the lparam of the ListView_SortItems()
//                 call.
//
//  RETURN VALUE:
//
//    Always returns 0 - Message handled
//
//  COMMENTS:
//    lparam1 and lparam2 are pointers to SAMPLEINFO structures.
//    These two parameters will always point to the same type of
//    structure that was specified in the lparam of the LV_ITEM
//    structure when the item was added.  See InitListViewItems()
//    below, where the lvi.lparam value is set.
//

int CALLBACK ListViewCompareProc(LPARAM lparam1, 
                                 LPARAM lparam2,
                                 LPARAM lparamSort)
{
    SAMPLEINFO *pRec1 = (SAMPLEINFO *)lparam1;
    SAMPLEINFO *pRec2 = (SAMPLEINFO *)lparam2;
    LPSTR     lpString1, lpString2;
    int       iResult = 1;

    if (pRec1 && pRec2)
    {
        switch (lparamSort)
        {
            case 0:
                lpString1 = pRec1->szSampleName;
                lpString2 = pRec2->szSampleName;
                break;             

            case 1:
                lpString1 = pRec1->szDescription;
                lpString2 = pRec2->szDescription;
                break;

            case 2:
                lpString1 = pRec1->szAuthor;
                lpString2 = pRec2->szAuthor;
                break;

            case 3:
                lpString1 = pRec1->szArea;
                lpString2 = pRec2->szArea;
                break;

            case 4:
                lpString1 = pRec1->szLocation;
                lpString2 = pRec2->szLocation;
                break;

            default:
                break;
        }

        iResult = lstrcmpi(lpString1, lpString2);

        //Now, if the strings are equal, compare the szCompany fields
        if (!iResult)
           iResult = lstrcmpi(pRec1->szSampleName, pRec2->szSampleName);
    }

    return iResult;
}


//
//  FUNCTION: InitListViewImageLists(HWND)
//
//  PURPOSE: Fill the image lists with the icons images that will
//           be used when displaying the items.
//
//  PARAMETERS:
//
//    HWND - Handle to the listview control
//
//  RETURN VALUE:
//
//    TRUE  - if image lists were successfully initialized
//    FALSE - if image lists were not successfully initialized
//
//  COMMENTS:
//

BOOL WINAPI InitListViewImageLists(HWND hwndLV)
{
    HICON hicon;
    UINT  i;
    HIMAGELIST himlSmall;
    HIMAGELIST himlLarge;
    HIMAGELIST himlState;

    himlSmall = ImageList_Create(16, 16, TRUE, IDC_NUMITEMS, 0); 
    himlLarge = ImageList_Create(32, 32, TRUE, IDC_NUMITEMS, 0); 
    himlState = ImageList_Create(16, 16, TRUE, 2, 0);

    ImageList_AddMasked (himlState, 
                         LoadBitmap (hInst,MAKEINTRESOURCE(IDB_CHECKSTATES)),
                         RGB (255,0,0));
    
    for (i = IDC_TERMWAIT; i <= IDC_ONEEDIT; i++)
    {
        hicon = LoadIcon(hInst, MAKEINTRESOURCE(i));
        if (ImageList_AddIcon(himlSmall, hicon) == -1 ||
            ImageList_AddIcon(himlLarge, hicon) == -1)
            return FALSE;
    }

    ListView_SetImageList(hwndLV, himlLarge, LVSIL_NORMAL);
    ListView_SetImageList(hwndLV, himlSmall, LVSIL_SMALL);
    ListView_SetImageList(hwndLV, himlState, LVSIL_STATE);

    return TRUE;
}


//
//  FUNCTION: InitListViewColumns(HWND)
//
//  PURPOSE: Specify the text for the column headings.
//
//  PARAMETERS:
//
//    HWND - Handle to the listview control
//
//  RETURN VALUE:
//
//    TRUE  - if column headings were successfully initialized
//    FALSE - if column headings were not successfully initialized
//
//  COMMENTS:
//

BOOL WINAPI InitListViewColumns(HWND hwndLV)
{
    LV_COLUMN lvc;
    int       iCol;
    char      szText[IDC_MAXCOLUMNHDG];

    // Initialize the LV_COLUMN structure.

    lvc.mask    = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
    lvc.fmt     = LVCFMT_LEFT;
    lvc.cx      = 100;
    lvc.pszText = szText; 

    // Add the columns.  NOTE: This code assumes that IDS_NAMECOLUMN
    // is the first string in the group, and that the other strings are
    // in numerical order following.  See LISTVIEW.H for the defines.

    for (iCol = 0; iCol < IDC_NUMCOLUMNS; iCol++)
    {
        if (iCol == 1)   // Widen the description column
            lvc.cx = 300;

        else if (iCol == 4)
            lvc.cx = 170;

		else
		    lvc.cx = 100;

        lvc.iSubItem = iCol;
        LoadString(hInst, 
                   IDS_NAMECOLUMN + iCol,
                   szText,
                   sizeof(szText));
        if (ListView_InsertColumn(hwndLV, iCol, &lvc) == -1)
            return FALSE;
    }

    return TRUE;
}


//
//  FUNCTION: InitListViewItems(HWND)
//
//  PURPOSE: Add the items to the listview control
//
//  PARAMETERS:
//
//    HWND - Handle to the listview control
//
//  RETURN VALUE:
//
//    TRUE  - if items were successfully added
//    FALSE - if items were not successfully added
//
//  COMMENTS:
//

BOOL WINAPI InitListViewItems(HWND hwndLV)
{
    LV_ITEM lvi;
    int iItem;
    int iSubItem;
                                                 

    lvi.mask        = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM | LVIF_STATE;
    lvi.state       = LVIS_GCNOCHECK;
    lvi.stateMask   = LVIS_USERMASK;

    for (iItem = 0; iItem < IDC_NUMITEMS; iItem++)
    {
        lvi.iItem       = iItem;
        lvi.iSubItem    = 0;
        lvi.pszText     = LPSTR_TEXTCALLBACK;
        lvi.cchTextMax  = IDC_MAXSAMPLENAME;
        lvi.iImage      = iItem;
        lvi.lParam      = (LPARAM)&rgSampleInfo[iItem];

        if (ListView_InsertItem(hwndLV, &lvi) == -1)
           return FALSE;

        for (iSubItem = 1; iSubItem < IDC_NUMCOLUMNS; iSubItem++)
        {
            ListView_SetItemText(hwndLV,
                                 iItem, 
                                 iSubItem, 
                                 LPSTR_TEXTCALLBACK);
        }
    }

    return TRUE;
}


//
//  FUNCTION: CreateListView(HWND)
//
//  PURPOSE: Create the listview control
//
//  PARAMETERS:
//
//    HWND - Handle to the parent window
//
//  RETURN VALUE:
//
//    hwndLV - Handle to listview control if successful
//    NULL   - if creation of listview control fails
//
//  COMMENTS:
//

HWND WINAPI CreateListView(HWND hwndParent)
{
    RECT rc;

    // Force the common controls DLL to be loaded.

    InitCommonControls();

    // Create the control.

    GetClientRect(hwndParent, &rc);

    ghwndLV = CreateWindow(WC_LISTVIEW, "",
                          WS_VISIBLE | WS_CHILD | WS_BORDER | LVS_EDITLABELS |
                          LVS_REPORT | LVS_AUTOARRANGE,
                          0, 0, 
                          rc.right-rc.left, rc.bottom-rc.top,
                          hwndParent,
                          (HMENU)IDD_LISTVIEW, 
                          hInst, 
                          NULL);

    if (ghwndLV == NULL)
        return NULL;

    // Initialize the image lists, add columns, and add some
    // items and subitems.

    if (!InitListViewImageLists(ghwndLV) ||
        !InitListViewColumns(ghwndLV)    ||
        !InitListViewItems(ghwndLV))
    {
        DestroyWindow(ghwndLV);
        return FALSE;
    }
    return ghwndLV;
}


//
//  FUNCTION: SwitchView(HWND, DWORD)
//
//  PURPOSE: Change the visual view of the listview control
//
//  PARAMETERS:
//
//    HWND  - Handle to the listview control
//    DWORD - View style indicating new view
//
//  RETURN VALUE:
//
//    void
//
//  COMMENTS:
//

void SwitchView(HWND hwndLV, DWORD dwView)
{
    DWORD dwStyle = GetWindowLong(hwndLV, GWL_STYLE);

    if ((dwStyle & LVS_TYPEMASK) != dwView)
        SetWindowLong(hwndLV, GWL_STYLE, (dwStyle & ~LVS_TYPEMASK) | dwView);
}

