/*
 * This file contains Application definitions and structures that
 * are used by the user interface and the sample player application
 * above the MediaView interface level.
 */

#define DIMENSION(x) (sizeof(x)/sizeof(x[0]))

#define NUMHISTORY 50
#define NUMBOOKMARKS 10

/* is hotspot highlighting turned on? */
extern int bShowHotspots;

/* these define the search limiters */
#define SEARCH_ALL			1
#define SEARCH_GROUPS		2
#define SEARCH_TOPIC		3


/* structure for holding group name/title association */
typedef struct tagGROUP
	{
	char *name;
	char *title;
	} GROUPUI, far * LPGROUPUI;

/* the Print Mark List */
typedef struct tagPRINTMARK
	{
	int type;				/* topic, group, or all */
	VA va;					/* topic address */
	int group;				/* group number in group list */
	LPSTR lpName;			/* topic name or group title */
	LPSTR lpGroupName;		/* if it is a group, get the name */
	HTITLE hTitle;			/* title handle (for interfile references) */
	} PRINTMARK, far * LPPRINTMARK;

/* Global Variables */
extern int bShowHotspots;			/* hotspots currently visible? */
extern int iKerningBoundary;		/* kerning boundry for text */
extern HANDLE hAccTable; 			/* handle to accelerator table */
extern HWND hMainWnd;				/* handle to main window */
extern HWND hFP;					/* face plate handle */
extern HWND hHist;					/* handle of history list window */
extern HWND hSearch;				/* handle of the search results window */
extern HANDLE hTopicList;			/* search results topic list */
extern HANDLE hHighlights;			/* search results highlights list */
extern int showHits;				/* show the search highlights? */
extern HBRUSH hHitBrush;			/* current brush for search hilights */
extern HANDLE hWordWheel;			/* the current open word wheel */
extern int iIndex;					/* the currently open index group number */
extern LPGROUPUI lpGroups;			/* group list for the title */
extern LPGROUPUI lpKeyIndex;		/* list of keyword index groups */
extern LPTOPIC lpSecondary;			/* the secondary window (a TOPIC) */
extern RECT rcSecondary;			/* Remember the secondary window position */
extern HFILE hfAnnotation;			/* Annotation file handle */

			 
/*
 * These are supposed to be defined in windowsx.h on all platforms, 
 * but sometimes are not.
 */
#if !defined(GET_WM_COMMAND_CMD)
#define GET_WM_COMMAND_CMD(wp, lp)                   HIWORD(lp)
#endif
#if !defined(GET_WM_COMMAND_ID)
#define GET_WM_COMMAND_ID(wp, lp)                   (wp)
#endif
#if !defined(GET_WM_HSCROLL_CODE)
#define GET_WM_HSCROLL_CODE(wp, lp)                 (wp)
#endif
#if !defined(GET_WM_HSCROLL_POS)
#define GET_WM_HSCROLL_POS(wp, lp)                  LOWORD(lp)
#endif
#if !defined(GET_WM_VSCROLL_CODE)
#define GET_WM_VSCROLL_CODE(wp, lp)                 (wp)
#endif
#if !defined(GET_WM_VSCROLL_POS)
#define GET_WM_VSCROLL_POS(wp, lp)                  LOWORD(lp)
#endif

/*
 * If the Windows 95 SDK is not installed, these are not defined.
 */
#if !defined(WS_EX_CLIEEEEENTEDGE)
#define WS_EX_WINDOWEDGE        0x00000100L
#define WS_EX_CLIENTEDGE        0x00000200L
#define WS_EX_OVERLAPPEDWINDOW  (WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE)
#endif


