/*
 * The ANNOTATION embedded window DLL. This DLL handles the
 * MediaView Embedded Window protocol (EWM_* messages).
 *
 * This DLL is used in support of the nMVInsertEmbeddedeWindow call
 * and the ANNOTATION feature of the example player.
 *
 * The embedded windows will have an AuthorData string consisting
 * of 3 numbers: <topicNum> <va> <lch>.
 * These are built up in the application (see annotate.c).
 *
 * The whole bitmap is a hotspot. On LBUTTONDOWN the application
 * is called back (via the ew.fnHotspotCallback) with these three
 * values..
 *
 * Application must set the callback using fMVSetHotspotCallback.
 * 
 */
  
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <windows.h>
#include <windowsx.h>
#include <medv14.h>
#include <mvew14.h>
#include "annotate.h"
#include "annres.h"

#ifdef WIN32
#define DLL_EXPORT __declspec(dllexport)
#define EXPORT
#else
#define DLL_EXPORT _export
#define EXPORT _export
#define FILE_BEGIN 0
#define FILE_CURRENT 1
#define FILE_END 2
#endif

/*
 * This structure holds the information about each annotation instance.
 * It will be associated with the hWnd for the button that appears
 * in the title.
 */
 typedef struct tagANNDATA
 	{
	EWDATA ew;				/* the CreateParms extra information */
	long topicNum;			/* the topic number */
	VA va;					/* the virtual address (and key) of the note */ 
	DWORD lch;				/* offset in VA */
	} ANNDATA, far * LPANNDATA;

/* forward declarations */
#ifdef WIN32
BOOL WINAPI LibMain( HINSTANCE hInstance,DWORD  fdwReason, LPVOID  lpvReserved);
#else
int WINAPI LibMain(HINSTANCE hInstance,unsigned short wDataSeg,unsigned short wHeapSize,LPSTR lpCmdLine);
#endif
int WINAPI EXPORT InitiateAnnotate(HINSTANCE hInstance);
int WINAPI TerminateAnnotate(HINSTANCE hInstance);
long CALLBACK EXPORT EWProc(HWND hWnd,unsigned int msg,unsigned int wParam,long lParam);
long InitEW(HWND hWnd, WPARAM wParam, LPARAM lParam);
long DestroyEW(HWND hWnd, WPARAM wParam, LPARAM lParam);
long PrintEW(HWND hWnd, LPRENDERINFO lpRI);
long GetEWSize(HWND hWnd, HDC hDC, LPPOINT lpP);
long ActivateEW(HWND hWnd, WPARAM wParam, LPARAM lParam);
long GetEWPalette(HWND hWnd, WPARAM wParam, LPARAM lParam);
long CopyEW(HWND hWnd, UINT flags, LPRENDERINFO lpRI);
long PaintEW(HWND hWnd, HDC hDC, LPRECT lprc);
long GetEWNumHotspots(HWND hWnd, WPARAM wParam, LPARAM lParam);
long SetEWHotHighlight(HWND hWnd, WPARAM wParam, LPARAM lParam);
long CopyEWSpecial(HWND hWnd, WPARAM wParam, LPARAM lParam);
long SetSelectedEW(HWND hWnd, WPARAM wParam, LPARAM lParam);
long GetEWHighlightRect(HWND hWnd, WPARAM wParam, LPARAM lParam);
long ClearEWHighlights(HWND hWnd, WPARAM wParam, LPARAM lParam);
DWORD string2DW(LPSTR sz);
void AnnotationHotspot(HWND hWnd);
int GetEWHotInfo(HWND hWnd, WPARAM wParam, LPARAM lParam);

#define SKIPTO(p, c) while(*p && *p != c) ++p

/* preserve the instance handle */
HINSTANCE ghInst = 0;

/* the ANNOTATION button bitmap */
HBITMAP hAnnBM = 0;

/* a place to store information in the hWnd */
#define GWL_ANNOTATE 0

/*
 * This DLL supports the ANNOTATE embedded window class for MediaView 1.3
 * and the database support routines for the annotations.
 */

char szEWClassName[] = MVANNOTATE;


/* Initiate the DLL. */
int WINAPI EXPORT InitiateAnnotate(HINSTANCE hInst)
	{
	WNDCLASS wc;

	ghInst = hInst;

	wc.lpszClassName  = szEWClassName;
	wc.style          = CS_VREDRAW | CS_HREDRAW;
	wc.hCursor        = 0;
	wc.hIcon          = 0;
	wc.lpszMenuName   = 0;
	wc.hbrBackground  = 0;
	wc.hInstance      = hInst;
	wc.lpfnWndProc    = EWProc;
	wc.cbClsExtra     = 0;
	wc.cbWndExtra     = sizeof(long);

	if (!RegisterClass(&wc))
		return FALSE;

 	/* Load the button bitmap */
	hAnnBM = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_ANNOTATE));
	return TRUE;
	}

int WINAPI TerminateAnnotate(HINSTANCE hInst)
	{           
	UnregisterClass(szEWClassName, hInst);
	if (hAnnBM)
		DeleteObject(hAnnBM);
	return(0);
	}

/****************************************************************************
 **     FUNCTION: LibMain                                                  **
 **     PURPOSE: initialize the embedded window DLL                        **
 **     COMMENTS:                                                          **
 ****************************************************************************/
#ifdef WIN32
BOOL WINAPI LibMain( HINSTANCE hInstance,DWORD  fdwReason, LPVOID  lpvReserved)
	{
	if (fdwReason == DLL_PROCESS_ATTACH)
		return(InitiateAnnotate(hInstance));
	else if (fdwReason == DLL_PROCESS_DETACH)
		TerminateAnnotate(hInstance);
	}
#else
BOOL WINAPI LibMain( HINSTANCE hInstance, WORD wDataSeg, WORD wHeapSize, LPSTR lpCmdLine)
	{
	return(InitiateAnnotate(hInstance));
	}
#endif

/****************************************************************************
 **     FUNCTION: EWProc                                                   **
 **     PURPOSE: Embedded Window procedure. Handles all messages,          **
 **        including the EWM_* messages sent from MediaView.					 **
 **     COMMENTS:                                                          **
 **        Return TRUE/FALSE for EWM_* messages, or Windows message        **
 **        returns as needed.                                              **
 ****************************************************************************/
long CALLBACK EXPORT EWProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
	{
	long iRet;
	PAINTSTRUCT ps;
	RECT rect;

	switch(msg)
		{
	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 26 code here. ********/
	/*******************************************************/
		default:
			return DefWindowProc(hWnd, msg, wParam, lParam);
		}
	}     
	
/****************************************************************************
 **     FUNCTION: InitEW                                                   **
 **     PURPOSE: Initialize the embedded window.                           **
 **     COMMENTS:                                                          **
 ****************************************************************************/
long InitEW(HWND hWnd, WPARAM wParam, LPARAM lParam)
	{
	LPCREATESTRUCT lpCreate;
	LPEWDATA lpEW;
	long topicNum;
	VA va;
	DWORD lch;
	LPSTR p, q;
	LPANNDATA lpA;

	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 26 code here. ********/
	/*******************************************************/

	return(0);
    }
               
/****************************************************************************
 **     FUNCTION: DestroyEW                                                **
 **     PURPOSE: Destroy the embedded window.                              **
 **     COMMENTS:                                                          **
 ****************************************************************************/
long DestroyEW(HWND hWnd, WPARAM wParam, LPARAM lParam)
	{
	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 26 code here. ********/
	/*******************************************************/
	return(FALSE);
	}


/****************************************************************************
 **     FUNCTION: GetEWSize                                                **
 **     PURPOSE: Tell MediaView the Embedded Window size (or tell          **
 **       it to use the default size).                                     **
 **     COMMENTS:                                                          **
 **       This is called so that MediaView can layout text around it.      **
 ****************************************************************************/
long GetEWSize(HWND hWnd, HDC hDC, LPPOINT lpP)
	{
	BITMAP bm;
	
	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 26 code here. ********/
	/*******************************************************/
   
	return(TRUE);
	}       

/****************************************************************************
 **     FUNCTION: PaintEW                                                  **
 **     PURPOSE: Render the embedded window.                               **
 **     COMMENTS:                                                          **
 ****************************************************************************/
long PaintEW(HWND hWnd, HDC hDC, LPRECT lpR)
	{
	HDC hTmpDC;
	HBITMAP hOldBM;

	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 26 code here. ********/
	/*******************************************************/
	return(TRUE);	
	}       



 /****************************************************************************
 **     FUNCTION: string2DW                                                **
 **     PURPOSE: Convert a string into a number                            **
 **     COMMENTS:                                                          **
 **        The strtoul or atol functions are not available to NT programs. **
 ****************************************************************************/
 DWORD string2DW(LPSTR sz)
 	{
	DWORD dw = 0;
	LPSTR p;

	p = sz;
	while (*p)
		dw = 10*dw +  (*p++ - '0');

	return(dw);
	}

/****************************************************************************
 **     FUNCTION: WEP                                                      **
 **     PURPOSE: Standard Windows Exit Procedure                           **
 **     COMMENTS:                                                          **
 **        The EXPORT makes sure we can access the global variable in DS. **
 ****************************************************************************/
#ifndef WIN32
int CALLBACK EXPORT WEP(int nExitType)
	{
	TerminateAnnotate(ghInst);
	return(1);
	}
#endif

