/*
 * This file contains the MVPANECLASS window class code for the example player.
 */

#include <stdlib.h>
#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <string.h>
#include <stdarg.h>

/* MediaView Include Files */
#include <medv14.h>

/* Application Include Files */
#include "topic.h"
#include "player.h"
#include "pane.h"
#include "resrc1.h"
#include "proto.h"

/* Global Variables for Panes */
HWND hCaptureWnd = 0;                           /* initially un-captured */

/* are we currently selecting? */
int selecting = FALSE;
HWND hSelectCapture = 0;

/*****************************************************************************
 **	FUNCTION: Pane_Register													**
 **	PURPOSE: Register the window class for the Pane							**
 **	COMMENTS:																**
 **		The MVPaneClass contains extra bytes for holding Pane data.			**
 **		See pane.h for details.												**
 *****************************************************************************/
BOOL Pane_Register(HINSTANCE hInstance)
	{
	WNDCLASS wc;

	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 20 code here. ********/
	/*******************************************************/
	}

/*****************************************************************************
 **	FUNCTION: Pane_Create													**
 **	PURPOSE: Create a new Pane.												**
 **	COMMENTS:																**
 **		This call creates a MediaView (MV) and a window for displaying		**
 **		it.																	**
 *****************************************************************************/
HWND Pane_Create(HWND hParentWnd, HINSTANCE hInstance, HTITLE hTitle, int type, int paneFlags, PANEHOTPROC fpHotProc)
	{
	HWND hWnd;
	LPMV lpMV;
	ERR err;
	LPPANE lpP;

	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 20 code here. ********/
	/*******************************************************/

	return(hWnd);
	}


/*****************************************************************************
 **	FUNCTION: Pane_Destroy													**
 **	PURPOSE: Destroy the Pane.												**
 **	COMMENTS:																**
 *****************************************************************************/
void Pane_Destroy(HWND hWnd)
	{
	LPMV lpMV = GetPaneMV(hWnd);
	LPPANE lpP = GetPaneData(hWnd);
	HTHLITE hHits;
	
	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 20 code here. ********/
	/*******************************************************/
	}

/*****************************************************************************
 **	FUNCTION: PaneWndProc													**
 **	PURPOSE: Process messages sent to the Pane.								**
 **	COMMENTS:																**
 *****************************************************************************/
long WINAPI PaneWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
	{
	PAINTSTRUCT ps;
	HDC hDC;
	LPPANE lpP = GetPaneData(hWnd);

	switch (message) 
		{
	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 20 code here. ********/
	/*******************************************************/
			
		default:
			return (DefWindowProc(hWnd, message, wParam, lParam));
		}
	return (0);
	}

/*****************************************************************************
 **	FUNCTION: Pane_Draw														**
 **	PURPOSE: Repaint the pane.												**
 **	COMMENTS:																**
 *****************************************************************************/
int Pane_Draw(HWND hWnd, HDC hDC, LPRECT lpR)
	{
	ERR err;
	RECT rect;
	LPMV lpMV = GetPaneMV(hWnd);
	LPPANE lpP = GetPaneData(hWnd);

	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 20 code here. ********/
	/*******************************************************/
	}

/*****************************************************************************
 **	FUNCTION: Pane_Layout													**
 **	PURPOSE: Realize the Pane ... this does not actually paint, that		**
 **		is done handling the WM_PAINT message.								**
 **	COMMENTS:																**
 *****************************************************************************/
void Pane_Layout(HWND hWnd, LPRECT lpR)
	{
	LPMV lpMV = GetPaneMV(hWnd);
	LPPANE lpP = GetPaneData(hWnd);
	ERR err;

	if (lpMV == 0)
		return;

	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 20 code here. ********/
	/*******************************************************/

	return;
	}






/*****************************************************************************
 **	FUNCTION: Pane_Hotspot													**
 **	PURPOSE: This is the default PANE hotspot handler hotspot handler		**
 **	COMMENTS:																**
 **		This is what is called if the Pane_Open was passed a NULL			**
 **		pointer for the fpHotspotProc argument.								**
 *****************************************************************************/
BOOL CALLBACK Pane_Hotspot(LPMV lpMV, LPMVHOTINFO lpHI)
	{

	if (lpMV == 0)
		return(FALSE);
	
	switch (lpHI->nType)
		{

		case HOTSPOT_HASH:
			break;

		case HOTSPOT_POPUPHASH:
			break;

		case HOTSPOT_STRING:
			/* put string hotspot handling here */
			break;
			
		case HOTSPOT_UNKNOWN:
		default:
			/* handle unknown hotspots here */
			return(FALSE);
			break;
		}
	return(TRUE);
	}
 
/*****************************************************************************
 **	FUNCTION: Pane_SetAddress												**
 **	PURPOSE: Set the MediaView address.										**
 **	COMMENTS:																**
 *****************************************************************************/
int Pane_SetAddress(HWND hWnd, VA va, long scroll)
	{
	ERR err;
	LPMV lpMV = GetPaneMV(hWnd);
	LPPANE lpP = GetPaneData(hWnd);
	int iSubTopic;

	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 20 code here. ********/
	/*******************************************************/

	/* the display update is done from the calling routine */
	return(0);
	}
 
/*****************************************************************************
 **	FUNCTION: Pane_Popup													**
 **	PURPOSE: manifest a topic in a POPUP window								**
 **	COMMENTS:																**
 **		Popups will cascade. If the mouse is clicked outside an active		**
 **		popup, this code will clean them up back to the window with the		**
 **		click.																**
 *****************************************************************************/
int Pane_Popup(LPMV lpParentMV, LPRECT lpR, VA va)
	{


	return(TRUE);
	}

/*****************************************************************************
 **	FUNCTION: Pane_CloseAllPopups											**
 **	PURPOSE: If any Popups are in effect, close them.						**
 **	COMMENTS:																**
 *****************************************************************************/
HWND Pane_CloseAllPopups(HWND hWnd)
	{
	return(hWnd);
	}



/*****************************************************************************
 **	FUNCTION: Pane_KeyDown													**
 **	PURPOSE: Process the keydown message.									**
 **	COMMENTS:																**
 *****************************************************************************/
void Pane_KeyDown(HWND hWnd, WPARAM wParam, LPARAM lParam)
	{



	}


