
/* 
 * The TOPIC structure is the basic display unit of a topic. It contains
 * a two PANES, a scrolling and non-scrolling region (either of which can 
 * be empty).
 */
typedef struct tagTOPIC
	{
	int isOpen;				/* is the topic fully open? */
	HWND hTopic;			/* the Topic window itself */
	HWND hSR;				/* the scrolling region window */
	HWND hNSR;				/* the non-scrolling region window */
	HWND hActive;			/* which of the two is most recently clicked in? */
	HWND hParent;			/* the parent of the topic */
	} TOPIC, far * LPTOPIC;

/* these define the offsets to the Topic data stored in the window structure */
#define GWL_TOPIC				0
#define EXTRA_TOPIC_SIZE	sizeof(long)

/* and MACROs for getting and setting the window data */
#define GetTopicPtr(hWnd) ((LPTOPIC)GetWindowLong(hWnd, GWL_TOPIC))
#define SetTopicPtr(hWnd, lpT) SetWindowLong(hWnd, GWL_TOPIC, (long)lpT)

/* the TOPIC Windows class */
#define MVTOPICCLASS "MV13TopicClass"

/* message for identifying "TOPIC" focus */
#define UWM_TOPIC_FOCUS WM_USER+3000
#define UWM_TOPIC_DESTROY WM_USER+3001
