/*
 * Function prototypes for MediaView 1.4 Sample Code.
 */
#ifdef WIN32
#define EXPORT
#else
#define EXPORT _export
#endif

int MV_Search(LPMV lpMV, int scope, int andFlag, char ** groupList, char * szSearch, HWND hDlg);
BOOL EXPORT PASCAL MV_SearchInterrupt(LPVOID lpData, LPVOID lpOther);
void MV_ShowSearchResults(LPMV lpMV);
void MV_GoToFromSearchResults(HWND hDlg, LPMV lpMV, LPVA lpVA);
int MV_ScrollToSearchHighlight(LPMV lpMV, int sNum);
void MV_UpdateSearchHits(LPMV lpMV);
void MV_ScrollToNextHighlight(LPMV lpMV);
int MV_Keywords(LPMV lpMV, HWND hList, HWND hGroups);
int MV_IndexLookup(HWND hMainWnd, HWND hList, HWND hSearch, LPTOPIC lpT);
void MV_LoadIndexHits(HWND hWnd, LPMV lpMV);
void MV_GoToFromIndex(HWND hWnd, LPMV lpMV);
int MV_IndexSelect(HWND hwnd, LPSTR szKey);
void MV_AddToHistory(LPMV lpMV);
void MV_HistoryGetTopic(struct tagHISTORY * pH, LPMV lpMV);
void MV_ShowHistory(LPMV lpMV, HWND hwnd);
void MV_GoToFromHistory(int index, LPVA lpVA, LPHTITLE lphTitle, LPLONG lpScroll);
void MV_CleanupHistory();
int MV_Back(LPHTITLE lphTitle, LPVA lpVA, LPLONG lpScroll);
void MV_BackAdjust1(int oldB);
void MV_BackAdjust2();
int MV_AddBookmark(HWND hwnd, LPMV lpMV, LPSTR szName);
void MV_ShowBookmarks(HWND hwnd, HWND hMainWnd);
void MV_GoToFromBookmark(int bm, LPHTITLE lphTitle, LPVA lpVA, LPLONG lpScroll);
int MV_DelBookmark(HWND hwnd, HWND hMainWnd);
int MV_AddPrintMark(LPMV lpMV, HWND hMarks, HWND hGroups, int markType);
int MV_ShowMarkList(HWND hWnd);
int MV_DelPrintMark(HWND hMarks);
int MV_FreePrintMarks();
int MV_PrintAll(LPMV lpMV, HDC hdc);
int MV_PrintMarkList(LPMV lpMV, HDC hdc);
struct tagPRINTTOPIC * MV_CreateTopicList(LPMV lpMV, LPINT lpNum);
int MV_PrintCurrentTopic(LPMV lpMV, HDC hdc);
int MV_PrintTopicList(LPMV lpMV, HDC hdc, struct tagPRINTTOPIC * lpPT, long numTopics);
BOOL _export far PASCAL MV_PageCallBack(LONG lNotUsed, HDC hdc, RECT rectPrinter,
                                             LPRECT lpPage, BOOL fStartPage);
BOOL MV_UpdateOptions(LPMV lpMV);
int MV_SetMagnifier(LPMV lpMV, int mag);
int MV_GetCharStyles(LPMV lpMV, HWND hWnd);
int MV_SetCharStyle (LPTOPIC lpT, HWND hWnd);
int MV_LoadKeyIndexes(LPMV lpMV);
void MV_LoadGroups(LPMV lpMV);
void MV_ErrorMessage(WORD err, LPBYTE lpBuf, int cbBuff);
BOOL CALLBACK MV_Hotspot(LPMV lpMV, LPMVHOTINFO lpHI);
BOOL MV_HotspotString(LPMV lpMV, LPCSTR lp);
BOOL MV_AddAnnotation(LPTOPIC lpT);
void MV_ReDisplay(LPTOPIC lpT);
LPMV MV_SetAddressInTitle(HTITLE hTitle, LPMV lpMV, VA va);
BOOL MV_ChangeAddress(HTITLE hTitle, LPTOPIC lpT, VA va, long scroll);
BOOL MV_NextPrev(LPTOPIC lpT, int type);
int MV_EntryMacro(LPTOPIC lpT);
BOOL Pane_Register(HINSTANCE hInstance);
HWND Pane_Create(HWND hParentWnd, HINSTANCE hInstance, HTITLE hTitle, int type, int paneFlags, PANEHOTPROC fpHotProc);
HWND Pane_Duplicate(LPMV lpParentMV, int type);
void Pane_Destroy(HWND hWnd);
long WINAPI PaneWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
int Pane_Draw(HWND hWnd, HDC hDC, LPRECT lpR);
void Pane_Layout(HWND hWnd, LPRECT lpR);
void Pane_CheckHorz(HWND hWnd, LPMV lpMV);
void Pane_ScrollVert(HWND hWnd, WPARAM wParam, LPARAM lParam);
void Pane_ScrollHorz(HWND hWnd, WPARAM wParam, LPARAM lParam);
void Pane_ScrollRanges(LPMV lpMV);
void Pane_MouseMove(HWND hWnd, WPARAM wParam, LPARAM lParam);
void Pane_MouseLButtonDown(HWND hWnd, WPARAM wParam, LPARAM lParam);
void Pane_MouseLButtonUp(HWND hWnd, WPARAM wParam, LPARAM lParam);
void Pane_MouseDoubleClick(HWND hWnd, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK Pane_Hotspot(LPMV lpMV, LPMVHOTINFO lpHI);
int Pane_SetAddress(HWND hWnd, VA va, long scroll);
int Pane_Popup(LPMV lpParentMV, LPRECT lpR, VA va);
HWND Pane_CloseAllPopups(HWND hWnd);
HWND Pane_UnPopup(HWND hWnd);
HWND Pane_PopupButtonDown(HWND hWnd, WPARAM wParam, LPPOINT lpt);
void Pane_PopupPosition(LPMV lpMV, HWND hWnd, int x, int y);
void RectClientToScreen(HWND hWnd, LPRECT lpR);
BOOL Pane_CopySelection(LPMV lpMV);
void Pane_KeyDown(HWND hWnd, WPARAM wParam, LPARAM lParam);
POINT Pane_PopupInitSize(HWND hWnd, HWND hParentWnd, LPRECT lpR);
void Pane_ProportionScroll(HWND hWnd, int iType);
WORD Pane_ProportionPosition(HWND hWnd, int iType, WORD pos);
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow);
BOOL InitApplication(HANDLE hInstance);
BOOL InitInstance(HANDLE hInstance, int nCmdShow);
long WINAPI MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LONG lParam);
void UI_ResizeFacePlate(HWND hMain, HWND hFP, HWND hTopic, HWND hTOC);
void UI_ConvertCoordinates(HWND hTo, HWND hFrom, LPRECT lpR);
void UI_SizeTopicInWindow(HWND hWnd, int control, HWND hTopic, int border);
BOOL WINAPI FacePlateDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
BOOL WINAPI AboutDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
BOOL WINAPI SearchDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
BOOL WINAPI CharStylesDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
BOOL WINAPI BookmarkDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
void UI_EnableBookmarkControls(HWND hDlg);
BOOL WINAPI EWCountDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
BOOL WINAPI MagnifyDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
BOOL WINAPI KerningDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
BOOL WINAPI IndexDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
BOOL WINAPI IndexResultsDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
BOOL WINAPI HistoryDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
BOOL WINAPI MarkDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
void UI_EnableMarkControls(HWND hDlg);
BOOL WINAPI SearchResultsDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
void ErrorMsg(LPSTR szText, LPSTR szCaption);
void UI_EnableControls(HWND hDlg, int status, ...);
void UI_EnableMenuItems(HWND hWnd, int * pItemList, int iCount, UINT uEnable);
int UI_ToggleMenuItem(HWND hWnd, int iMenuItem);
char ** UI_GetGroups(HWND hDlg);
LPGROUPUI UI_FreeGroups(LPGROUPUI lpGroup);
void UI_UpdateEnable(int statusP, int statusN, int statusC);
void UI_InitCursors(HINSTANCE hInst);
void UI_DeleteCursors();
void UI_CloseTitles();
int UI_ParseCmdLine(LPSTR lpC, LPSTR *argv, int maxArg);
LPTOPIC UI_OpenFile(LPSTR szFileName, HINSTANCE hInstance, HTITLE hTitle, LPSTR szInitialTopic);
HWND UI_CreateTOC(HINSTANCE hInstance, HTITLE hTitle);
void UI_CloseFile();
int UI_KeywordGroups(HWND hGroups);
void UI_NextHighlight(BOOL state);
BOOL UI_BaggageTest(HTITLE hTitle);
LPSTR UI_Online(LPSTR szRawName, LPSTR buff);
BOOL Topic_Register(HANDLE hInstance);
long WINAPI TopicWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
LPTOPIC Topic_Create(HINSTANCE hInstance, HTITLE hTitle, HWND hParent, DWORD style, LPSTR szInitialTopic, PANEHOTPROC fpHotProc);
void Topic_Destroy(LPTOPIC lpT);
int Topic_Layout(LPTOPIC lpT);
BOOL Topic_SetTopic(LPTOPIC lpT, VA va, long scroll);
void Topic_Contents(LPTOPIC lpT);
void Topic_HotspotHighlights(LPTOPIC lpT, int OnOff);
void Topic_TextColor(LPTOPIC lpT, COLORREF color);
void Topic_HighlightLook(LPTOPIC lpT, HBRUSH hH);
int Topic_CopyTopic(LPTOPIC lpT);
HANDLE Topic_GetWholeTopic(LPTOPIC lpT);
BOOL Topic_CopySelection(LPTOPIC lpT);
BOOL Topic_SelectColor(LPTOPIC lpT, COLORREF rgbBG);
BOOL Topic_ClearSelection(LPTOPIC lpT);
LPMV Topic_ValidMV(LPTOPIC lpT);
int Topic_GroupEntry(LPTOPIC lpT);
BOOL WINAPI AnnotateDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
void CatchEdits(HWND hDlg);
LPSTR CheckDuplicate(HWND hList, LPSTR szTopicName);
DWORD string2DW(LPSTR sz);
int WriteRecord(HFILE hf, long topicNum, VA va, DWORD lch, LPSTR szTopicName, LPSTR szData);
long CopyFileBytes(HFILE hfDst, HFILE hfSrc, long count);
long CopyToEnd(HFILE hfDst, HFILE hfSrc);
BOOL DeleteRecord(HFILE hf, long topicNum, VA va, DWORD lch);
BOOL FindRecord(HFILE hf, long topicNum, VA va, DWORD lch, LPLONG lpOffset);
long EXPORT PASCAL GetNextRecord(HFILE hf, LPLONG lpOffset, LPLONG lptopicNum, LPVA lpva, LPDWORD lplch);
BOOL EXPORT PASCAL ReadRecordNum(HFILE hf, int num, LPLONG lptopicNum, LPVA lpva, LPDWORD lplch, LPSTR * lpszTopicName, LPSTR * lpszTopicText);
BOOL ReadRecord(HFILE hf, long offset, LPSTR * lpszTopicName, LPSTR * lpszData);
HFILE EXPORT PASCAL OpenAnnotation(LPSTR szFilename);
int EXPORT PASCAL AddAnnotation(LPMV lpMV, HFILE hFile, long topicNum, VA va, DWORD lch, LPSTR szTopicName);
long EXPORT PASCAL GetAnnotation(HFILE hf, LPLONG lpOffset, LPLONG lptopicNum, LPVA lpva, LPDWORD lplch);
void EXPORT PASCAL AnnotationCallback(LPMV lpMV, long topicNum, VA va, DWORD lch);
BOOL UpdateAnnotations(LPMV lpMV);
BOOL InsertAnnotation(LPMV lpMV, long topicNum, VA va, DWORD lch);
