/* Hotspot callback interface */
typedef  int (CALLBACK * PANEHOTPROC)(LPMV lpMV, LPMVHOTINFO lpHI);

/* structure for holding PANE data */
typedef struct tagPANE
	{
	int iType;					/* pane type: SR_PANE, SR_PANE, POPUP_PANE */
	HWND hWndParent;			/* the parent window (set by creator) */
	PANEHOTPROC fpHotProc;		/* hotspot handler */
	WORD flags;					/* flags */
	RECT rcHotspot;				/* pending hotspot for click */
	int bClickPending;			/* saw a MOUSEDOWN, waiting for MOUSEUP */
	} PANE, * LPPANE;

/* these define the offsets to the Pane data stored in the window structure */
#define GWL_PANE_LPMV		0
#define GWL_PANE_DATA		1*sizeof(long)
#define EXTRA_PANE_SIZE		2*sizeof(long)

/* and MACROS for getting and setting the data from the window */
#define GetPaneMV(hWnd) (LPMV)GetWindowLong(hWnd, GWL_PANE_LPMV)
#define GetPaneData(hWnd) (LPPANE)GetWindowLong(hWnd, GWL_PANE_DATA)
#define SetPaneMV(hWnd, lpMV) SetWindowLong(hWnd, GWL_PANE_LPMV, (long)lpMV)
#define SetPaneData(hWnd, lpP) SetWindowLong(hWnd, GWL_PANE_DATA, (long)lpP)

#ifdef WIN32
#define GetPaneInstance(hWnd) (HINSTANCE)GetWindowLong(hwndMVGetWindow(hWnd), GWL_HINSTANCE)
#define _export
#else
#define GetPaneInstance(hWnd) (HINSTANCE)GetWindowWord(hwndMVGetWindow(hWnd), GWW_HINSTANCE)
typedef int INT;
typedef int far * LPINT;
#endif // WIN32

/* pane type ... the first 2 correspond to the subTopic identifiers */
#define NSR_PANE		0
#define SR_PANE		1
#define POPUP_PANE	2001

/* Pane flags */
#define P_NOHITS	1	/* supress search highlights? */ 
#define P_NOSIZE	2	/* skip processing of WM_SIZE? */
#define P_NOSELECT	4	/* supress text selection? */

/* Messages to/from the window class */
#define UWM_PANE_FOCUS	(WM_USER + 2000)

/* misc. typedefs */
typedef VA * LPVA;
typedef HTITLE * LPHTITLE;

/* PANE Window class */
#define MVPANECLASS "MV14PaneClass"
