/*
 * This file contains miscellaneous MediaView handling code.
 */

#include <stdlib.h>
#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <mmsystem.h>
#include <string.h>
#include <memory.h>
#include <ctype.h>
#include <stdarg.h>

/* MediaView Include Files */
#include <medv14.h>
#include <mverror.h>

/* Application Include Files */
#include "topic.h"
#include "player.h"
#include "pane.h"
#include "annotate.h"
#include "resrc1.h"
#include "proto.h"







/****************************************************************************
 **     FUNCTION: MV_SearchInterrupt                                       **
 **     PURPOSE: Callback routine for searching.                           **
 **     COMMENTS:                                                          **
 **       MediaView will call this routine periodically to see if the      **
 **       search should be canceled. It is installed with MVTitleOpenEx.   **
 **       The EXPORT must be set because it is called back from within the **
 **       MediaView DLL.                                                   **
 ****************************************************************************/
BOOL EXPORT PASCAL MV_SearchInterrupt(LPVOID lpData, LPVOID lpOther)
 	{
	extern int gStopSearch;

	/* initially 0, this variable set if "Stop Search" button is pushed */
	return (gStopSearch);     
	}




 





/****************************************************************************
 **     FUNCTION: MV_ErrorMessage                                          **
 **     PURPOSE: Map the error number to a message   .                     **
 **     COMMENTS:                                             .            **
 ****************************************************************************/
void MV_ErrorMessage(WORD err, LPBYTE lpBuf, int cbBuff)
	{
	extern HINSTANCE ghInstance;
	LoadString(ghInstance, err, lpBuf, cbBuff);
	}

/****************************************************************************
 **     FUNCTION: MV_Hotspot                                               **
 **     PURPOSE: This is the default PANE hotspot handler hotspot handler  **
 **     COMMENTS:                                                          **
 **        This hotspot handler gets installed instead of the default      **
 **        handler (Pane_Hotspot).  It processes string hotspots as well   **
 **        as the usual HASH hotspots. All jumps are routed to the topic.  **
 ****************************************************************************/
BOOL CALLBACK MV_Hotspot(LPMV lpMV, LPMVHOTINFO lpHI)
	{
	VA va;
	HANDLE hTitle;
	HWND hWnd;
	extern LPTOPIC lpTopic;

	if (lpMV == 0)
		return(FALSE);
	
	switch (lpHI->nType)
		{
		case HOTSPOT_STRING:
			break;
		case HOTSPOT_HASH:
			/* a jump closes all open popups */
			hWnd = Pane_CloseAllPopups(hwndMVGetWindow(lpMV));

			/* this hWnd is the base Pane. Use its MV. */
			lpMV = GetPaneMV(hWnd);

			/* convert the hash data into a VA */
			hTitle = hMVGetTitle(lpMV, NULL);
			va = vaMVConvertHash(hTitle, (HASH)(lpHI->hash));
			if (!MV_ChangeAddress(0, lpTopic, va, 0))
				return(FALSE);
			break;
		case HOTSPOT_POPUPHASH:
			/* convert the hash data into a VA */
			hTitle = hMVGetTitle(lpMV, NULL);
			va = vaMVConvertHash(hTitle, (HASH)(lpHI->hash));

			if (!Pane_Popup(lpMV, &(lpHI->r), va))
				return(FALSE);
			break;

		case HOTSPOT_UNKNOWN:
		default:
			/* handle unknown hotspots here */
			return(FALSE);
		}
		
	return(TRUE);
	}


	
/****************************************************************************
 **     FUNCTION: MV_SetAddressInTitle                                     **
 **     PURPOSE: Set address in the MV watching out for an inter-file      **
 **        jump                                                            **
 **     COMMENTS:                                                          **
 **        Make sure that the address reflects a valid subTopic.           **
 ****************************************************************************/
LPMV MV_SetAddressInTitle(HTITLE hTitle, LPMV lpMV, VA va)
	{
	ERR err;
	
	/* check for invalid VA */
	if (va == vaNil)
		return(0);

	/* is this an interfile jump? */
	if (hTitle != hMVGetTitle(lpMV, 0))
		{
		if (!fMVSetTitle(lpMV, hTitle, 0, &err))
			return(0);
		}

	/* jump to the new topic ... be sure to get a valid subtopic */
	if (!fMVSetAddress(lpMV, va, NSR_PANE, 0, &err))
		if (!fMVSetAddress(lpMV, va, SR_PANE, 0, &err))
			return(0);

	return(lpMV);
	}

/****************************************************************************
 **     FUNCTION: MV_ChangeAddress                                         **
 **     PURPOSE: Update the display with new MV topics.                    **
 **     COMMENTS:                                                          **
 **       The model in this application is to only update the TOPIC window **
 **       (the TOC window stays constant).                                 **
 ****************************************************************************/
BOOL MV_ChangeAddress(HTITLE hTitle, LPTOPIC lpT, VA va, long scroll)
	{
	int statusP, statusN, statusC;
	LPMV lpMV = Topic_ValidMV(lpT);
	
	/* check for invalid VA */
	if (va == vaNil)
		return(0);

	/* are we crossing into another file? */
	if (hTitle && hTitle != hMVGetTitle(lpMV, NULL))
		{
		/* get the new title assigned to the Topic and TOC pane */
		lpT = UI_OpenFile(0, GetPaneInstance(lpMV), hTitle, 0);
		lpMV = Topic_ValidMV(lpT);
		}
 	Topic_SetTopic(lpT, va, scroll);

 	/*
 	 * If there is anything to do between setting the address and
	 * actually doing the layout, this is the spot.	In this
	 * application it is:
	 * 1. insert annotation markers for the new topic (scrolling region only).
	 * 2. process "macro" commands
	 * 3. Determine whether there are any visible search hits.
	 */


 	/* now update the display */
	Topic_Layout(lpT);
	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 6 code here. *********/
	/*******************************************************/

	return(TRUE);
	}
	
/****************************************************************************
 **     FUNCTION: MV_NextPrev                                              **
 **     PURPOSE: Jump to the next or previous topic in the browse group    **
 **     COMMENTS:                                                          **
 ****************************************************************************/
BOOL MV_NextPrev(LPTOPIC lpT, int type)
	{
	LPMV lpMV = Topic_ValidMV(lpT);
	ADDR addr;
	VA va;
	HTITLE hTitle = hMVGetTitle(lpMV, NULL);
	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 6 code here. *********/
	/*******************************************************/
	return(TRUE);
	}

