/*
 * This file handles all of the user interface issues for
 * the MediaView example player.
 */
#include <stdlib.h>
#include <ctype.h>
#include <memory.h>	 
#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <string.h>
#include <stdarg.h>
#include "ctl3d.h"

/* MediaView Include Files */
#include <medv14.h>

/* Application Include Files */
#include "topic.h"
#include "player.h"
#include "pane.h"
#include "annotate.h"
#include "resrc1.h"
#include "proto.h"

/*
 * This applicaton keeps around 1 TOPIC (window with scrolling and
 * non-scrolling regions), and a single PANE containing the contents
 * page of the current title.
 */
LPTOPIC lpTopic = {0};     
HWND hTOC = 0;

/*
 * Global Variables.
 */
HANDLE hAccTable = 0; 		/* handle to accelerator table */
HWND hMainWnd = 0;			/* handle to main window */
HWND hFP = 0;				/* face plate handle */
HWND hActiveTopic = 0;		/* Which Topic has the "focus" */
int numOpenTitles = 0;		/* number of open titles */
HTITLE *OpenTitles = 0;		/* table of open title handles */
char gErrBuff[512] = {0};	/* printer error buffer */
char szWindowTitle[] = "MediaView 1.4 Example Player";

LPSTR szInitialTopic = 0;
/* variables for GetOpenFilename commmon dialog */
OPENFILENAME ofn = {0};
char szFilterSpec [128] =		/* file type filters */
             "MediaView 1.4 (*.M14)\0*.M14\0All Files (*.*)\0*.*\0";
char szFileName[_MAX_PATH] = {0};
char szFileTitle[_MAX_PATH] = {0};


/* cursors for different hotspot types */
HCURSOR curT = 0;
HCURSOR curB = 0;
HCURSOR curE = 0;
HCURSOR curU = 0;
HCURSOR curArrow = 0;
HCURSOR curIbeam = 0;
HCURSOR curWait = 0;

/* main Window Class */
#define MVAPPCLASS "MVAppClass"

/****************************************************************************
 **     FUNCTION: WinMain                                                  **
 **     PURPOSE: initialize and call do main processing loop               **
 **     COMMENTS:                                                          **
 ****************************************************************************/
int WINAPI WinMain(
	HINSTANCE hInstance,
	HINSTANCE hPrevInstance,
	LPSTR lpCmdLine,
	int nCmdShow)
	{
	MSG msg;  
	int ret = TRUE;

	/* Enable the 3-D controls */
	Ctl3dRegister(hInstance);
	Ctl3dAutoSubclass(hInstance);
	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 3 code here. *********/
	/*******************************************************/

	if (!hPrevInstance)
		if (!InitApplication(hInstance))
			{
			ret = FALSE;
			goto exit;
			}
		
	if (!InitInstance(hInstance, nCmdShow))
			{
			ret = FALSE;
			goto exit;
			}

	/* do initial sizing of faceplate and source window */
	UI_ResizeFacePlate(hMainWnd, hFP, 0, 0);

	/* everything is set up, show the main window */
	ShowWindow(hMainWnd, SW_SHOW);


	/* the main message loop */
	while (GetMessage(&msg, 0, 0, 0)) 
		{ 
		if (!TranslateAccelerator(hMainWnd, hAccTable, &msg))
			{
			TranslateMessage(&msg);
			DispatchMessage(&msg); 
			}
		}
	ret = msg.wParam;
	exit:

	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 3 code here. *********/
	/*******************************************************/

	/* clean up the 3 -D controls */
	Ctl3dUnregister(hInstance);
	return(ret);
	}


/****************************************************************************
 **     FUNCTION: InitApplication                                          **
 **     PURPOSE: initialize window data and registers window class         **
 **     COMMENTS:                                                          **
 ****************************************************************************/
BOOL InitApplication(HANDLE hInstance)
	{
	WNDCLASS  wc;

	wc.style = 0;
	wc.lpfnWndProc = MainWndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon = LoadIcon (hInstance, "myicon");
	wc.hCursor = LoadCursor(0, IDC_ARROW);
	wc.hbrBackground = GetStockObject(LTGRAY_BRUSH); 
	wc.lpszMenuName =  "MVAppMenu";
	wc.lpszClassName = MVAPPCLASS;
	if (RegisterClass(&wc) == 0)
		return(FALSE);

	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 3 code here. *********/
	/*******************************************************/
	return(TRUE);
	}

/****************************************************************************
 **     FUNCTION: InitInstance                                             **
 **     PURPOSE: create the windows and create the button bar              **
 **     COMMENTS:                                                          **
 ****************************************************************************/
BOOL InitInstance(HANDLE hInstance, int nCmdShow)
	{
	
	hAccTable = LoadAccelerators(hInstance, "MVAppAccelerators");

	/* create the main application window */
	hMainWnd = CreateWindowEx(
#ifdef WIN32
			WS_EX_OVERLAPPEDWINDOW,
#else
			0,
#endif
			MVAPPCLASS,
			szWindowTitle,
    	    WS_OVERLAPPEDWINDOW,
			0,
			0,
			640,
			480,
			0,
			0,
			hInstance,
			0 );

	if (!hMainWnd)
		return (FALSE);      
		
	ShowWindow(hMainWnd, SW_HIDE);
	UpdateWindow(hMainWnd);

	/* manifest the button bar */
	if ((hFP = CreateDialog(hInstance, "FacePlateDlg", hMainWnd, (DLGPROC)FacePlateDlgProc)) == 0)
		return(FALSE);

	/* fill in non-variant fields of OPENFILENAME struct. */
	ofn.lStructSize       = sizeof(OPENFILENAME);
	ofn.hwndOwner	  = hMainWnd;
	ofn.lpstrFilter	  = szFilterSpec;
	ofn.lpstrCustomFilter = 0;
	ofn.nMaxCustFilter	  = 0;
	ofn.nFilterIndex	  = 1;
	ofn.lpstrFile         = szFileName;
	ofn.nMaxFile	  		 = sizeof(szFileName);
	ofn.lpstrInitialDir   = 0;
	ofn.lpstrFileTitle    = szFileTitle;
	ofn.nMaxFileTitle     = sizeof(szFileTitle);
	ofn.lpstrTitle        = 0;
	ofn.lpstrDefExt       = "M14";
	ofn.Flags             = OFN_HIDEREADONLY;

	UI_InitCursors(hInstance);
	return (TRUE);
	}

/****************************************************************************
 **     FUNCTION: MainWndProc                                              **
 **     PURPOSE: Handle top level messages to the main window              **
 **     COMMENTS:                                                          **
 ****************************************************************************/
long WINAPI MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LONG lParam)
	{
	UINT cmd;
	ERR err = 0;
	LPSTR szFilename;
#ifdef WIN32
	HINSTANCE hInst = (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);
#else
	HINSTANCE hInst = (HINSTANCE)GetWindowWord(hWnd, GWW_HINSTANCE);
#endif	//WIN32

	switch (message) 
		{
#ifdef WIN32
		/* ALT-TAB to another application on NT loses the mouse
		 * capture, so re-capture it when re-activated.
		 */
		case WM_ACTIVATEAPP:
			{
			extern HWND hCaptureWnd;
			if (wParam == TRUE && hCaptureWnd)
				SetCapture(hCaptureWnd);
				break;
			}
#endif
	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 3 code here. *********/
	/*******************************************************/



		case WM_COMMAND:

			cmd = GET_WM_COMMAND_ID(wParam, lParam);
			switch (cmd) 
				{
				case ID_FILE_OPEN:
					/* call the common dialog to get a file name */
					if (!GetOpenFileName ((LPOPENFILENAME)&ofn))
						break;
					szFilename = ofn.lpstrFile;
					
					UI_OpenFile(szFilename, hInst, 0, szInitialTopic);
					break;
				case ID_FILE_EXIT:
					DestroyWindow(hWnd);
					break;
				case ID_HELP_ABOUT:
					DialogBox(hInst, "AboutDlg", hWnd, AboutDlgProc);
					break;
				default:
					break;
				} 
			break;

		case WM_DESTROY:
	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 3 code here. *********/
	/*******************************************************/
			/* any other resources to free? */
			UI_CloseTitles();
			UI_DeleteCursors();  
			if ( hFP )
				DestroyWindow(hFP);
			PostQuitMessage(0);            
			break;

		default:
			/* otherwise ... */
			return (DefWindowProc(hWnd, message, wParam, lParam));
		}
	return (0);
	}

/****************************************************************************
 **     FUNCTION: UI_ResizeFacePlate                                       **
 **     PURPOSE: Respond to size changes in the parent and resize the      **
 **       FacePlate.  This includes resizing the Topic display window.      **
 **     COMMENTS:                                                          **
 ****************************************************************************/
void UI_ResizeFacePlate(HWND hMain, HWND hFP, HWND hTopic, HWND hTOC)
	{
	RECT rect;
	int x, y;    
	int xT = 0;
	int xV = 0;
	
	/* size the whole face plate */
	GetClientRect(hMain, &rect);
	x = rect.right - rect.left;
	y = rect.bottom - rect.top;
	MoveWindow(hFP, 0, 0, x, y, TRUE);

	/* size the Topic display frame */
	#define FRAME 10
	#define BORDER 2
	GetClientRect(GetDlgItem(hFP, IDC_INDEX), &rect);
	UI_ConvertCoordinates(hFP, GetDlgItem(hFP, IDC_INDEX), &rect);

	MoveWindow(GetDlgItem(hFP, IDC_STATIC), FRAME, FRAME, x - 2*FRAME, y - 2*FRAME, TRUE);

	/* size the Topic with a 2 pixel border inside the right faceplate window */
	if (hTopic)
		UI_SizeTopicInWindow(hFP, IDC_STATIC, hTopic, BORDER);

	InvalidateRect(hFP, 0, TRUE);
	}

/****************************************************************************
 **     FUNCTION: UI_ConvertCoordinates                                    **
 **     PURPOSE: Convert the RECT coordiantes from one origin to another   **
 **     COMMENTS:                                                          **
 ****************************************************************************/
 void UI_ConvertCoordinates(HWND hTo, HWND hFrom, LPRECT lpR)
 	{
	POINT pt;

	pt.x = lpR->left;
	pt.y = lpR->top;
	ClientToScreen(hFrom, &pt);
	ScreenToClient(hTo, &pt);
	lpR->left = pt.x;
	lpR->top = pt.y;
	pt.x = lpR->right;
	pt.y = lpR->bottom;
	ClientToScreen(hFrom, &pt);
	ScreenToClient(hTo, &pt);
	lpR->right = pt.x;
	lpR->bottom = pt.y;
	}

/****************************************************************************
 **     FUNCTION: UI_SizeTopicInWindow                                     **
 **     PURPOSE: Size the Topic into a particular control in a window.     **
 **     COMMENTS:                                                          **
 **       The border allows the Topic to have a margin inside the control. **
 ****************************************************************************/
void UI_SizeTopicInWindow(HWND hWnd, int control, HWND hTopic, int border)
	{ 
	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 3 code here. *********/
	/*******************************************************/
	}

/****************************************************************************
 **     FUNCTION: FacePlateDlgProc                                         **
 **     PURPOSE: Dispatch the buttons from the button bar                  **
 **     COMMENTS:                                                          **
 ****************************************************************************/
BOOL WINAPI FacePlateDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
	{   
	return (FALSE);
	}

/****************************************************************************
 **     FUNCTION: AboutDlgProc                                             **
 **     PURPOSE: About box handling                                        **
 **     COMMENTS:                                                          **
 ****************************************************************************/
BOOL WINAPI AboutDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
	{
	UINT cmd;
	switch (message) 
		{
		case WM_INITDIALOG:
			SetFocus(hDlg);
			break;

		case WM_CLOSE:
			EndDialog(hDlg, FALSE);
			return(TRUE);
			break;

		case WM_COMMAND:
			cmd = GET_WM_COMMAND_ID(wParam, lParam);
			switch (cmd)
				{
				case IDOK:
					EndDialog(hDlg, TRUE);
					return(TRUE);
				}
			break;
		}
	return (FALSE);
	}
     

	         


/****************************************************************************
 **     FUNCTION: ErrorMsg                                                 **
 **     PURPOSE: show an error string dialog box                           **
 **     COMMENTS:                                                          **
 ****************************************************************************/
void ErrorMsg(LPSTR szText, LPSTR szCaption)
	{
	extern HWND hMainWnd;
	extern HWND hCaptureWnd;

	MessageBox (
					hMainWnd,
					szText,
					szCaption,
					MB_ICONASTERISK | MB_OK);

	/* MessageBox takes back the mouse. Reset the mouse capture. */
	if (hCaptureWnd)
		SetCapture(hCaptureWnd);
	}

/****************************************************************************
 **     FUNCTION: UI_EnableControls                                        **
 **     PURPOSE: Enable/Disable a set of controls                          **
 **     COMMENTS:                                                          **
 ****************************************************************************/
void UI_EnableControls(HWND hDlg, int status, ...)
	{
	va_list marker;
	int control;

	va_start(marker, status);
	while ((control = va_arg(marker, int)) != 0)
		EnableWindow(GetDlgItem(hDlg, control), status);

	va_end(marker);
	}

/****************************************************************************
 **     FUNCTION: UI_EnableMenuItems                                       **
 **     PURPOSE: Enable/Disable a set of menu items                        **
 **     COMMENTS:                                                          **
 ****************************************************************************/
void UI_EnableMenuItems(HWND hWnd, int * pItemList, int iCount, UINT uEnable)
	{
	HMENU hMenu = GetMenu(hWnd);
	while (iCount--)
		EnableMenuItem(hMenu, *pItemList++, uEnable);
	}

/****************************************************************************
 **     FUNCTION: UI_ToggleMenuItem                                        **
 **     PURPOSE: toggle the CHECKED/UNCHECKED state of the menu item       **
 **     COMMENTS:                                                          **
 ****************************************************************************/
int UI_ToggleMenuItem(HWND hWnd, int iMenuItem)
	{
	int state;

	state = GetMenuState(GetMenu(hWnd), iMenuItem, MF_BYCOMMAND);
	state = (state == MF_CHECKED ? MF_UNCHECKED : MF_CHECKED);
	CheckMenuItem(GetMenu(hWnd), iMenuItem, state);
	return(state);
	}

	
/****************************************************************************
 **     FUNCTION: UI_UpdateEnable                                          **
 **     PURPOSE: Enable/disable things in the UI according to the status   **
 **     COMMENTS:                                                          **
 ****************************************************************************/
void UI_UpdateEnable(int statusP, int statusN, int statusC)
	{

	HMENU hMenu = GetMenu(hMainWnd);



	}

/****************************************************************************
 **     FUNCTION: UI_InitCursors                                           **
 **     PURPOSE: Load up the cursors                                       **
 **     COMMENTS:                                                          **
 ****************************************************************************/
void UI_InitCursors(HINSTANCE hInst)
	{
	curT = LoadCursor(hInst, "HAND_T");
	curE = LoadCursor(hInst, "HAND_E");
	curB = LoadCursor(hInst, "HAND_B");
	curU = LoadCursor(hInst, "HAND_U");
	curArrow = LoadCursor(0, IDC_ARROW);
	curIbeam = LoadCursor(0, IDC_IBEAM);
	curWait = LoadCursor(0, IDC_WAIT);
	}

/****************************************************************************
 **     FUNCTION: UI_DeleteCursors                                         **
 **     PURPOSE: Free up the cursors                                       **
 **     COMMENTS:                                                          **
 ****************************************************************************/
void UI_DeleteCursors()
	{                  
	if ( curT )
		DestroyCursor(curT);
	if ( curE )
		DestroyCursor(curE);
	if ( curB )
		DestroyCursor(curB);
	if ( curU )
		DestroyCursor(curU);
	curT = curE = curB = curU = 0;
	
	/* no need to destroy the standard windows cursors. */
	}

/****************************************************************************
 **     FUNCTION: UI_CloseTitles                                           **
 **     PURPOSE: Close all open titles.                                    **
 **     COMMENTS:                                                          **
 ****************************************************************************/
void UI_CloseTitles()
	{
	int i;  
	if (OpenTitles)
		{
		for (i = 0; i < numOpenTitles; ++i)
			MVTitleClose(OpenTitles[i]);
		GlobalFreePtr(OpenTitles);
		OpenTitles = 0;
		}
	}

/****************************************************************************
 **     FUNCTION: UI_ParseCommandLine                                      **
 **     PURPOSE: Put the command line in the same form as a C program.     **
 **     COMMENTS:                                                          **
 ****************************************************************************/
int UI_ParseCmdLine(LPSTR lpC, LPSTR *argv, int maxArg)
	{
	int i;

	for (i = 0; i < maxArg; ++i)
		{
		if (*lpC == 0)
			break;
		while (*lpC && isspace(*lpC))
			++lpC;
		argv[i] = lpC;
		while (*lpC && !isspace(*lpC))
			++lpC;
		if (*lpC != 0)
			*lpC++ = 0;
		}
	return(i);
	}

LPTOPIC UI_OpenFile(LPSTR szFileName, HINSTANCE hInstance, HTITLE hTitle, LPSTR szInitialTopic)
	{          
	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 3 code here. *********/
	/*******************************************************/
		


	/* position the whole thing correctly in the face plate */
	UI_ResizeFacePlate(hMainWnd, hFP, (lpTopic?lpTopic->hTopic:0), hTOC);
	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 3 code here. *********/
	/*******************************************************/

	SetCursor(curArrow);

	/* BUGBUG: map the DLL names for online or local DLLs */
	return(lpTopic);
	}


/****************************************************************************
 **     FUNCTION: UI_CloseFile                                             **
 **     PURPOSE: Close the open title.                                     **
 **     COMMENTS:                                                          **
 **       If the title is being "closed" in the middle of the application  **
 **       it is still in the history list, so only free the associated     **
 **       resources. 			   	                                       **
 ****************************************************************************/
 void UI_CloseFile()
 	{                   
	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 3 code here. *********/
	/*******************************************************/
	}


/****************************************************************************
 **     FUNCTION: UI_NextHighlight                                         **
 **     PURPOSE: Turn on the Next Highlight menu/button?                   **
 **     COMMENTS:                                                          **
 ****************************************************************************/
void UI_NextHighlight(BOOL state)
	{
	HMENU hMenu = GetMenu(hMainWnd);

	UI_EnableControls(hFP, state, IDC_NEXTHIGHLIGHT, 0);
	EnableMenuItem(hMenu, ID_VIEW_NEXTHIGHLIGHT, MF_BYCOMMAND | (state ? MF_ENABLED: MF_GRAYED));
	}

/*****************************************************************************
 **     FUNCTION: UI_BaggageTest											**
 **     PURPOSE: Test the Baggage APIs										**
 **     COMMENTS:															**
 **			The file "TEST.XYZ" was placed in baggage of the MYTHS.M14		**
 **			test title. This routine demonstrates the use of the Baggage	**
 **			APIs.															**
 *****************************************************************************/
BOOL UI_BaggageTest(HTITLE hTitle)
	{
	HMVFILE hf;
	HANDLE hMem;
	LPBYTE lpB;
	DWORD dw;
	char c;
	ERR err;

	/* 100th char in file is 99 */
	hMem = hMVBaggageGetFile(hTitle, "TEST.XYZ", TRUE, 0, 100, &dw, &err);
	if (hMem == 0)
		return(FALSE);
	lpB = GlobalLock(hMem);
	if (lpB[99] != 99)
		return(FALSE);
	GlobalFree(hMem);
	hMem = 0;
	
  	/* open, check that size is 100 */
  	hf = hMVBaggageOpen(hTitle, "test.xyz", TRUE, &err);
	if (hf == 0)
		return(FALSE);
 	if (lMVBaggageSize(hf, &err) != 100)
		return(FALSE);

	/* read value, seek to it */
 	lMVBaggageRead(hf, (LPBYTE)&dw, sizeof(DWORD), &err);
 	lMVBaggageSeek(hf, dw, 0, &err);

	/* read value, seek and read */
 	lMVBaggageRead(hf, (LPBYTE)&dw, sizeof(DWORD), &err);
	lMVBaggageSeekRead(hf, dw, 0, &c, 1, &err);
	if (c != 99)
		return(FALSE);

	/* close the Baggage file */
	MVBaggageClose(hf, &err);

	return(TRUE);
	}       
	

/****************************************************************************
 **     FUNCTION: MV_Hotspot                                               **
 **     PURPOSE: This is the default PANE hotspot handler hotspot handler  **
 **     COMMENTS:                                                          **
 **        This hotspot handler gets installed instead of the default      **
 **        handler (Pane_Hotspot).  It processes string hotspots as well   **
 **        as the usual HASH hotspots. All jumps are routed to the topic.  **
 ****************************************************************************/
BOOL CALLBACK MV_Hotspot(LPMV lpMV, LPMVHOTINFO lpHI)
	{  
	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 3 code here. *********/
	/*******************************************************/
	return(TRUE);
	}
	

/****************************************************************************
 **     FUNCTION: MV_ChangeAddress                                         **
 **     PURPOSE: Update the display with new MV topics.                    **
 **     COMMENTS:                                                          **
 ****************************************************************************/
BOOL MV_ChangeAddress(HTITLE hTitle, LPTOPIC lpT, VA va, long scroll)
	{
	/*******************************************************/
	/******** TUTORIAL: Insert Lesson 3 code here. *********/
	/*******************************************************/
	return(TRUE);
	}

/****************************************************************************
 **     FUNCTION: MV_SearchInterrupt                                       **
 **     PURPOSE: Callback routine for searching.                           **
 **     COMMENTS:                                                          **
 **       Dummy version for early lessons.                                 **
 ****************************************************************************/
BOOL EXPORT PASCAL MV_SearchInterrupt(LPVOID lpData, LPVOID lpOther)
 	{
 	return(0);      
	}

