VERSION 4.00
Begin VB.Form frmMain 
   Caption         =   "Visual Basic Sample"
   ClientHeight    =   5940
   ClientLeft      =   2028
   ClientTop       =   2532
   ClientWidth     =   8196
   Height          =   6612
   Left            =   1980
   LinkTopic       =   "Form1"
   ScaleHeight     =   5940
   ScaleWidth      =   8196
   Top             =   1908
   Width           =   8292
   Begin VB.TextBox txtTopicID 
      Height          =   288
      Left            =   1080
      TabIndex        =   9
      Top             =   600
      Width           =   972
   End
   Begin VB.CommandButton cmbBrws 
      Caption         =   "Brws Fwd"
      Height          =   372
      Index           =   1
      Left            =   4080
      TabIndex        =   8
      Top             =   120
      Width           =   852
   End
   Begin VB.CommandButton cmbBrws 
      Caption         =   "Brws Aft"
      Enabled         =   0   'False
      Height          =   372
      Index           =   0
      Left            =   3120
      TabIndex        =   7
      Top             =   120
      Width           =   852
   End
   Begin VB.CommandButton cmbNav 
      Caption         =   ">>"
      Height          =   375
      Index           =   1
      Left            =   2280
      TabIndex        =   6
      Top             =   120
      Width           =   615
   End
   Begin VB.CommandButton cmbNav 
      Caption         =   "<<"
      Height          =   375
      Index           =   0
      Left            =   1560
      TabIndex        =   5
      Top             =   120
      Width           =   615
   End
   Begin VB.CommandButton cmdContents 
      Caption         =   "Contents"
      Height          =   372
      Left            =   120
      TabIndex        =   4
      Top             =   120
      Width           =   1212
   End
   Begin VB.CheckBox chkHilite 
      Caption         =   "Hilite Hits On"
      Height          =   252
      Left            =   3720
      TabIndex        =   3
      Top             =   600
      Value           =   1  'Checked
      Width           =   1212
   End
   Begin VB.ListBox lstSearchHitIDs 
      Height          =   240
      Left            =   5760
      TabIndex        =   2
      Top             =   5520
      Visible         =   0   'False
      Width           =   1812
   End
   Begin VB.ListBox lstSearchHits 
      Height          =   624
      Left            =   5160
      TabIndex        =   0
      Top             =   240
      Width           =   2532
   End
   Begin MedviewOCX141Lib.Medview ocxControl 
      Height          =   4692
      Left            =   120
      TabIndex        =   11
      Top             =   1080
      Width           =   7932
      _Version        =   65537
      _ExtentX        =   13991
      _ExtentY        =   8276
      _StockProps     =   32
      Connection      =   "MedView"
      LeftMargin      =   1
      TopMargin       =   1
      RightMargin     =   1
      BottomMargin    =   1
      BackColorNSR    =   12307669
      BackColorSR     =   12307669
      BackColorPopup  =   12307669
      NSRTextForeColor=   0
      SRTextForeColor =   0
      PopupTextColor  =   0
      SearchHitLook   =   16777215
      HiliteSearchHits=   -1  'True
      NSRHeight       =   0
      Kerning         =   0   'False
      TopicIndex      =   0
      PopupLeft       =   0
      PopupTop        =   0
      StyleIndex      =   -1
      BackgroundBitmap=   ""
      DoesOLEDragDrop =   0   'False
      StyleArray      =   "main.frx":0000
   End
   Begin VB.Label Label1 
      Caption         =   "Topic Index"
      Height          =   252
      Left            =   120
      TabIndex        =   10
      Top             =   600
      Width           =   852
   End
   Begin MSComDlg.CommonDialog cdlgOpenFile 
      Left            =   4680
      Top             =   8400
      _Version        =   65536
      _ExtentX        =   677
      _ExtentY        =   677
      _StockProps     =   0
   End
   Begin VB.Label Label3 
      Caption         =   "Search Hits"
      Height          =   252
      Left            =   5160
      TabIndex        =   1
      Top             =   0
      Width           =   1092
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileMenu 
         Caption         =   "&Open"
         Index           =   0
      End
      Begin VB.Menu mnuFileMenu 
         Caption         =   "&MSN"
         Index           =   1
      End
      Begin VB.Menu mnuFileMenu 
         Caption         =   "&Print"
         Index           =   2
      End
      Begin VB.Menu mnuFileMenu 
         Caption         =   "E&xit"
         Index           =   3
      End
   End
   Begin VB.Menu mnuSearch 
      Caption         =   "&Search"
   End
   Begin VB.Menu mnuCopy 
      Caption         =   "&Copy"
      Begin VB.Menu mnuNSR 
         Caption         =   "&NSR"
      End
      Begin VB.Menu mnuSR 
         Caption         =   "&SR"
      End
      Begin VB.Menu mnuCopySelection 
         Caption         =   "&Selection"
         Shortcut        =   ^C
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_Creatable = False
Attribute VB_Exposed = False

Dim bNSRPass As Boolean
Dim bSRPass As Boolean
Dim bNSRMouse As Boolean
Dim bSRMouse As Boolean
Dim NSRButton As Integer
Dim NSRShift As Integer
Dim NSRx As Single
Dim NSRy As Single
Dim SRButton As Integer
Dim SRShift As Integer
Dim SRx As Single
Dim SRy As Single
Sub BButton_Enabled()
    If ocxControl.HasPreviousBrowseTopic = True Then
        cmbBrws(0).Enabled = True
    Else
        cmbBrws(0).Enabled = False
    End If
    If ocxControl.HasNextBrowseTopic = True Then
        cmbBrws(1).Enabled = True
    Else
        cmbBrws(1).Enabled = False
    End If
End Sub


Private Sub chkhilite_Click()
    If frmMain.chkhilite.Value = 1 Then
        frmMain.ocxControl.HiliteSearchHits = True
    Else
        frmMain.ocxControl.HiliteSearchHits = False
    End If

End Sub

Private Sub cmbBrws_Click(Index As Integer)
    Dim handle As Long
    Dim lpMV As Long
    Dim pointer As Long
    Dim X As Integer
    
    Select Case Index
    'Browse back one topic in group
    Case 0:
        If ocxControl.HasPreviousBrowseTopic = True Then
            frmMain.ocxControl.PreviousBrowseTopic
            txtTopicID.Text = Str$(ocxControl.TopicIndex)
            cmbBrws(0).Enabled = ocxControl.HasPreviousBrowseTopic
        End If
    'Browse forward one topic in group
    Case 1:
        If ocxControl.HasNextBrowseTopic = True Then
            frmMain.ocxControl.NextBrowseTopic
            txtTopicID.Text = Str$(ocxControl.TopicIndex)
            cmbBrws(1).Enabled = ocxControl.HasNextBrowseTopic
        End If
    End Select

End Sub

Private Sub cmbNav_Click(Index As Integer)
    Dim handle As Long
    Dim lpMV As Long
    Dim pointer As Long
    Dim X As Integer
    
    Select Case Index
    'Go back one topic if not at beginning of topics
    Case 0:
        If ocxControl.TopicIndex > 0 Then
            ocxControl.TopicIndex = ocxControl.TopicIndex - 1
            txtTopicID.Text = Str$(ocxControl.TopicIndex)
        End If
    'Go forward one topic if not at end of topics
    Case 1:
        If ocxControl.TopicIndex < ocxControl.MaxTopics - 1 Then
            ocxControl.TopicIndex = ocxControl.TopicIndex + 1
            txtTopicID.Text = Str$(ocxControl.TopicIndex)
        End If
    End Select
End Sub


Private Sub cmdContents_Click()
    'go to the first topic
    ocxControl.JumpToContents
End Sub


Private Sub Form_Load()
    On Error Resume Next
    
    Dim sMVTitle As String
       
    cdlgOpenFile.Filter = "MediaView Titles|*.m14"
    cdlgOpenFile.ShowOpen
    lstSearchHits.Clear
    lstSearchHitIDs.Clear
    
    sMVTitle = cdlgOpenFile.filename
            
    ' check to see if user is setting an online deid
    If InStr(1, sMVTitle, "[", 1) Then
        frmMain.ocxControl.MediaViewTitle = ""
        frmMain.ocxControl.MediaViewOnlineTitle = cdlgOpenFile.filename
        gbOnline = True
    Else
        ocxControl.MediaViewOnlineTitle = ""
        ocxControl.MediaViewTitle = cdlgOpenFile.filename
        gbOnline = False
    End If
    'disable brws buttons on start up if no browse
    BButton_Enabled
    
    'set form labels backcolor to match Form backcolor
    frmMain.Label1.BackColor = frmMain.BackColor
    frmMain.chkhilite.BackColor = frmMain.BackColor
    'set NSR, SR, and popup backcolor to match Form backcolor
    ocxControl.BackColorNSR = frmMain.BackColor
    ocxControl.BackColorSR = frmMain.BackColor
    ocxControl.BackColorPopup = frmMain.BackColor
    'set online dialog to match Form backcolor
    frmGetOnlineInfo.BackColor = frmMain.BackColor
    frmGetOnlineInfo.Label1.BackColor = frmGetOnlineInfo.BackColor
    frmGetOnlineInfo.Label2.BackColor = frmGetOnlineInfo.BackColor
    'set search dialog to match Form backcolor
    dlgSearch.BackColor = frmMain.BackColor
    dlgSearch.chkAndSearch.BackColor = dlgSearch.BackColor
    dlgSearch.chkHiliteHits.BackColor = dlgSearch.BackColor
    dlgSearch.Label1.BackColor = dlgSearch.BackColor
    dlgSearch.Label2.BackColor = dlgSearch.BackColor
    dlgSearch.Label4.BackColor = dlgSearch.BackColor
    

End Sub



Private Sub Form_Resize()
    ocxControl.Height = frmMain.ScaleHeight - (ocxControl.Top + ocxControl.Left)
    ocxControl.Width = frmMain.ScaleWidth - (ocxControl.Left * 2)
End Sub


Private Sub lstSearchHits_Click()
    'Set the topic to topic in listbox
    lstSearchHitIDs.ListIndex = lstSearchHits.ListIndex
    ocxControl.TopicIndex = Val(lstSearchHitIDs.Text)
    'Set the topicid textbox to the current topic
    txtTopicID.Text = lstSearchHitIDs.Text
End Sub

Private Sub mnuCopySelection_Click()

    'Copy Selection content
    ocxControl.Copy (2)
    
End Sub


Private Sub mnuFileMenu_Click(Index As Integer)
    On Error Resume Next
    Select Case Index
    'File
    Case 0
    Dim sMVTitle As String

    cdlgOpenFile.Filter = "MediaView Titles|*.m14"
    cdlgOpenFile.ShowOpen
    lstSearchHits.Clear
    lstSearchHitIDs.Clear
    
    sMVTitle = cdlgOpenFile.filename
    
    ' check to see if user is setting an online deid
    If InStr(1, sMVTitle, "[", 1) Then
            frmMain.ocxControl.MediaViewTitle = ""
            frmMain.ocxControl.MediaViewOnlineTitle = cdlgOpenFile.filename
            gbOnline = True
    Else
        ocxControl.MediaViewOnlineTitle = ""
        ocxControl.MediaViewTitle = cdlgOpenFile.filename
        gbOnline = False
    End If
    
    'Online
    Case 1
    lstSearchHits.Clear
    lstSearchHitIDs.Clear
    frmGetOnlineInfo.Show
    'Print
    Case 2
        ocxControl.PrintTopic (ocxControl.TopicIndex)
    'Exit
    Case 3
        Unload frmMain
    End Select
End Sub

Private Sub mnuNSR_Click()

    'Copy NSR content
    ocxControl.Copy (0)
End Sub

Private Sub mnuSearch_Click()
        dlgSearch.Top = frmMain.Top
        dlgSearch.Left = frmMain.Left
        dlgSearch.Show 1

End Sub


Private Sub mnuSR_Click()

    'Copy SR content
    ocxControl.Copy (1)
    
End Sub


Private Sub ocxControl_HotspotClicked(ByVal HotspotType As Long, ByVal HotspotData As Long, Cancel As Boolean)
    Dim lpStrAddress As Long, Buff As String

    Select Case HotspotType
    Case MVHOTSPOT_COMMAND
        Buff$ = Space$(6)

        ' Copy LPSTR into a Visual Basic string
        lpStrAddress = lstrcpy(Buff, HotspotData) 'Call the windows lstrcpy API
    
        ' trim string
        Buff = Trim$(Buff)
    End Select
End Sub

Private Sub ocxControl_MouseDownNSR(ByVal Button As Integer, ByVal Shift As Integer, X As Single, Y As Single)
    If bNSRMouse Then
        bNSRPass = True
        NSRButton = Button
        NSRShift = Shift
        NSRx = X
        NSRy = Y
    End If
End Sub

Private Sub ocxControl_MouseDownSR(ByVal Button As Integer, ByVal Shift As Integer, X As Single, Y As Single)
    If bSRMouse Then
        bSRPass = True
        SRButton = Button
        SRShift = Shift
        SRx = X
        SRy = Y
    End If
End Sub

Private Sub ocxControl_MouseUpNSR(ByVal Button As Integer, ByVal Shift As Integer, X As Single, Y As Single)
Dim msg As String
    
    If bNSRMouse And bNSRPass Then
        msg = "NSRMouse Passes" + vbCrLf + "MouseUp Values  Button: " + Str(Button) + "  Shift: " + Str(Shift) + "  x: " + Str(X) + "  y: " + Str(Y)
        msg = msg + vbCrLf + "MouseDown Values  Button: " + Str(NSRButton) + "  Shift: " + Str(NSRShift) + "  x: " + Str(NSRx) + "  y: " + Str(NSRy)
        MsgBox msg
        bNSRPass = False
    End If
End Sub

Private Sub ocxControl_MouseUpSR(ByVal Button As Integer, ByVal Shift As Integer, X As Single, Y As Single)
Dim msg As String
    
    If bSRMouse And bSRPass Then
        msg = "SRMouse Passes" + vbCrLf + "MouseUp Values  Button: " + Str(Button) + "  Shift: " + Str(Shift) + "  x: " + Str(X) + "  y: " + Str(Y)
        msg = msg + vbCrLf + "MouseDown Values  Button: " + Str(SRButton) + "  Shift: " + Str(SRShift) + "  x: " + Str(SRx) + "  y: " + Str(SRy)
        MsgBox msg
        bSRPass = False
    End If
End Sub

Private Sub ocxControl_TopicChanged(ByVal id As Long)
    txtTopicID.Text = Str(id)
End Sub

Private Sub ocxControl_TopicChanging(ByVal id As Long)
    txtTopicID = "Changing" + Str(id)
    txtTopicID.Refresh
    BButton_Enabled
End Sub


Private Sub txtTopicID_KeyPress(KeyAscii As Integer)
    
    On Error GoTo Topic_Error_Handler
    
    'If the enter key is pressed set the current topic
    'to the topic id in the textbox
    If KeyAscii = 13 Then
        ocxControl.TopicIndex = Val(txtTopicID.Text)
    End If
    Exit Sub

Topic_Error_Handler:
        If Err.Number <> ERR_BAD_TOPIC_INDEX Then
            MsgBox "Something other than acceptable error was returned for GoToTopic."
        End If

End Sub
