
#ifndef __MVTITLE_H_
#define __MVTITLE_H_

// medv14 is required
#include <medv14.h>

#ifdef __cplusplus
extern "C" {
#endif

/************************************************************************
*
* MVTTL14.H
*
* Copyright (c) Microsoft Corporation 1993
* All rights reserved.
*
*************************************************************************
*
*   The MVTitle API
*
* Module intent: Header file for the MVTTL14.DLL.
*
************************************************************************/

typedef struct _TITLE TITLE, NEAR *PTITLE, FAR *LPTITLE;

//
// Title API
//
HTITLE FAR PASCAL EXPORT_API TitleOpenEx(LPCSTR, FARPROC, LPVOID, BOOL);
void   FAR PASCAL EXPORT_API TitleClose(HTITLE);
long   FAR PASCAL EXPORT_API TitleGetInfo(HTITLE, int, long, long);
BOOL   FAR PASCAL EXPORT_API TitleValid(HTITLE);
HANDLE FAR PASCAL EXPORT_API TitleQuery(HTITLE,WORD,LPCSTR,LPVOID,LPCSTR,WORD,
											LPVOID,DWORD	FAR *,DWORD FAR *,LPQUERYERR);
ERR    FAR PASCAL EXPORT_API TitleConnection(LPCSTR lpsz);
BOOL   FAR PASCAL EXPORT_API TitleTime(HTITLE, FILETIME FAR *);
HANDLE FAR PASCAL EXPORT_API TitleLoadDLL (HTITLE hTitle, LPCSTR lpszName, LPWORD lpErr);


//
// Addressing API
//
 ADDR   FAR PASCAL EXPORT_API addrConvertHash(HTITLE, HASH);
 ADDR   FAR PASCAL EXPORT_API addrConvertTopicNumber(HTITLE, LONG);
 ADDR   FAR PASCAL EXPORT_API addrConvertContextString(HTITLE, LPCSTR);
 ADDR   FAR PASCAL EXPORT_API addrGetContents(HTITLE);
 DWORD  FAR PASCAL EXPORT_API vaConvertAddr(HTITLE, ADDR);
 DWORD  FAR PASCAL EXPORT_API vaConvertHash(HTITLE, HASH);
 DWORD  FAR PASCAL EXPORT_API vaConvertTopicNumber(HTITLE, LONG);
 DWORD  FAR PASCAL EXPORT_API vaConvertContextString(HTITLE, LPCSTR);
 DWORD  FAR PASCAL EXPORT_API vaGetContents(HTITLE);


//
// Searching API
//
// these take a handle to the SearchHighlights, returned by TopicListFromQuery
HANDLE FAR PASCAL EXPORT_API HighlightsInTopic(HANDLE hGlobalHighlights, long l);
ADDR FAR PASCAL EXPORT_API addrSearchHighlight(HANDLE hGlobalHighlights, long lIndex, long l);
LONG FAR PASCAL EXPORT_API SearchHighlightCount(HANDLE hGlobalHighlights, long lIndex, LPWORD lpErr);
LONG EXPORT_API FAR PASCAL HighlightLookup(HANDLE hGlobalHighlights, long l) ;
void EXPORT_API FAR PASCAL HighlightDestroy(HANDLE hGlobalHighlight);
int FAR PASCAL EXPORT_API HighlightGetGroup(HANDLE hGlobalHighlights, LPVOID lpGroup);


//
//  Word Wheel API.
//
ERR FAR PASCAL EXPORT_API WordWheelQuery(HANDLE hWheel,WORD wFlags,LPCSTR lpstrQuery,LPVOID lpGroupLimit,LPVOID lpGroupHits);
HWHEEL FAR PASCAL EXPORT_API WordWheelOpenTitle(HANDLE hTitle, LPCSTR lpstr, BOOL fReadOnly);
void   FAR PASCAL EXPORT_API WordWheelClose(HWHEEL);
long   FAR PASCAL EXPORT_API WordWheelLength(HWHEEL);
long   FAR PASCAL EXPORT_API WordWheelPrefix(HWHEEL,LPCSTR);
BOOL   FAR PASCAL EXPORT_API WordWheelLookup(HWHEEL,long,LPBYTE,int);
long   FAR PASCAL EXPORT_API KeyIndexGetAddrs (HWHEEL,LPBYTE,int,int,LPBYTE);
WORD   FAR PASCAL EXPORT_API KeyIndexGetCount (HWHEEL,LPBYTE);

//
// Baggage File API
//
VOID EXPORT_API FAR PASCAL BaggageClose (HANDLE hFile, LPERR lpErr);
LONG EXPORT_API FAR PASCAL BaggageSeek (HANDLE hFile, LONG lOffset, int nOrigin, LPERR lpErr);
LONG EXPORT_API FAR PASCAL BaggageRead (HANDLE hFile, BYTE FAR* lpBuf, DWORD dwBytes, LPERR lpErr);
HANDLE EXPORT_API FAR PASCAL BaggageOpen (HTITLE hTitle, LPCSTR lpszFilename, BOOL fBaggage, LPERR lpErr);
LONG EXPORT_API FAR PASCAL BaggageSize (HANDLE hFile, LPERR lpErr);
LONG EXPORT_API FAR PASCAL BaggageSeekRead (HANDLE h, LONG lOffset, int nOrigin, 
											LPBYTE lpBuf, DWORD dwBytes, LPERR lpErr);
HANDLE EXPORT_API FAR PASCAL BaggageGetFile (HTITLE hTitle, LPCSTR lpszFilename, BOOL fBaggage,
											LONG lOffset, DWORD dwBytes,  DWORD FAR *lpdwRead, LPERR lpErr);

MVSTATUS EXPORT_API FAR PASCAL BaggageAsyncGetFile (HTITLE h, 
								MVBGPROC lpfn, DWORD dwUser, 
								DWORD dwStart, DWORD dwBlock,
								LPCSTR lpszFilename, BOOL fBaggage,
								LONG lOffset, DWORD dwBytes, LPERR lpErr);
ERR FAR PASCAL EXPORT_API BaggageAsyncStatus (MVSTATUS lp, long FAR * pRead, long FAR *pTotal, LPBYTE FAR *ppData);
ERR FAR PASCAL EXPORT_API BaggageAsyncClose (MVSTATUS lp);
ERR FAR PASCAL EXPORT_API BaggageAsyncState (MVSTATUS h, BOOL f);



#ifdef __cplusplus
}
#endif

#endif  // __MVTITLE_H_
 
