/*************************************************************************
*                                                                        *
*  Copyright (C) Microsoft Corporation 1990-1994                         *
*  All Rights reserved.                                                  *
*                                                                        *
**************************************************************************
*                                                                        *
*  Module Intent                                                         *
*   All typedefs and defines needed for user's retrieval                 *
*                                                                        *
**************************************************************************
*                                                                        *
*  Current Owner: BinhN                                                  *
*                                                                        *
**************************************************************************
*                                                                        *
*  Released by Development:     (date)                                   *
*                                                                        *
*************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#pragma pack(1)	// Guard against Zp problems.

/*************************************************************************
 *                          Basic defines.
 *************************************************************************/

#if defined(LOMEM) || defined(DOS_ONLY) || defined(_32BIT)
#define	EXPORT_API
#else
#define	EXPORT_API		_export
#endif

#ifdef PRIVATE
#undef PRIVATE
#endif

#ifdef PUBLIC
#undef PUBLIC
#endif

#define	PUBLIC 

#ifdef DEBUG
#define PRIVATE 
#else
#define PRIVATE static
#endif


#ifdef HUGE
#undef HUGE
#endif

#define HUGE    huge

#define fTRUE   1                               // Booleans.
#define fFALSE  0

#ifndef SUCCEED
#define SUCCEED 0                               // Function succeeded
#endif
#ifndef FAIL
#define FAIL  1                               	// Function failed
#endif
#define cbMAX_PATH              (CB)256         // Maximum pathname length.
#define MAX_YEAR        ((unsigned long)0xFFFFFFFF / 366)
#define CB_MAX_WORD_LEN ((CB)255)       // Longest legal word.


/*************************************************************************
 *                          Typedef
 *************************************************************************/

typedef WORD    IB;                     // Index into an array of bytes.
typedef WORD    CB;                     // Count of bytes.
typedef DWORD   LCB;                    // Count of bytes.
typedef WORD    CBIT;                   // Count of bits.
typedef WORD FAR * LPW;					// pointer to word	

typedef BYTE    FAR *LSZ;               // 0-terminated string far pointer
typedef BYTE    FAR *LST;               // Pascal style string far pointer
typedef void    FAR *LPV;               // Far void pointer
typedef BYTE    FAR *LPB;               // Unsigned byte far pointer
typedef DWORD   LFO;                    // 32-bit file offset.
typedef void    NEAR *NPV;              // Void near pointers.

typedef NPV     NPIBI;                  // Near
typedef BYTE    IDXF;
typedef LPV     LPIBI;                  // Far
typedef LPV     LPSIPB;                 // Stop information parameter block.

typedef LPV     LPCAT;                  // Pointer to catalog
typedef LPV		LPGROUP;				// pointer to a group.
typedef LPV     LPIDX;                  // Pointer index block.
typedef LPV     LPQT;                   // Pointer to Query tree.
typedef LPV     LPIPB;                  // Pointer to Index parameter block.
typedef LPV     LPWHEEL;                // Pointer to wheel parameter block.
typedef LPV     LPHL;                   // Pointer to hitlist block.
typedef BYTE    OCCF;

typedef HANDLE  GHANDLE;
typedef HANDLE  HGPOUP;                 // Handle to Group list
typedef DWORD   IDGROUP;                // Group's ID

typedef GHANDLE HIDX;
typedef GHANDLE HFPB;

/*
 *      Occurence field flags.  These are initially used to indicate which
 *      occurence fields are to be indexed.  Once an index is created, the
 *      flags used to create an index are stored in it.  During retrieval
 *      these flags are examined in order to determine how to decode the
 *      index format.  Any combination of these fields is legal, the only
 *      weird thing is that the "OCCF_DOCID" field must be present always.
 */


#define OCCF_NONE       ((OCCF)0x00)    // Blank.
#define OCCF_FIELDID    ((OCCF)0x01)    // Field-ID is present.
#define OCCF_DOCID      ((OCCF)0x02)    // Doc-ID is present.  This should
                                        //  always be set.
#define OCCF_COUNT      ((OCCF)0x04)    // Word-count is present.
#define OCCF_OFFSET     ((OCCF)0x08)    // Byte-offset is present.
#define OCCF_LENGTH     ((OCCF)0x10)    // Word-length is present.

typedef struct  Occurence {
	DWORD   dwFieldId;              // Field-ID.
	DWORD   dwDocID;                // Doc-ID.
	DWORD   dwCount;                // Word-count.
	DWORD   dwSentence;             // Sentence-count.
	DWORD   dwParagraph;    // Paragraph-count.
	DWORD   dwOffset;               // Byte-offset.
	DWORD   dwWordLen;              // Word-length.
}       OCC,
	FAR *LPOCC;


#include <mverror.h>

/*************************************************************************
 *             Word-breaker API and associated defines.
 *************************************************************************/

typedef HANDLE  HIBI;           // "Internal break info".  The individual
                                //  word breakers allocate this

/************************************************************************
 *
 *	            Character Mapping Table Structure
 *
 ************************************************************************/

typedef struct {
    WORD  Class;        // Action controlled class
    WORD  SortOrder;    // Sorting order
    BYTE  Norm;         // Normalized character (for search)
    BYTE  WinCaseSensitiveNorm; // For text copy
    BYTE  MacDisplay;   // Mac's display
    BYTE  MacCaseSensitiveNorm; // For text copy
    BYTE  MacToWin;     // Mapping back from Mac to Win
    BYTE  Padding;      // Padding purpose for word alignment
} CHARMAP, FAR *LPCMAP;


/*************************************************
 *	Character related information table structure
 *  Must match the one in mvfs\btpriv.h
 *************************************************/

typedef struct CHARTAB {
	WORD   wcTabEntries;          // Number of table entries
	LPV    lpBrkrCharTab;         // Char table for breaker (for compability)
	HANDLE hStruct;               // Handle to this structure
	WORD   wcLigature;            // Number of ligature entries
	LPV    lpLigature;            // Ligature table
	WORD   fFlag;                 // Various flags
	HANDLE hLigature;             // Handle to ligature table
	LPCMAP lpCMapTab;             // Character mapping table
    HANDLE hBrkrCharTab;          // Handle to chartab used for breaker
} CHARTAB, FAR *LPCHARTAB;

#define		DEF_LIGATURE_COUNT	5	// Default number of ligature entries

/* Functions' types */

typedef int    (FAR PASCAL * FWORDCB)(LST, LST, DWORD, LPV);

/*
 *	Breaker function's parameter structure:
 *
 *	This structure contains all the informations necessary for a
 *	word breaker. The reason we pass a structure containing all
 *	the parameters, instead of the parameters themselves are:
 *		- Future extension and API backward compability: any new
 *		information can be just added to the structure
 *		- Calls are faster
 */

typedef struct BRK_PARMS {
	LPIBI	   lpInternalBreakInfo;
	LPB		lpbBuf;
	CB		   cbBufCount;
	LCB		lcbBufOffset;
	LPV		lpvUser;
	FWORDCB	lpfnOutWord;
	LPSIPB	lpStopInfoBlock;
	LPCHARTAB	lpCharTab;
	WORD	fFlags;
} BRK_PARMS, FAR *LPBRK_PARMS;

#define	ACCEPT_WILDCARD		1

/* Functions' types */

typedef int    (FAR PASCAL * FWORDCB)(LST, LST, DWORD, LPV);
typedef int     (FAR PASCAL * BREAKER_FUNC) (LPBRK_PARMS);
typedef LPIBI   (FAR PASCAL * BREAKER_INIT)(VOID);
typedef int    (FAR PASCAL * FSTEM)(LST, LST);
typedef short   (FAR PASCAL * ICMPWORDS)(LST, LST);
typedef void    (FAR PASCAL * BREAKER_FREE)(LPIBI);

/*
 *	Functions' names
 */

PUBLIC  LPIBI EXPORT_API FAR PASCAL BreakerInitiate(void);
PUBLIC  void EXPORT_API FAR PASCAL BreakerFree(LPIBI);
PUBLIC  int EXPORT_API FAR PASCAL FBreakWords(LPBRK_PARMS);
PUBLIC  int EXPORT_API FAR PASCAL FBreakAndStemWords(LPBRK_PARMS);
PUBLIC  int EXPORT_API FAR PASCAL FBreakNumber(LPBRK_PARMS);
PUBLIC  int EXPORT_API FAR PASCAL FBreakDate(LPBRK_PARMS);
PUBLIC  int EXPORT_API FAR PASCAL FBreakTime(LPBRK_PARMS);
PUBLIC  int EXPORT_API FAR PASCAL FBreakEpoch(LPBRK_PARMS);
PUBLIC  int EXPORT_API FAR PASCAL FStem(LST, LST);

/* Breaker's information structure. All scanning functions will
   be called indirectly through the functions pointers
*/

typedef struct  BreakerInfo {
	LPIBI			lpibi;				// Internal break info pointer.
	HANDLE		  	hbi;				// Handle to this structure.
	HANDLE		  	hModule;			// "LoadLibrary" handle.
	BREAKER_FUNC    lpfnFBreakWords;	// Pointer to word-breaker function
	BREAKER_FUNC    lpfnFBreakDate;		// Pointer to date-breaker function
	BREAKER_FUNC    lpfnFBreakNumber;	// Pointer to number-breaker function
	BREAKER_FUNC    lpfnFBreakEpoch;	// Pointer to epoch-breaker function
	BREAKER_FUNC    lpfnFBreakTime;		// Pointer to time-breaker function
	BREAKER_FREE    lpfnBreakerFree;	// Ptr to function freeing the breaker
	BREAKER_INIT    lpfnBreakerInit;	// Ptr to function initializing breaker
	FSTEM			lpfnFStem;			// Pointer to stemming function
	ICMPWORDS		lpfnICmpWords;		// Word comparison function
} BI, FAR *LPBRKI;

PUBLIC  LPBRKI EXPORT_API FAR PASCAL BreakerLoad(LSZ, LPERRB);
PUBLIC  void EXPORT_API FAR PASCAL BreakerUnload(LPBRKI);

#define BREAKERBUFFERSIZE       1024            // Size of breaker's state info struct

/*
 *       Breaker Table Constants
 */
#define MAXNUMBRKRS     16     // maximum number of breakers.
#define MAXBRKRLEN      1024  // maximum size of breaker line in |SYSTEM.

/*************************************************************************
 *                     Stop list retrieval API.
 *************************************************************************/


typedef int (FAR PASCAL * STOPLKUP)(LPSIPB, LST);

PUBLIC  LPSIPB EXPORT_API FAR PASCAL StopListInitiate (LPERRB);
PUBLIC  int EXPORT_API FAR PASCAL StopListIndexLoad(HFPB, LPSIPB, LSZ, LPERRB);
PUBLIC  int EXPORT_API FAR PASCAL StopListLookup(LPSIPB, LST);
PUBLIC  void EXPORT_API FAR PASCAL StopListDispose(LPSIPB);
PUBLIC  int EXPORT_API FAR PASCAL StopListAddWord(LPSIPB, LST);
PUBLIC  int EXPORT_API FAR PASCAL StopListLoad(LPSIPB, LSZ, BREAKER_FUNC,
	LPCHARTAB, LPERRB);
PUBLIC  int EXPORT_API PASCAL FAR StopFileBuild (HFPB, LPSIPB, LSZ, LPERRB);

/*************************************************************************
 *                      Query's defines and API
 *************************************************************************/

/* User's operators for retrieval */

#define	AND_OP		0
#define	OR_OP		1
#define	NOT_OP		2
#define	PHRASE_OP	3
#define	NEAR_OP		4

#define DEF_PROX_DIST   8               // Default prox distance

#define IDXF_NONE       ((IDXF)0x00)   // Nothing, just do straight boolean.
#define IDXF_WEIGHT     ((IDXF)0x01)   // Use "tfc" term weighting.
#define KEEP_TEMP_FILE	((IDXF)0X02)	// Debugging flag

/* This leading byte to signal the following font number */
#define EMBEDFONT_BYTE_TAG				3

typedef struct BreakList {
	HANDLE  hnd;		// handle to this structure
	HANDLE  hLib;
	BREAKER_FUNC lpfnBreakFunc;
	LPSIPB		lpStopListInfo;
 	LPCHARTAB	lpCharTab;
} BRKLIST, FAR *LPBRKLIST;

/* Operator table support */
typedef struct OPSYM {
	LPB OpName;             /* Operator name */
	WORD OpVal;             /* Operator value */
} OPSYM, FAR *LPOPSYM;

/* Number of entries in the default OperatorArray */
#define	OPERATOR_ENTRY_COUNT	7

/* Size of the buffer used for Operator table */
#define	OPTABLE_SIZE	100

typedef struct OPTABLE {
	WORD cbLeft;        /* Byte left in the buffer */
	WORD wsize;        	/* Size of the table */
	WORD cEntry;        /* Number of operator entries */
	LPB lpbOptable;     /* Pointer operator symbol table buffer */
	HANDLE hOpTab;      /* Handle to table buffer */
	LPOPSYM lpOpsymTab;	/* Pointer to operator symbol table */
	HANDLE hOpSym;		/* Handle to operator symbol table */
	HANDLE hStruct;     /* Handle to this structure */
	BYTE fFlag[OPERATOR_ENTRY_COUNT];
} OPTABLE, FAR *_LPOPTAB, FAR *LPOPTAB;

PUBLIC LPQT EXPORT_API FAR PASCAL ParseLine (LPB, CB, WORD, WORD, LPBRKLIST,
	LPGROUP, LPERRB);
/*
 *	Parser function's parameter structure:
 *
 *	This structure contains all the informations necessary for
 *	parsing a line. The reason we pass a structure containing all
 *	the parameters, instead of the parameters themselves are:
 *		- Future extension and API backward compability: any new
 *		information can be just added to the structure. Old
 *		information can be removed
 *		- Calls are faster
 */

typedef struct PARSE_PARMS {
	LPB	lpbQuery;		/* Pointer to query buffer */
	WORD cbQuery;		/* Query buffer's length */
	LPBRKLIST lpfnTable; /* Breaker function tables */

	/* Note: all the following fields may be gone in the future if
	 * we provide new operator to support them 
	 */

	WORD cProxDist;		/* Proximity distance */
	WORD cDefOp;		/* Default operator */
	LPGROUP	lpGroup;	/* Group */
	LPOPTAB lpOpTab;	/* Operator table */
} PARSE_PARMS, FAR *LPPARSE_PARMS;

#define TL_QKEY 0x8000    // Use with cDefOp to treat operators as words

PUBLIC LPQT EXPORT_API FAR PASCAL QueryParse(LPPARSE_PARMS, LPERRB);

PUBLIC  void EXPORT_API FAR PASCAL QueryFree(LPQT);

/*************************************************************************
 *               Index & Hitlist Retrieval API
 *************************************************************************/


/*
 *      This is an information buffer structure that you pass to "HitListGetDoc"
 *      which fills in its fields.  You can look at the fields not marked as
 *      "internal", and also pass it to other API functions.
 */

typedef	struct	DocInfo {
	DWORD	dwDocId;		      // Doc-ID associated with this hit.
	DWORD	lcHits;			   // Number of hits in this document.
	union {
		DWORD	liFirstHit;	   // Index in the ROCC file of the first
							      //  hit in this document (internal).
		LPV		lpDocList;	// Pointer to DocList (internal)
	};
	WORD	wWeight;		      // Document-weight.
}	DOC,
	FAR *LPDOC;

/*
 *      This is an information buffer structure that you pass to "HitListGetHit"
 *      which fills in its fields.
 */

typedef	struct	HitInfo {
	DWORD	dwOffset;               // Byte-offset ".
	DWORD dwFieldId;              // Field-ID associated with this hit.
	DWORD	dwCount;
	BYTE	dwLength;               // Word-length ".
}	HIT,
	FAR *LPHIT;


/*
 *      Typedef for interrupt function passed to I/O calls.  A pointer to a
 *      function of this variety is optionally passed along to the indexer
 *      and retrieval engines.  The existence of this function allows the
 *      application writer to build in an "interrupt indexing" and/or
 *      "interrupt search" feature.
 */

typedef int    (FAR PASCAL *FINTERCB)(LPV, LPERRB);

PUBLIC  LPIDX EXPORT_API FAR PASCAL IndexOpen(HANDLE, LSZ, FINTERCB,
	LPV, LPERRB);
PUBLIC  void EXPORT_API FAR PASCAL IndexClose(LPIDX);


// Parameter passed to indexSearch. This should match with medv.h

#define QUERYRESULT_RANK    0x0100 // Ranked the result. If not highest hit 1st
#define QUERYRESULT_UNSORTED    0x0200 // Result topics are 1st in 1st out
#define QUERYRESULT_IN_MEM  0x0400 // Result should be kept in mem
#define QUERYRESULT_GROUPCREATE   0x0800 // Create a group from the hitlist


PUBLIC  LPHL EXPORT_API FAR PASCAL IndexSearch(LPIDX, LPQT, WORD,
    WORD, LPGROUP);

PUBLIC  int EXPORT_API FAR PASCAL HitListFlush(LPHL, DWORD);
PUBLIC  int EXPORT_API FAR PASCAL HitListGetDoc(LPHL, DWORD, LPDOC);
PUBLIC  int EXPORT_API FAR PASCAL HitListGetHit(LPHL, LPDOC, DWORD, LPHIT);
PUBLIC  void EXPORT_API FAR PASCAL HitListDispose(LPHL);
PUBLIC DWORD EXPORT_API PASCAL FAR HitListEntries (LPHL);
PUBLIC LONG EXPORT_API PASCAL FAR HitListMax (LPHL);
PUBLIC BOOL EXPORT_API PASCAL FAR HitListGroup (LPVOID, LPHL);



/*************************************************************************
 *                     Catalog's API
 *************************************************************************/
PUBLIC LPCAT EXPORT_API PASCAL FAR CatalogOpen (HANDLE, LSZ, LPERRB);
PUBLIC int EXPORT_API PASCAL FAR CatalogLookUp (LPCAT, LPB, DWORD);
PUBLIC VOID EXPORT_API PASCAL FAR CatalogClose(LPCAT);


/*************************************************************************
 *                     Character Table Retrieval API
 *************************************************************************/
PUBLIC VOID EXPORT_API FAR PASCAL CharTableDispose (LPCHARTAB);
PUBLIC	LPCHARTAB EXPORT_API FAR PASCAL CharTableIndexLoad(HANDLE, LSZ, LPERRB);
PUBLIC LPCHARTAB EXPORT_API FAR PASCAL CharTableLoad (LPB, LPERRB);


/*************************************************************************
 *                     Operator Table Retrieval API
 *************************************************************************/
PUBLIC LPOPTAB EXPORT_API PASCAL FAR OpTableLoad (LSZ, LPERRB);
PUBLIC VOID EXPORT_API PASCAL FAR OpTableDispose (LPOPTAB);
PUBLIC LPOPTAB EXPORT_API FAR PASCAL OpTableIndexLoad(HANDLE, LSZ, LPERRB);
PUBLIC LPOPTAB EXPORT_API FAR PASCAL DefaultOpTableLoad(LPERRB);



/*****************************************************************************
*
*       MatchCache Structure
*
*	The layout engine expects the matches to be in sorted order and 
*	non-overlapping.  Neither assumption is maintained by the search 
*	engine.  So, when the layout asks for matches for a particular
*	topic, they are sorted and combined and stored in a match cache.
*
*****************************************************************************/

typedef struct _MATCHCACHE {
	long 	lTopic;			// the topic number
	long	lItem;			// the item in the topic list
	long	lMatches;		// the number of matches
	HIT 	match[1];			// array of match information
} MATCHCACHE, NEAR *PMATCHCACHE, FAR *LPMATCHCACHE;


/*************************************************************************
 *                          Index API
 *************************************************************************/


/*
 *      Typedef for interrupt function passed to I/O calls.  A pointer to a
 *      function of this variety is optionally passed along to the indexer
 *      and retrieval engines.  The existence of this function allows the
 *      application writer to build in an "interrupt indexing" and/or
 *      "interrupt search" feature.
 */

typedef int    (FAR PASCAL *FINTERCB)(LPV, LPERRB);
typedef void (PASCAL far * PRINTSTATUSFUNCTYPE)(LPSTR);
typedef int (PASCAL far * PUMPFUNCTYPE)(void);
typedef int (PASCAL far * FNSORT)(LPSTR, LPSTR, LPV);

PUBLIC  LPIPB EXPORT_API FAR PASCAL IndexInitiate(OCCF, IDXF, WORD,
	FINTERCB, LPV, PRINTSTATUSFUNCTYPE, LPV, LPERRB);
PUBLIC  int EXPORT_API FAR PASCAL IndexAddWord(LPIPB, LST, LPOCC);
PUBLIC  int EXPORT_API FAR PASCAL IndexBuild(HFPB, LSZ, LPIPB);
PUBLIC  void EXPORT_API FAR PASCAL IndexDispose(LPIPB);
PUBLIC  int EXPORT_API PASCAL FAR FileSort (LPB, WORD, PRINTSTATUSFUNCTYPE,
	FINTERCB, FNSORT, LPV, BOOL);

/*************************************************************************
 *                         Catalog Index API functions
 *************************************************************************/

PUBLIC LPCAT EXPORT_API PASCAL FAR CatalogInitiate (WORD, LPERRB);
PUBLIC int EXPORT_API PASCAL FAR CatalogAddItem (LPCAT, DWORD, LPB);
PUBLIC int EXPORT_API PASCAL FAR CatalogBuild (LPCAT, HFPB, LSZ,
	FINTERCB, LPV);
PUBLIC VOID EXPORT_API PASCAL FAR CatalogDispose (LPCAT);


/*************************************************************************
 *                       Group Index API
 *************************************************************************/



PUBLIC HANDLE EXPORT_API FAR PASCAL GroupListSetUp (LPERRB);
PUBLIC DWORD EXPORT_API FAR PASCAL GroupIndexInitiate(HANDLE, LSZ, LPERRB);
PUBLIC int EXPORT_API PASCAL FAR GroupIndexAddItem (HANDLE, DWORD,
	DWORD, LPERRB);
PUBLIC int EXPORT_API PASCAL FAR GroupListBuild (HANDLE, LPSTR, HANDLE,
	DWORD, PRINTSTATUSFUNCTYPE, FINTERCB,
	LPERRB);

PUBLIC VOID EXPORT_API PASCAL FAR GroupListFree (HANDLE);


/*************************************************************************
 *                       Word Wheel Index API
 *************************************************************************/

PUBLIC LPWHEEL EXPORT_API PASCAL FAR WWheelInitiate (HANDLE, LSZ, WORD,
   LPV, LPERRB);
PUBLIC int EXPORT_API PASCAL FAR WWheelAddWord (LPWHEEL, LSZ, LPB);
PUBLIC VOID EXPORT_API PASCAL FAR WWheelDispose(LPWHEEL);
PUBLIC int EXPORT_API PASCAL FAR WWheelFileBuild (LPWHEEL);
PUBLIC int EXPORT_API PASCAL FAR SearchMemAlloc (LPB , DWORD);
PUBLIC int EXPORT_API PASCAL FAR SearchMemFree(VOID);

/*************************************************************************
 *                       Character Table Index API
 *************************************************************************/
PUBLIC LPCHARTAB EXPORT_API FAR PASCAL CharTableLoad (LPB, LPERRB);
PUBLIC LPCHARTAB EXPORT_API FAR PASCAL CharTableGetDefault (LPERRB);
PUBLIC VOID EXPORT_API FAR PASCAL CharTableDispose (LPCHARTAB);
PUBLIC int EXPORT_API PASCAL FAR CharTableFileBuild (HFPB,
	LPCHARTAB, LSZ, LPERRB);

/*************************************************************************
 *                       Debug Statistics Index API
 *************************************************************************/
PUBLIC LPDWORD PASCAL FAR TotalIndexedWord(LPIPB);

/*************************************************************************
 *                       Operator Table Index API
 *************************************************************************/
PUBLIC LPOPTAB EXPORT_API PASCAL FAR OpTableLoad (LSZ, LPERRB);
PUBLIC VOID EXPORT_API PASCAL FAR OpTableDispose (LPOPTAB);
PUBLIC int EXPORT_API PASCAL FAR OpTableFileBuild(HFPB, LPOPTAB, LSZ, LPERRB);


#pragma pack()	// Guard against Zp problems.

#ifdef __cplusplus
}
#endif
