#ifndef MVMCI14_H
#define MVMCI14_H

#ifdef __cplusplus
extern "C" {
#endif

/***********************************************************************
*
* MVMCI.H
*
* Copyright (c) Microsoft Corporation 1992 - 1995
* All rights reserved.
*
* (tabs set at 4)
*
************************************************************************
*
* Module intent:
* Provide support for MediaView embedded windows that play MCI devices
*
* This header file is included by the following files:
*   mvmci.c mciwin.c playctrl.c mci.c mmp.c
*
* It includes definitions for globally used constants and structures
* It also includes prototypes for functions in the mvmci.c file.
*
* See MCIWIN.H for a description of how the windows used by MVMCI are
* organized.
*
*
************************************************************************/

#ifndef _MAC
LONG FAR PASCAL EXPORT_API MVMCIWndProc(HWND, UINT, WPARAM, LPARAM);
#else
// IdleMVMCI should be called from Idle Loop
// during playing.
BOOL FAR PASCAL IdleMVMCI( );
BOOL FAR PASCAL StopMVMCI( );
// on the MAC, the return value of MVMCIInitiate positive for success
#endif

int FAR PASCAL MVMCIInitiate(HINSTANCE hInstance);
int FAR PASCAL MVMCITerminate(HINSTANCE hInstance);

// back hack for mv1.2
#define InitiateMVMCI MVMCIInitiate
#define TerminateMVMCI MVMCITerminate

#define MVMCIERRORMSG	"MVMCI1.3WM_ERROR"
/* Error messages from MVMCI Embedded windows are sent
 * to the MV HWND. wParam contains one of the wERRS listed
 * below, and lParam contains a local atom (which the
 * client application must free. This atom contains the
 * string that can be used in presenting an error to the user.
 *
 * If the wParam to this message is less than wERRS_MVMCI_BASE,
 * then the error is an MCI error, and the text can be retrieved
 * with the mciGetErrorString.
 */


/* String IDs */
/* create a string resourse of IDS_MVMCICLASS to change the 
 * windowclass name for MVMCI windows */
#define IDS_MVMCICLASS			6001


#define wERRS_MVMCI_BASE		3000
#define wERRS_MVMCI_MAX			3200

#define wERRS_MVMCIOOM			(wERRS_MVMCI_BASE)
#define wERRS_MVMCIOPENFAILED   (wERRS_MVMCI_BASE+1)
#define wERRS_MVMCIWRONGVERSION		(wERRS_MVMCI_BASE+4)
#define wERRS_MVMCINOMULTIMEDIA	(wERRS_MVMCI_BASE+5)
#define wERRS_MVMCIMISSINGPARAM	(wERRS_MVMCI_BASE+10)
#define wERRS_MVMCIMISSINGARG	(wERRS_MVMCI_BASE+11)
#define wERRS_MVMCIILLEGALARG	(wERRS_MVMCI_BASE+12)
#define wERRS_MVMCICAPTIONSYNTAX (wERRS_MVMCI_BASE+13)
#define wERRS_MVMCIUNKNOWNOPTION (wERRS_MVMCI_BASE+14)
#define wERRS_MVMCISYNTAX		(wERRS_MVMCI_BASE+15)
#define wERRS_MVMCISECTFILE		(wERRS_MVMCI_BASE+16)
#define wERRS_MVMCIILLEGALCOMMAND	(wERRS_MVMCI_BASE+17)
#define wERRS_MVMCIDEVICEOPEN	(wERRS_MVMCI_BASE+20)
#define wERRS_MVMCIEXTENSION	(wERRS_MVMCI_BASE+21)
#define wERRS_MVMCIDEVICEOPENFAIL (wERRS_MVMCI_BASE+22)
#define wERRS_MVMCIUNKNOWN		(wERRS_MVMCI_BASE+23)
#define wERRS_MVMCIBADFILENAME		(wERRS_MVMCI_BASE+24)
#define wERRS_MVMCIDEVICEFAIL		(wERRS_MVMCI_BASE+25)
#define wERRS_MVMCILOADMMP		(wERRS_MVMCI_BASE+30)
#define wERRS_MVMCIPLAYMMP		(wERRS_MVMCI_BASE+31)
#define wERRS_MVMCISTOPMMP		(wERRS_MVMCI_BASE+32)
#define wERRS_MVMCIMEDIAMISSING	(wERRS_MVMCI_BASE+40)


//
// string IDs for MVMCI resources.
#define sidFile						350
#define sidDevice						351
#define sidLoading					352
#define sidMenuPlay					353
#define sidMenuPause					354
#define sidMenuStop					355
#define sidMenuPauses				356
#define sidMenuMute					357
#define sidOptSystem					360
#define sidOptDevice					361
#define sidOptStdControl			362
#define sidOptButtons				363
#define sidOptMenu					364
#define sidOptSlider					365
#define sidOptStepSize				366
#define sidOptRange					367
#define sidOptTracks					368
#define sidOptSections				369
#define sidOptSize					370
#define sidOptMediaID				371
#define sidOptAutoStart				372
#define sidOptLooping				373
#define sidOptNoFrame				374
#define sidOptNoDrag					375
#define sidOptMute					376
#define sidOptCaption				377
#define sidOptSectionFile			378
#define sidOptShare					379
#define sidOptName					380
#define sidButEject					400
#define sidButFrameAdv				401
#define sidButFrameBack				402
#define sidButPause					403
#define sidButPlayPause				404
#define sidButPlay					405
#define sidButRecord					406
#define sidButScanLeft				407
#define sidButScanRight				408
#define sidButSlowMotion			409
#define sidButPrevious				410
#define sidButNext					411
#define sidButStop					412

#ifdef __cplusplus
}
#endif

#endif // MVMCI14_H
