//-----------------------------------------------------------------
// MVIMG14.H
//
// Copyright (c) 1994-1995 Microsoft Corp. 
// All Rights Reserved.
//
//-----------------------------------------------------------------
// This is the external header for the MVIMAGE embedded window library
// for Media View.
//
// To use:
//   If linking statically, call MVIMAGEInitialize (hInstance), where
//  hInstance is your applications instance.
//
//   Install custom image handlers by calling MVIMAGEInstallImageProcs,
//  the requirements of the image procs are documented below.
//
// Authoring:
//  When authoring to use an MVIMAGE embedded window, you should address
//  the classname that is defined by MVIMAGECLASS (this may change, see
//  below for the exact definition), or when linking statically you can 
//  define a string resource which contains the class name. Use
//  IDS_MVIMGCLASS as the string ID. The information must be passed in
//  the string parameter, which is broken into different keys and values.
//  Represent these as "[key=value]".  Multiple keys may be specified as
//  "[key1=value1][key2=value2]".  The following keys are valid:
//
//  Key                 Value                   Example
//  FILENAME            name of file to load    [FILENAME=!IMAGE.DIB]
//                      may preface with ! for
//                      baggage file, or + for
//                      a resource name.
// NOTE: for MVDIB compatibility, text outside of [ ] characters
//  that appear at the end of the string is treated as a filename.
//  The MVIMAGEGetNextToken will point to "FILENAME" in this case.
//  When authoring new titles, this practice should be avoided.
//  
//  16COLOR             name of file to use if  [16COLOR=!IMAGE16.DIB]
//                      the system only supports
//                      16 colors. Same features
//                      as FILENAME.
//
//  CAPTION             Text to display as the  [CAPTION="He said, ""testing"""]
//                      caption. To use the ']' [CAPTION=He said, "testing"]
//                      character, the value must
//                      be inclosed in quotes.
//                      To represent the '"' char.
//                      in this case, use "".
// NOTE: This caption is drawn by the main MVIMAGE library. It is not
// the responsibility of the IMAGERENDERPROC to draw the caption. Installed
// procs can do their own captions, should they desire, in which case this
// key should not be used.
//
//  HOTMACRO            String macro to send when   [HOTMACRO=fJump("BS..CONTENTS")]
//                      the image is clicked on.
//                      The same quotation and ']'
//                      rules apply as desribed for
//                      CAPTION.
//
//  FORCETYPE           Override for the key name   [FORCETYPE=MASK]
//                      to identify which set of
//                      imageprocs to use for reading/
//                      rendering the bitmap.
// NOTE: If FORCETYPE is used, and no filename is given, the
// proc for the type given by FORCETYPE will be called with lpData
// set to NULL.
//
//  NOPRINT				Do not allow this image to be printed.	[NOPRINT]
//
//  NOREAD				Read only the header bytes to identify the	[NOREAD]
//						bitmap type, but let the readerproc read
//						the information from the file.
//
//	MAC					Specifies a different image to use when run
//						on a Macintosh.
//
//	HOTSPOTS			Specifies the file which contains Hotspot [HOTSPOTS=FILE.PLY]
//						information. See description of the 
//
//  COPYRIGHT			Specifies text to be shown when printing   [COPYRIGHT="Copyright (c) Microsoft Corp. 1995"]
//						or copying the image. This text will be 
//						displayed under the image (or under the caption
//						if there is one).
//
//  You may also add your own KEYS, which will be ignored by MVIMAGE, and
//  use the function MVIMAGEGetNextToken to parse it. In the installed
//  proc for reading the image, the string of keys and values is passed in.
//  The same rules for the quote characters applys as for the CAPTION option.
//
// Installing Custom Procs:
//  you can install your own functions for reading/painting the bitmaps.  
//  By default, MVIMAGE will handling BMP files ("BM")
//  and SHG files ("lp").  The file type is identified by the first few bytes
//  in the file, or by the FORCETYPE flag in the EW string.  This tag can be no
//  more than 4 bytes.
//
//  You can install your own handler for your own types, or you can override
// the default ones (tag="BM" for bitmaps, or "lp" for sheds).  Call the
// MVIMAGEInstallImageProcs function to do the installation.  Pass NULL for
// procs you want to use the default for.  However, if you install your own
// proc for reading the data, and use the default for others, your reading
// proc must be compatible with the default (see DefaultBitmapRead and 
// DefaultShedRead, below).
//
// BOOL CALLBACK IMAGEREADPROC(LPMVIMGREADPARAMS lpParams)
//	See definition of lpParams below.  The key fields are described here:
//
// HWND hWnd - The Window the bitmap will be displayed in.
// HDC hDC - An HDC which is, or is compatible with, the HDC that will
//               be used when the image in rendered.
// LPSTR lpszParams - The list of parameters for the EW command.  Use
//              MVIMAGEGetNextToken to process.
// DWORD dwFlags - Embedded window flags. Will indicate if this is for printing
//			copying or display.
// LPBYTE lpData - Pointer to the data from the image file.  If no
//              filename was given, or if reading the file failed,
//              and if the FORCETYPE flag was set, this parameter
//              will be NULL. After IMAGEREADPROC is called, this
//				memory is released.
//				If the MVIMAGE_PROCNOREAD flag was set to the 
//				imageproc installation, then this contains the filenames
//				to read (the hotspot file and the image file name)
//				separated by a tab. If there is no hotspot file, there
//				is no tab character. mvimagePrepareFromPointer should
//				be used to set the 
// DWORD  dwDataSize - number of bytes in the data stream (lpData).
// HANDLE *phImage - This must be set to a handle (or some value) that
//              the other procs can use to render/free the image data.
// HANDLE *phPalette - The palette can be set to NULL, its only purpose
//              is to return it when EWM_ASKPALETTE is called, and to
//              pass it to the render proc.
// LPSIZE lpSize - This should be set to the width and height of the image, in
//              device coords, when it is DRAWN.  This means that the
//              IMAGEREADPROC is responsible for stretching the image
//              for devices such as printers.
//
// BOOL CALLBACK IMAGERENDERPROC (HDC hDC, HANDLE hImage, HPALETTE hPalette, RECT r)
//  HDC hDC - The HDC to draw the image to.
//  HANDLE hImage - the hImage that was set by the IMAGEREADPROC
//  HPALETTE hPalette - the palette returned by IMAGEREADPROC
//  RECT r  - The rectangle to draw into.
//
// BOOL CALLBACK IMAGERELEASEPROC (HANDLE hImage, HPALETTE hPalette)
//  HANDLE hImage - the image handle to release
//  HPALETTE hPalette - palette to free
//
// 
// LONG CALLBACK IMAGEWINDOWPROC (HANDLE hImage, UINT nMsg, WPARAM wParam, LPARAM lParam)
//  If defined, MVIMAGE will forward WM_TIMER,WM_CLOSE,WM_USER and higher messages to this
//  procedure. This is so that multithreaded procs can postmessages to the
//  main thread, and so timers can be used.
//	HANDLE hImage - image handle to release
//  UINT nMsg - message id
//  WPARAM,LPARAM - parameters to message.
//
// Using the Default Functions:
//  There are default procs exported, so that installed proc may use
// them, or so that image reading code can exist in fewer places in an
// application.
//
// IMAGEREADPROC DefaultBitmapRead;
//  DefaultBitmapRead always sets the phHotInfo parameter to NULL.  The
// phImage handle, points to a memory block with the following information:
//      offset 0: BITMAPINFOHEADER - binfo.
//                colortable - An array of biClrUsed RGBQUAD values.
//                bitmap data - bit values.
//  When using the other DefaultBitmap* functions, be sure that the hImage
// handle is formatted as described above.
//
// IMAGERENDERPROC DefaultBitmapRender
//  DefaultBitmapRender expects an hImage of the format described in
// DefaultBitmapRead.  It will realize the palette in the hDC given, and
// stretch the DIB to fit in the Rectangle.
//
// IMAGERELEASEPROC DefaultBitmapRelease
//  Frees a handle of the type described in DefaultBitmapRead. The hHotInfo
// parameter is ignored.
//                  
// IMAGEREADPROC DefaultShedRead;
//  The hImage parameter is set to the point to the following structure:
//      offset 0: DWORD dwType - currently undefined.
//                HBITMAP hBitmap - hBitmap to display
//
// IMAGERENDERPROC DefaultShedRender
//  Realizes the hPalette and uses StretchBlt to blt the HBITMAP.  The
// hImage function must be of the type described in DefaultShedRead
//
// IMAGERELEASEPROC DefaultShedRelease
//  Frees the GDI objects and the hImage handle, and the hHotInfo handle.
//
//
#ifndef _MVIMG14_INC_
#define _MVIMG14_INC_

#ifndef EXPORT_API
#define EXPORT_API
#endif


#ifdef __cplusplus
extern "C" {
#endif

#if defined(_WIN32) || defined(_MAC)
typedef unsigned char *HPBYTE;
#else
typedef unsigned char __huge *HPBYTE;
#endif


// This is a unique hotspot type for use with MVIMG.
// When this type is specified in the MVHOTSPOTINFO structure,
// the szData field contains a string.
#define HOTSPOT_POLYGON		125

typedef struct
{
	DWORD dwSize;		// will be filled in with size of structure
	HWND  hWnd;
	HDC   hDC;
	LPSTR lpszParams;
	DWORD dwFlags;
	HANDLE hTitle;		// hTitle to retrieve data from.
	LPBYTE lpData;      // either bits from file, or if MVIMAGE_PROCNOREAD
						// flag was set, contains "hotspotfile\timagefile"
						// if there is no hotspot file, "imagefile".
	DWORD  dwDataSize;
	HANDLE FAR *phImage;
	HPALETTE FAR *phPalette;
	LPSIZE lpSize;
} MVIMGREADPARAMS, FAR *LPMVIMGREADPARAMS;

typedef BOOL (CALLBACK *IMAGEREADPROC) (LPMVIMGREADPARAMS lpParams);
typedef BOOL (CALLBACK *IMAGERENDERPROC) (HDC hDC, HANDLE hImage, HPALETTE hPalette, RECT r);
typedef BOOL (CALLBACK *IMAGERELEASEPROC) (HANDLE hImage, HPALETTE hPalette);
typedef LONG (CALLBACK *IMAGEWINDOWPROC) (HANDLE hImage, UINT nMsg, WPARAM wParam, LPARAM lParam);

// relevent flags for MVIMAGEInstallImageProcs:
#define MVIMAGE_PROCDEFAULT  0x00
#define MVIMAGE_PROCNOREAD   0x01
BOOL  EXPORT_API FAR PASCAL MVIMAGEInstallImageProcs (HINSTANCE hInstance, LPSTR lpKey, 
														BYTE bFlags,
														IMAGEREADPROC fprocRead, 
														IMAGERENDERPROC fprocRender, 
														IMAGERELEASEPROC fprocRelease,
														IMAGEWINDOWPROC  fprocWindow);
LPSTR  EXPORT_API FAR PASCAL MVIMAGEGetNextToken (LPSTR lpToken, LPSTR *lpKey, LPSTR *lpValue);
BOOL  EXPORT_API FAR PASCAL MVIMAGEInitialize (HINSTANCE hInstance);
BOOL  EXPORT_API FAR PASCAL MVIMAGESetCacheSize (int nSize);
BOOL  EXPORT_API FAR PASCAL MVIMAGEFlushCache ();
BOOL  EXPORT_API FAR PASCAL MVIMAGETerminate(HINSTANCE hInstance);
// to allow meta files. Not calling this will save space in the static version
BOOL  EXPORT_API FAR PASCAL MVIMAGEInstallMeta ();
BOOL  EXPORT_API FAR PASCAL MVIMAGEUnRLE8 (LPBITMAPINFO binfo, HPBYTE lpBitsSrc, HPBYTE lpBitsDest);
BOOL  EXPORT_API FAR PASCAL MVIMAGEUnRLE4 (LPBITMAPINFO binfo, HPBYTE lpBitsSrc, HPBYTE lpBitsDest);
// add hotspots to the window. lpBuf is pointer to data from .PLY file.
// dwDataSize is the size of the buffer in bytes.
BOOL EXPORT_API FAR PASCAL mvimagePrepareFromPointer (HWND hWnd, LPBYTE lpBuf, DWORD dwDataSize);
#if !defined(_WIN32) && !defined(_MAC)
BOOL FAR PASCAL EXPORT_API MVIMAGEDither(HDC hDC, LPBITMAPINFO lpbi,char FAR *pb);
void PASCAL FAR EXPORT_API MVIMAGEEnableDither(BOOL fDither);
#endif

// backward compatibility, we support both initialize types:
#define MVIMAGEInitiate MVIMAGEInitialize

// default image functions, these are also provided
BOOL EXPORT_API CALLBACK MetaRelease (HANDLE hImage, HPALETTE hPalette);
BOOL EXPORT_API CALLBACK MetaRender (HDC hDC, HANDLE hImage, HPALETTE hPalette, RECT r);
BOOL EXPORT_API CALLBACK MetaRead (LPMVIMGREADPARAMS lpParams);
BOOL EXPORT_API CALLBACK DefaultShedRelease (HANDLE hImage, HPALETTE hPalette);
BOOL EXPORT_API CALLBACK DefaultShedRender (HDC hDC, HANDLE hImage, HPALETTE hPalette, RECT r);
BOOL EXPORT_API CALLBACK DefaultShedRead (LPMVIMGREADPARAMS lpParams);
BOOL EXPORT_API CALLBACK DefaultBitmapRead (LPMVIMGREADPARAMS lpParams);
BOOL EXPORT_API CALLBACK DefaultBitmapRender (HDC hDC, HANDLE hImage, HPALETTE hPalette, RECT r);
BOOL EXPORT_API CALLBACK DefaultBitmapRelease (HANDLE hImage, HPALETTE hPalette);


#define MVIMAGECLASS "MVIMAGE"
#define IDC_HOTCUR   102
// if a string resource of id IDS_MVIMGCLASS exists, that name
// will be used for the window class.  By default, MVIMAGE will be
// used.
#define IDS_MVIMGCLASS  6000

#ifdef __cplusplus
}
#endif

#endif
