#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
*                                                                            *
*  MVEW14.H                                                                  *
*                                                                            *
*  Copyright (C) Microsoft Corporation 1990-1994.                            *
*  All Rights reserved.                                                      *
*                                                                            *
******************************************************************************
*                                                                            *
*  Module Intent                                                             *
*                                                                            *
*  Information regarding MediaView Embedded Window DLL handling.             *
*                                                                            *
*****************************************************************************/

#if defined(__MVEW14_H__)
#error MVEW14.H included more than once.
#else

/*****************************************************************************
* Use the following in window functions supporting embedded windows.         *
*****************************************************************************/

#define EWM_RESERVED1        0x706A
#define EWM_QUERYSIZE        0x706B
#define EWM_ASKPALETTE       0x706C
#define EWM_RENDER           0x706D
#define EWM_PRINT            0x706F
#define EWM_COPY             0x7070
#define EWM_ASKHOTSPOTS      0x7071
#define EWM_ACTIVATE         0x7072
#define EWM_GETHOTINFO		 0x7073
#define EWM_NUMHOT           0x7075
#define EWM_HOTHIGHLIGHT	 0x7074
#define EWM_COPYSPECIAL      0x7076
#define EWM_SETSELECTED      0x7077
#define EWM_GETHIGHLIGHTRECT 0x7078
#define EWM_CLEARHIGHLIGHTS  0x7079

// The wParam to EWM_GETHOTINFO is one of these, or the ordinal number for the
// hotspot desired.
#define  EWHIUSEPOINT  -1
#define  EWHIUSEFOCUS  -2

// The wParam to EWM_HOTHIGHLIGHT is one of these
#define  EWTABLEFT	0
#define  EWTABRIGHT 1
#define  EWSHOWALL  2
#define  EWSHOWNONE 3

// This can be used as wParam to EWM_COPYSPECIAL to copy all types
#define CF_ALL	    0

// EWM_SETSELECTED - wParam==TRUE for selected, LPARAM is colorref.

#pragma pack(1)
// Structure pointed to by the parameter, lParam, passed to the
// window procedure controlling the embedded window upon receiving
// the EWM_PRINT, EWM_RENDER and EWM_COPY messages.

typedef struct tagRenderInfo 
{
  RECT  rc;
  HDC   hdc;
} RENDERINFO, FAR * QRI, FAR *LPRENDERINFO;

// EWM_RENDER:
// if wParam==1. should return 1 to indicate that the data was drawn and that
// the EW need not be made visible. Called before window shown.
// if wParam==0. Return value not used. Called after window shown.

//The return value from EWM_PRINT is not used.


// EWM_GETHIGHLIGHTRECT wParam=ID returned by GetEmbeddedWindowSearchableText
//							for the highlight we want RECT for.
// 						lParam= LPRECT. Must be filled in.
//						When called, EW is responsible for highlighting
//						that id.

// EWM_CLEARHIGHLIGHTS  no parameters. Must clear paramters.

// Callback type needed for mac so it will pass parameters.
typedef void (CALLBACK* MVCBPROC)();

// Structure passed to the window proceedure controlling the embedded
// window upon its creation.  This structure is pointed to by the
// lpCreateParams field of the structure, CREATESTRUCT, pointed to
// by the parameter, lParam, passed to the WM_CREATE message of the
// window proceedure controlling the embedded window.

typedef struct tagCreateInfo {
  short    idMajVersion;          // For MediaView, this field is set to 0.
  short    idMinVersion;          // For MediaView, this field is set to 2.
  LPSTR    szFileName;            // Current MediaView file
  LPSTR    szAuthorData;          // Text passed by the author
  HANDLE   hfs;                   // Handle to the current file system, may be NULL, use hTitle
  DWORD    coFore;                // Foreground color for this topic
  DWORD    coBack;                // Background color for this topic
  DWORD    dwFlags;               // Information flags (see below)
  MVCBPROC lpfnHotspotCallback;   // Hotspot Callback Function (kept for backward compat.)
  LPVOID   lpHotspotCallbackData; // Hotspot Callback Data
  HANDLE   hTitle;                // handle to the HTITLE used to read from baggage
} EWDATA, FAR *QEWDATA, FAR *LPEWDATA;

#pragma pack()

// Values set in the EWDATA structure's dwFlags field giving
// information about the embedded window being created.

#define EWF_PRINT 0x00000001     // Embedded window is for printing
#define EWF_COPY  0x00000002     // Embedded window is for copying

/*****************************************************************************
* End of section regarding window functions supporting embedded windows.     *
*****************************************************************************/

#endif     /* !defined(__MVEW14_H__) */

#ifdef __cplusplus
}
#endif
