#ifdef __cplusplus
extern "C" {
#endif

/****************************************************************************\
*                                                                            *
*  MVERROR.H                                                                 *
*                                                                            *
*  Copyright (C) Microsoft Corporation 1993 - 1994.                          *
*  All Rights reserved.                                                      *
*                                                                            *
******************************************************************************
*                                                                            *
*  Module Intent:                                                            *
*   Defines constants used as error codes.                                   *
*                                                                            *
\****************************************************************************/

typedef WORD ERR, FAR *LPERR;

/*************************************************************************
 *                       Error management.
 *************************************************************************/


/******************************************
 * Error structure. For internal use only
 ******************************************/

#ifndef ERRB_DEFINED
#define ERRB_DEFINED

typedef struct {
	int  err;                // Error code.
	int  iUser;              // Whatever you want.
	int  cLine;              // Source line at which the failure took place.
	char FAR *aszFile;       // Source file that caught an error.
} ERRB, FAR *LPERRB;

int EXPORT_API PASCAL FAR SetErr (LPERRB lperrb, int ErrCode, int iUserCode);

int EXPORT_API PASCAL FAR DebugSetErr (LPERRB lperrb, int ErrCode,
	int Line, char FAR *module, int iUserCode);

#if defined(_DEBUG) || defined(DEBUG)
#define	SetErrCode(a,b)	DebugSetErr(a, b, __LINE__, s_aszModule, 0)
#else
#define	SetErrCode(a,b)	SetErr(a, b, 0)
#endif

#endif // ERRB_DEFINED

/* End of internal usage */

// MAX size of an error string in the resource file.
#define MAX_ERROR_MSG 256

/************************************
*  Error Constants
*************************************/

/* General errors */
#ifndef SUCCEED	// already defined in sqlfront.h, used by mos
#define SUCCEED                     0
#endif

#define wERRS_NONE                  0
#define wERRS_OOM                1001   // Out Of Memory
#define wERRS_OODC               1002   // Out of Display Contexts
#define wERRS_NOTITLE            1003
#define wERRS_FNF                1004   // File Not Found
#define wERRS_NOTOPIC            1005
#define wERRS_BADPRINT           1006
#define wERRS_BADFILE            1007
#define wERRS_OLDFILE            1008
#define wERRS_DiskFull           1009
#define wERRS_FSReadWrite        1010
#define wERRS_FCEndOfTopic       1011
#define wERRS_BADPARAM           1012
#define wERRS_NOFONTCHANGE       1013
#define wERRS_NOMOREHOTSPOTS     1014
#define wERRS_BADEWWINCLASS      1015
#define wERRS_PARTIAL            1016
#define wERRS_NOADDRESS          1017
#define wERRS_NORECTANGLE        1018
#define wERRS_NOVSCROLL          1019   // No Vertical Scrollbar
#define wERRS_NOHSCROLL          1020   // No Horizontal Scrollbar
#define wERRS_CANTFINDDLL        1021
#define wERRS_CANTUSEDLL         1022
#define wERRS_EWOOM              1023   // Embedded Window Out Of Memory
#define wERRS_DEBUGMISMATCH      1024
#define wERRS_BADPOLYGON         1025   // less than 3 pts or none passed
#define wERRS_BADEWCALLBACK      1026
#define wERRS_OLDFONTTABLE       1027
#define wERRS_NOSUCHSTYLE        1028
#define wERRS_GROUPIDTOOBIG      1029
#define wERRS_NOMOREHIGHLIGHTS	 1030
#define wERRS_NOSELECTION        1031
#define wERRS_KEYSELECTFAILED    1032   // may need to scroll MV to work.
#define wERRS_NOTSCROLLED		 1033
#define wERRS_NOINDEXLOADED		 1034   // search index not loaded
#define wERRS_EWCREATEFAILED     1035   // CreateWindow failed.
#define wERRS_NOWINDOW	         1036   // Window not set in LPMV
#define wERRS_OUTOFRANGE         1037
#define wERRS_NOTHINGTOCOPY      1038
#define wERRS_NOTFOUND           1039
#define wERRS_NOTSUPPORTED       1040
#define wERRS_RECURSION	         1041   // function is currently executing.

#define ERR_SUCCESS				 0


#define ERR_INTERNAL_BASE      2000
#define ERR_INTERNAL_MAX       (ERR_INTERNAL_BASE + 32)

#define ERR_GRAMMAR_BASE       2200
#define ERR_GRAMMAR_MAX        (ERR_GRAMMAR_BASE + 50)

//#define ERR_LOADLIBRARY_BASE   2400
//#define ERR_LOADLIBRARY_MAX    (ERR_LOADLIBRARY_BASE + 32)

//#define ERR_DOS_BASE           2600
//#define ERR_DOS_MAX            (ERR_DOS_BASE + 256)


#define ERR_FAILED                      (ERR_INTERNAL_BASE + 1)
#define ERR_IDXINTERRUPT                (ERR_INTERNAL_BASE + 2)
#define ERR_NEARMEMORY                  (ERR_INTERNAL_BASE + 3)
#define ERR_MEMORY                      (ERR_INTERNAL_BASE + 4)
#define ERR_DISKFULL                    (ERR_INTERNAL_BASE + 5)
#define ERR_WORDTOOLONG                 (ERR_INTERNAL_BASE + 6)
#define ERR_BADVERSION                  (ERR_INTERNAL_BASE + 7)
#define ERR_TOOMANYDOCS                 (ERR_INTERNAL_BASE + 8)
#define ERR_TOOMANYSTOPS                (ERR_INTERNAL_BASE + 9)
#define ERR_TOOLONGSTOPS                (ERR_INTERNAL_BASE + 10)
#define ERR_STEMTOOLONG                 (ERR_INTERNAL_BASE + 11)
#define ERR_TREETOOBIG                  (ERR_INTERNAL_BASE + 12)
#define ERR_CANTREAD                    (ERR_INTERNAL_BASE + 13)
#define ERR_IDXSEGOVERFLOW              (ERR_INTERNAL_BASE + 14)
#define ERR_BADARG                      (ERR_INTERNAL_BASE + 15)
#define ERR_VOCABTOOLARGE               (ERR_INTERNAL_BASE + 16)
#define ERR_GROUPIDTOOBIG               (ERR_INTERNAL_BASE + 17)
#define ERR_BADOPERATOR                 (ERR_INTERNAL_BASE + 18)
#define ERR_TERMTOOCOMPLEX              (ERR_INTERNAL_BASE + 19)
#define ERR_SEARCHTOOCOMPLEX            (ERR_INTERNAL_BASE + 20)
#define ERR_BADSYSCONFIG                (ERR_INTERNAL_BASE + 21)
#define ERR_ASSERT                      (ERR_INTERNAL_BASE + 22)
#define ERR_FILE_NOT_EXIST              (ERR_INTERNAL_BASE + 23)
#define ERR_INVALID_FS_FILE             (ERR_INTERNAL_BASE + 24)
#define ERR_OUT_OF_RANGE                (ERR_INTERNAL_BASE + 25)
#define ERR_SEEK_FAILED                 (ERR_INTERNAL_BASE + 26)
#define ERR_FILECREAT_FAILED            (ERR_INTERNAL_BASE + 27)
#define ERR_CANTWRITE                   (ERR_INTERNAL_BASE + 28)
#define ERR_NOHANDLE                    (ERR_INTERNAL_BASE + 29)
#define ERR_EXIST                       (ERR_INTERNAL_BASE + 30)
#define ERR_INVALID_HANDLE              (ERR_INTERNAL_BASE + 31)
#define ERR_BADFILEFORMAT               (ERR_INTERNAL_BASE + 32)

#define ERR_NULLQUERY                   (ERR_GRAMMAR_BASE + 0)
#define ERR_EXPECTEDTERM                (ERR_GRAMMAR_BASE + 1)
#define ERR_EXTRACHARS                  (ERR_GRAMMAR_BASE + 2)
#define ERR_MISSQUOTE                   (ERR_GRAMMAR_BASE + 3)
#define ERR_MISSLPAREN                  (ERR_GRAMMAR_BASE + 4)
#define ERR_MISSRPAREN                  (ERR_GRAMMAR_BASE + 5)
#define ERR_TOODEEP                     (ERR_GRAMMAR_BASE + 6)
#define ERR_TOOMANYTOKENS               (ERR_GRAMMAR_BASE + 7)
#define ERR_BADFORMAT                   (ERR_GRAMMAR_BASE + 8)
#define ERR_BADVALUE                    (ERR_GRAMMAR_BASE + 9)
#define ERR_UNMATCHEDTYPE               (ERR_GRAMMAR_BASE + 10)
#define ERR_BADBREAKER                  (ERR_GRAMMAR_BASE + 11)
#define ERR_BADRANGEOP                  (ERR_GRAMMAR_BASE + 12)
#define ERR_ALL_WILD                    (ERR_GRAMMAR_BASE + 13)
#define ERR_NON_LAST_WILD               (ERR_GRAMMAR_BASE + 14)
#define ERR_WILD_IN_DTYPE               (ERR_GRAMMAR_BASE + 15)

#ifdef __cplusplus
}
#endif
