#ifdef __cplusplus
extern "C" {
#endif

#ifndef MEDV14_H
#define MEDV14_H

#ifndef EXPORT_API
#define EXPORT_API
#endif

/************************************************************************
*
* MEDV14.H
*
* Copyright (c) Microsoft Corporation 1993 -1994
* All rights reserved.
*
*************************************************************************
*
* Module intent: Header file for the MEDV14.DLL.
*
************************************************************************/

#include <mverror.h>

// all structures we define are on 4 byte boundaries
#pragma pack(4)

#ifndef MV_DEFINED
typedef VOID FAR *LPMV;
#endif

#ifndef VA_DEFINED
#define VA_DEFINED
typedef DWORD VA, FAR *QVA;
#define vaNil ((DWORD)-1)
#endif // VA_DEFINED

#define addrNil ((ADDR)-1)
typedef LONG  ADDR;
typedef DWORD  HASH;

typedef HANDLE HTHLITE;   // Handle to TOPIC Highlights.
typedef HANDLE HGHLITE;   // Handle to Search Highlights (Global Highlights)
typedef HANDLE HFNTTABLE; // Handle to font table
typedef HANDLE HMVFILE;   // Handle to BaggageFile.
typedef HANDLE HMVCOPY;   // Handle to MVCOPYDATA


typedef struct tagSELECTION
{
  VA vaStartSelection;
  long lichStartSelection;
  VA vaEndSelection;
  long lichEndSelection;
} SELECTION, FAR *LPSELECTION;

typedef struct tagMVCOPYPAIR
{
  int	cfType;   // clipboard type
  HANDLE hShared; // shared handle to be copied to the clipboard
} MVCOPYPAIR, FAR *LPMVCOPYPAIR;

typedef struct tagMVCOPYDATA
{
  int	nNumHandles;  // Number of C
  MVCOPYPAIR aCopyPairs[1];  // handles to copy.
} MVCOPYDATA, FAR *LPMVCOPYDATA;


typedef void (CALLBACK* MVCBPROC)();
// background proc, for baggage.
typedef void (CALLBACK* MVBGPROC)(DWORD);
typedef HDC  (CALLBACK* MVDCPROC)(HWND);
typedef void (CALLBACK* MVDCRELPROC)(HWND,HDC);
typedef BOOL (CALLBACK* MVPAGECB)(LONG,HDC,RECT,LPRECT,BOOL);
typedef LPVOID MVGROUP;

// constants for keyboard selection
#define MVKEY_NONE  1
#define MVKEY_UP    2
#define MVKEY_DOWN  3
#define MVKEY_LEFT  4
#define MVKEY_RIGHT 5
#define MVKEY_START 6
#define MVKEY_END   7

#define MVSEL_CHAR      1
#define MVSEL_WORD      2
#define MVSEL_SENTENCE  3
#define MVSEL_PARAGRAPH 4
#define MVSEL_ALL       5


#ifndef CONTENTTYPE_DEFINED
#define CONTENTTYPE_DEFINED
enum CONTENTTYPE
{
  CONTENT_TEXT,
  CONTENT_BITMAP,
  CONTENT_WINDOW,
  CONTENT_UNKNOWN
};
#endif // CONTENTTYPE_DEFINED


#define HOTSPOT_STRING    0
#define HOTSPOT_HASH      1
#define HOTSPOT_POPUPHASH 2
#define HOTSPOT_UNKNOWN   3

// constant for hMVCopyAdvanced
#define CF_ALL	 0


typedef HANDLE HTITLE;    // Handle to a Title
typedef HANDLE HTLIST;    // handle to a Topic List
typedef HANDLE HWHEEL;    // Handle to a wordwheel
typedef LPVOID MVSTATUS;  // Status for background baggage

typedef struct tagQUERYERR
{
  int iError;
  int iStart;
  int iLength;
} QUERYERR, FAR * LPQUERYERR;
  
// Different flags for hMVTopicListFromQuery
#define IMPLICIT_AND    0
#define IMPLICIT_OR     1

#define QUERYRESULT_RANK    0x0100 // Ranked the result. If not highest hit 1st
#define QUERYRESULT_UNSORTED    0x0200 // Result topics are 1st in 1st out
#define QUERYRESULT_IN_MEM  0x0400 // Result should be kept in memory
#define QUERYRESULT_GROUPCREATE   0x0800 // Create a group from the hitlist



#define TL_AND  0
#define TL_OR   1
#define TL_NOT  2


#define fSMALLCAPS     0x0004
#define fNOUNDERLINE   0x0008
#define fDOTUNDERLINE  0x0010
#define fWORDUNDERLINE 0x0020
#define fDBLUNDERLINE  0x0040

/* This leading byte to signal the following font number */
#define EMBEDFONT_BYTE_TAG				3
#define STYLESIZE      64
  

// constants for lMVTitleGetInfo
#define TTLINF_TITLE           1
#define TTLINF_COPYRIGHT       2
#define TTLINF_CONTENTS        3
#define TTLINF_CITATION       10
#define TTLINF_NUMTOPICS      11
#define TTLINF_GROUPS		  13
#define TTLINF_KEYINDEX		  14
#define TTLINF_LANGUAGE       18
#define TTLINF_HASINDEX      100
#define TTLINF_TOPICADDR     101
#define TTLINF_TOPICTITLE    102
#define TTLINF_FILESYS       105
#define TTLINF_FILENAME      106
#define TTLINF_ADDRTITLE     110
#define TTLINF_FONTTABLE     111


// define FILETIME for Win16
#if !defined(_WIN32) && !defined(_FILETIME_)
#define _FILETIME_
typedef struct _FILETIME 
{
    DWORD dwLowDateTime;
    DWORD dwHighDateTime;
} FILETIME, *PFILETIME, FAR *LPFILETIME;

#endif

//
// point and hotspot information structures.
#ifndef __FRINFO__
#define __FRINFO__
                
#define MVPOINT_HOT		1
#define MVPOINT_SELECT		2
#define MVPOINT_TEXT		4
#define MVPOINT_WINDOW	8

#define fMVPOINT_ISHOT(lpmvpi)	((lpmvpi)->dwAttr & MVPOINT_HOT)
#define fMVPOINT_ISSELECTED(lpmvpi)	((lpmvpi)->dwAttr & MVPOINT_SELECT)
#define fMVPOINT_ISTEXT(lpmvpi)	((lpmvpi)->dwAttr & MVPOINT_TEXT)
#define fMVPOINT_ISWINDOW(lpmvpi)	((lpmvpi)->dwAttr & MVPOINT_WINDOW)

typedef struct tagMVPOINTINFO
{
	DWORD	dwSize;		    // size of structure.
	DWORD dwAttr;	        // MVPOINT_ attributes.
	enum CONTENTTYPE  ct;   // bitmap,window or text (duplicates some of attributes information)
	int 	nCharStyle;	    // character style (for text only)
	VA	    va;		        // VA of point we are in.
	long	lch;		    // character offset point is in.
	HWND 	hwnd;		    // HWND of embedded window. (if fMVPOINT_ISWINDOW)
} MVPOINTINFO, FAR *LPMVPOINTINFO;


typedef struct tagMVHOTINFO
{
	DWORD	dwSize;		// size of structure.
	union
	{
	POINT    pt;		// For embedded window use only. Set by MV when passed to an EW.
						// (This will be set for the EWM_GETHOTINFO message to the point
						//  to check when wParam is EWHIUSEPOINT)
	RECT    r;		    // Rectangle of the hotspot. This is filled by MV on return.
	};
	DWORD   hash;		// hash value for other HOTTYPEs. Set on return if nType
						// is HOTSPOT_HASH or HOTSPOT_HASHPOPUP
	DWORD	dwBufSize;	// size of the lpBuffer parameter. Set on entry.
	DWORD	dwSizeNeeded; // set to the necessary buffer size by MV.
						// on return, check if dwSizeNeeded <= dwBufSize to determine
						// if lpBuffer was filled.
	LPBYTE	lpBuffer;	// Set on entry, filled on return if dwBufSize is >= dwSizeNeeded;
						// this will contain string data for HOTSPOT_STRING, or
						// Embedded Window defined data. (ie. HOTSPOT_POLYGON, see MVIMG14.H)
	int		nType;		// Hotspot Type.  Filled on return.
} MVHOTINFO, FAR *LPMVHOTINFO;

#endif

#pragma pack()

VOID   EXPORT_API FAR PASCAL MVTerminate(HINSTANCE hInst);
VOID   EXPORT_API FAR PASCAL MVSetInstance(HINSTANCE hInst);
VOID   EXPORT_API FAR PASCAL MVSetDCObtainer(LPMV lpMv, MVDCPROC lpfnGETDC);
VOID   EXPORT_API FAR PASCAL MVSetDCReleaser(LPMV lpMv, MVDCRELPROC lpfnRELEASEDC);
LPMV   EXPORT_API FAR PASCAL lpMVNew(HTITLE hTitle, LPERR lpErr);
LPMV   EXPORT_API FAR PASCAL lpMVDuplicate(LPMV lpMv, LPERR lpErr);
VOID   EXPORT_API FAR PASCAL MVDelete(LPMV lpMv);
BOOL   EXPORT_API FAR PASCAL fMVApplyToDC(LPMV lpMv, HDC hDC, LPRECT lpr, LPERR lpErr);
BOOL   EXPORT_API FAR PASCAL fMVSetWindow(LPMV lpMv, HWND hWnd, LPERR lpErr);
ERR	   EXPORT_API FAR PASCAL MVSetEWMapping(LPMV lpMv, const LPCSTR FAR* lpClassMap, const LPCSTR FAR* lpDLLMap);
COLORREF EXPORT_API FAR PASCAL MVSetBkColor(LPMV lpMv, COLORREF clr);
COLORREF EXPORT_API FAR PASCAL MVSetTextColor(LPMV lpMv, COLORREF clr);
HWND   EXPORT_API FAR PASCAL hwndMVGetWindow(LPMV lpMv);
VOID   EXPORT_API FAR PASCAL MVSetKerningBoundary(LPMV lpMv, int iBound);
int    EXPORT_API FAR PASCAL iMVGetKerningBoundary(LPMV lpMv);
HWND   EXPORT_API FAR PASCAL hwndMVGetEmbeddedWindow(LPMV lpMv, HWND hWnd, WORD nIndex);
POINT  EXPORT_API FAR PASCAL ptMVGetSize(LPMV lpMv);
POINT  EXPORT_API FAR PASCAL ptMVEstimateSize(LPMV lpMv);
BOOL   EXPORT_API FAR PASCAL fMVSetTitle(LPMV lpMv, HTITLE hTitle, LPCSTR lpszFile, LPERR lpErr);
HTITLE EXPORT_API FAR PASCAL hMVGetTitle(LPMV lpMv, LPSTR lpszFile);
BOOL   EXPORT_API FAR PASCAL fMVHasNSR(LPMV lpMv);
BOOL   EXPORT_API FAR PASCAL fMVHasSR(LPMV lpMv);
LONG   EXPORT_API FAR PASCAL lMVTopicNumber(LPMV lpMv);
ADDR   EXPORT_API FAR PASCAL addrMVGetNext(LPMV lpMv);
ADDR   EXPORT_API FAR PASCAL addrMVGetPrev(LPMV lpMv);
BOOL   EXPORT_API FAR PASCAL fMVSetAddress(LPMV lpMv, VA va, int iSub, LONG lScroll, LPERR lpErr);
VOID   EXPORT_API FAR PASCAL MVGetAddress(LPMV lpMv, QVA lpva, LPINT lpiSub, LPLONG lplScroll);
BOOL   EXPORT_API FAR PASCAL fMVScrollToAddr (LPMV lpMv, ADDR addr, LPERR lpErr);
BOOL   EXPORT_API FAR PASCAL fMVRealize(LPMV lpMv, LPRECT lpr, LPERR lpErr);
VOID   EXPORT_API FAR PASCAL MVUnrealize(LPMV lpMv);
BOOL   EXPORT_API FAR PASCAL fMVPrintMedia(LPMV lpMv, HDC hDC, BOOL fSelect, LPRECT lprPage, 
												LPRECT lprStart, LPINT lpiXScroll,
                                                MVPAGECB lpfnPage, LONG lpPageData, LPERR lpErr);
BOOL   EXPORT_API FAR PASCAL fMVHighlightHotspots(LPMV lpMv, BOOL fHighlight, LPERR lpErr);
BOOL   EXPORT_API FAR PASCAL fMVSetHotspotCallback(LPMV lpMv, MVCBPROC lpfnCB, LPVOID lpData, LPERR lpErr);
BOOL   EXPORT_API FAR PASCAL fMVGetHotspotCallback(LPMV lpMv, MVCBPROC FAR * lplpfnCB,
                                                LPVOID FAR *lplpData, LPERR lpErr);
VOID   EXPORT_API FAR PASCAL MVHidePartialLines(LPMV lpMv, BOOL fHidePartial);
POINT  EXPORT_API FAR PASCAL ptMVGetScrollSizes(LPMV lpMv);
int    EXPORT_API FAR PASCAL yMVScrollY(LPMV lpMv,
                               LPPOINT lpptScroll, LPINT lpiTop, LPINT lpiBottom, 
                               WORD nSBCmd, WORD nPos, LPERR lpErr);
int    EXPORT_API FAR PASCAL yMVGetYScrollPos(LPMV lpMv);
int    EXPORT_API FAR PASCAL xMVScrollX(LPMV lpMv, LPPOINT lpptScroll, 
								WORD nSBCmd, WORD nPos, LPERR lpErr);
int    EXPORT_API FAR PASCAL xMVGetXScrollPos(LPMV lpMv);
BOOL   EXPORT_API FAR PASCAL fMVSetMagnifier(LPMV lpMv, int iPercent, LPERR lpErr);
int    EXPORT_API FAR PASCAL iMVGetMagnifier(LPMV lpMv);
HANDLE EXPORT_API FAR PASCAL hMVGetData(LPMV lpMv);
HANDLE EXPORT_API FAR PASCAL hMVGetName(LPMV lpMv);

//
// highlighting functions
//
HBRUSH  EXPORT_API FAR PASCAL hMVSetHighlightLook(LPMV lpMv, HBRUSH hbr, int iROP, LPERR lpErr);
HTHLITE EXPORT_API FAR PASCAL hMVSetHighlights(LPMV lpMv, HTHLITE hTH, BOOL fUpdate, LPERR lpErr);
HTHLITE EXPORT_API FAR PASCAL hMVGetHighlights(LPMV lpMv);
BOOL    EXPORT_API FAR PASCAL fMVGetHighlightRect(LPMV lpMv, int iIndex, LPRECT lpr);
BOOL    EXPORT_API FAR PASCAL fMVScrollToHighlight (LPMV lpMv, int iIndex, LPERR lpErr);
ADDR    EXPORT_API FAR PASCAL addrMVTopicHighlightAddress (HTHLITE hTH, int iIndex);
LONG    EXPORT_API FAR PASCAL lMVTopicHighlightCount (HTHLITE hTH);



//
// functions for hotspots and POINT information.
//
BOOL   EXPORT_API FAR PASCAL fMVGetPointInfo(LPMV lpMv, POINT pt, LPMVPOINTINFO lpPI, 
														LPMVHOTINFO lpHI, LPERR lpErr);
BOOL   EXPORT_API FAR PASCAL fMVMoveFocus(LPMV lpMv, BOOL fNext, LPERR lpErr);
BOOL   EXPORT_API FAR PASCAL fMVFocusInfo(LPMV lpMv, LPMVHOTINFO lpHI, LPERR lpErr);
BOOL   EXPORT_API FAR PASCAL fMVGetHotspotInfo (LPMV lpMv, LONG lIndex, LPMVHOTINFO lpHI, LPERR lpErr);
LONG   EXPORT_API FAR PASCAL lMVGetHotspotCount(LPMV lpMv, LPERR lpErr);
/* char can be 'L' 'R' or 'C'.  Currently only 'C' is supported */
UINT   EXPORT_API FAR PASCAL nMVInsertEmbeddedWindow (LPMV lpMv, VA va, LONG lOffset, char ch, 
												LPSTR lpszCmd, LPERR lpErr);
VOID   EXPORT_API FAR PASCAL MVRemoveInsertedEmbeddedWindows (LPMV lpMv);
BOOL   EXPORT_API FAR PASCAL fMVShowInsertedEW(LPMV lpMv, UINT nId, BOOL fShow);

//
// Arbitrary Selection Funcitons
//
VOID   EXPORT_API FAR PASCAL MVSelectPoint(LPMV lpMv, short nType, POINT pt, BOOL fExtend, LPERR lpErr);
VOID   EXPORT_API FAR PASCAL MVSelectKey(LPMV lpMv, short nType, BOOL fExtend, LPERR lpErr);
VOID   EXPORT_API FAR PASCAL MVGetSelectionPoints(LPMV lpMv, LPRECT lprStart, LPRECT lprEnd);
BOOL   EXPORT_API FAR PASCAL fMVClearSelection(LPMV lpMv, LPERR lpErr);
BOOL   EXPORT_API FAR PASCAL fMVIsSelected(LPMV lpMv);
VOID   EXPORT_API FAR PASCAL MVSetSelection(LPMV lpMv, SELECTION sel);
BOOL   EXPORT_API FAR PASCAL fMVGetSelection(LPMV lpMv, LPSELECTION lpsel);
BOOL   EXPORT_API FAR PASCAL fMVAllowEWSelection (LPMV lpMv, BOOL fSelect);
VOID   EXPORT_API FAR PASCAL MVSetSelectionColor (LPMV lpMv, BOOL fUseColor, COLORREF clrFore, COLORREF clrBack);

// functions for copying media
HMVCOPY EXPORT_API FAR PASCAL hMVCopyAdvanced(LPMV lpMv, BOOL fSelection, int cfType, LPERR lpErr);
HANDLE  EXPORT_API FAR PASCAL hMVCopyMedia(LPMV lpMv, LPERR lpErr);
HANDLE  EXPORT_API FAR PASCAL hMVCopySelection(LPMV lpMv, LPERR lpErr);

VOID   EXPORT_API FAR PASCAL MVActivate(LPMV lpMv, BOOL fActive);

// functions for font tables
HFNTTABLE EXPORT_API FAR PASCAL hMVSetFontTable(LPMV lpMv, HFNTTABLE hFT);
HFNTTABLE EXPORT_API FAR PASCAL hMVGetFontTable(LPMV lpMv);

LONG   EXPORT_API FAR PASCAL lMVFontTableSize(HFNTTABLE hFT, LPERR lpErr);
int    EXPORT_API FAR PASCAL iMVCharStyleCount(HFNTTABLE hFT, LPERR lpErr);

BOOL EXPORT_API FAR PASCAL fMVGetCharStyle(HFNTTABLE hFT, LPINT lpiStyle,
                                             LPSTR lpszFace, LPLOGFONT lpLF, 
                                             RGBTRIPLE FAR *lpRGBFore, RGBTRIPLE FAR *lpRGBBack,
                                             LPINT lpiSubSuper, LPBYTE lpAttr, LPERR lpErr);

BOOL EXPORT_API FAR PASCAL fMVSetCharStyle(HFNTTABLE hFT, int iStyle,
                                             LPSTR lpszFace, LPLOGFONT lpLF,
                                             RGBTRIPLE FAR *lpRGBFore, RGBTRIPLE FAR *lpRGBBack,
                                             LPINT lpiSubSuper, LPBYTE lpAttr, LPERR lpErr);


//
// Title Functions
//
HTITLE FAR PASCAL EXPORT_API hMVTitleOpen(LPCSTR lpszFile);
HTITLE FAR PASCAL EXPORT_API hMVTitleOpenEx(LPCSTR lpszFile, FARPROC fSearchProc, LPVOID lpSearchParam);
VOID   FAR PASCAL EXPORT_API MVTitleClose(HTITLE hTitle);


ADDR   FAR PASCAL EXPORT_API addrMVConvertHash(HTITLE hTitle, HASH hash);
ADDR   FAR PASCAL EXPORT_API addrMVConvertTopicNumber(HTITLE hTitle, LONG lTopicNo);
ADDR   FAR PASCAL EXPORT_API addrMVConvertContextString(HTITLE hTitle, LPCSTR lpszContext);
ADDR   FAR PASCAL EXPORT_API addrMVGetContents(HTITLE hTitle);
VA     FAR PASCAL EXPORT_API vaMVConvertAddr(HTITLE hTitle, ADDR addr);
VA     FAR PASCAL EXPORT_API vaMVConvertHash(HTITLE hTitle, HASH hash);
VA     FAR PASCAL EXPORT_API vaMVConvertTopicNumber(HTITLE hTitle, LONG lTopicNo);
VA     FAR PASCAL EXPORT_API vaMVConvertContextString(HTITLE hTitle, LPCSTR lpszContext);
VA     FAR PASCAL EXPORT_API vaMVGetContents(HTITLE hTitle);

// use the following to manage topic lists
HTLIST FAR PASCAL EXPORT_API hMVTopicListLoad(HTITLE hTitle, LPCSTR lpszTLName);
HTLIST FAR PASCAL EXPORT_API hMVTopicListFromQuery(HTITLE hTitle, WORD wFlags, LPCSTR lpszQuery,
                                             HTLIST hTLLimit, WORD wNear,
                                             HGHLITE FAR *lphGH, LPQUERYERR lpQerr);
HTLIST FAR PASCAL EXPORT_API hMVTopicListFromTopicNo(HTITLE hTitle, LONG lTopicNo);
VOID   FAR PASCAL EXPORT_API MVTopicListDestroy(HTLIST hTL);
LONG   FAR PASCAL EXPORT_API lMVTopicListLength(HTLIST hTL);
LONG   FAR PASCAL EXPORT_API lMVTopicListLookup(HTLIST hTL, LONG lNum);
HTLIST FAR PASCAL EXPORT_API hMVTopicListCombine(int nOper,HTLIST hTL1,HTLIST hTL2);
// The MVGroup returned must be freed using MVGroupFree
MVGROUP EXPORT_API FAR PASCAL MVTopicListGroupGet(HTLIST hTL,LPERR lpErr);
// create an empty topic list.
HTLIST FAR PASCAL EXPORT_API hMVTopicListCreate (LPERR lpErr);
// Set the group into the topic list.
ERR    FAR PASCAL EXPORT_API nMVTopicListGroupSet (HTLIST hTL, MVGROUP mvgroup);


HTHLITE FAR PASCAL EXPORT_API hMVHighlightsInTopic(HGHLITE hGH, LONG lTopicNo);
// this takes a handle to the SearchHighlights
ADDR FAR PASCAL EXPORT_API addrMVSearchHighlight(HGHLITE hGH, LONG lIndex, LONG lHighlight);
LONG FAR PASCAL EXPORT_API lMVSearchHighlightCount(HGHLITE hGH, long lIndex);


//  Use the following for access to the Word Wheel API.
MVGROUP FAR PASCAL EXPORT_API MVWordWheelSearch(HWHEEL hWW, WORD wFlags, LPCSTR lpszQuery, LPERR lpErr);
HWHEEL FAR PASCAL EXPORT_API hMVWordWheelOpenTitle(HTITLE hTitle, LPCSTR lpszWWName);
VOID   FAR PASCAL EXPORT_API MVWordWheelClose(HWHEEL hWW);
LONG   FAR PASCAL EXPORT_API lMVWordWheelLength(HWHEEL hWW);
LONG   FAR PASCAL EXPORT_API lMVWordWheelPrefix(HWHEEL hWW, LPCSTR lpszPrefix);
ERR    FAR PASCAL EXPORT_API nMVWordWheelLookup(HWHEEL hWW, LONG lIndex, LPBYTE lpKeyBuf,int iBufLen);
LONG   FAR PASCAL EXPORT_API lMVKeyIndexGetAddrs(HWHEEL hWW,LPBYTE lpKey,int nStart,int nCount,LPBYTE lpAddrs);
WORD   FAR PASCAL EXPORT_API nMVKeyIndexGetCount(HWHEEL hWW,LPBYTE lpKey);

// determine other information about a title:
LONG   FAR PASCAL EXPORT_API lMVTitleGetInfo(HTITLE hTitle, int iType, LONG l1, LONG l2);
BOOL   FAR PASCAL EXPORT_API fMVTitleValid(HTITLE hTitle);

// Baggage File Access
VOID EXPORT_API FAR PASCAL MVBaggageClose (HMVFILE hFile, LPERR lpErr);
LONG EXPORT_API FAR PASCAL lMVBaggageSeek (HMVFILE hFile, LONG lOffset,
	int nOrigin, LPERR lpErr);
LONG EXPORT_API FAR PASCAL lMVBaggageRead (HMVFILE hFile, LPBYTE lpBuf,
	DWORD dwBytes, LPERR lpErr);
LONG EXPORT_API FAR PASCAL lMVBaggageSize (HMVFILE hFile, LPERR lpErr);
HMVFILE EXPORT_API FAR PASCAL hMVBaggageOpen (HTITLE hTitle,
	LPCSTR lpszFilename, BOOL fBaggage, LPERR lpErr);
LONG EXPORT_API FAR PASCAL lMVBaggageSeekRead (HMVFILE hFile, LONG lOffset,
	int nOrigin,  LPBYTE lpBuf, DWORD dwBytes, LPERR lpErr);

MVSTATUS EXPORT_API FAR PASCAL MVBaggageAsyncGetFile (HTITLE h, 
								MVBGPROC lpfn, DWORD dwUser, 
								DWORD dwStart, DWORD dwBlock,
								LPCSTR lpszFilename, BOOL fBaggage,
								LONG lOffset, DWORD dwBytes, LPERR lpErr);
ERR FAR PASCAL EXPORT_API MVBaggageAsyncStatus (MVSTATUS lp, long FAR * pRead, long FAR *pTotal, LPBYTE FAR *ppData);
ERR FAR PASCAL EXPORT_API MVBaggageAsyncClose (MVSTATUS lp);
ERR FAR PASCAL EXPORT_API MVBaggageAsyncState (MVSTATUS h, BOOL f);

// Returns handle to the data in the given baggage file.
HANDLE EXPORT_API FAR PASCAL hMVBaggageGetFile (HTITLE hTitle,
	LPCSTR lpszFilename, BOOL fBaggage, LONG lOffset, DWORD dwBytes,
	DWORD FAR *lpdwRead, LPERR lpErr);


// group APIs
ERR EXPORT_API FAR PASCAL nMVGroupAddItem(MVGROUP mvGroup, DWORD dwItem);
MVGROUP EXPORT_API FAR PASCAL MVGroupAnd(MVGROUP mvGroup1, MVGROUP mvGroup2, LPERR lpErr);
MVGROUP EXPORT_API FAR PASCAL MVGroupOr(MVGROUP mvGroup1, MVGROUP mvGroup2, LPERR lpErr);
MVGROUP EXPORT_API FAR PASCAL MVGroupNot(MVGROUP mvGroup, LPERR lpErr);
VOID EXPORT_API FAR PASCAL MVGroupFree(MVGROUP mvGroup);
LONG EXPORT_API FAR PASCAL lMVGroupItemCount(MVGROUP mvGroup);
LONG EXPORT_API FAR PASCAL lMVGroupFind(MVGROUP mvGroup, DWORD dwCount);
MVGROUP EXPORT_API FAR PASCAL MVGroupCreate (DWORD dwMaxItems, LPERR lpErr);
ERR EXPORT_API FAR PASCAL nMVGroupRemoveItem(MVGROUP mvGroup, DWORD dwItem);
MVGROUP EXPORT_API PASCAL FAR MVGroupDuplicate (MVGROUP mvGroup, LPERR lpErr);
MVGROUP EXPORT_API FAR PASCAL MVGroupRead (HFILE hf, LPERR lpErr);
ERR EXPORT_API PASCAL FAR nMVGroupWrite (HFILE hf, MVGROUP mvGroup);
BOOL EXPORT_API FAR PASCAL fMVGroupLookup(MVGROUP mvGroup, DWORD);
MVGROUP EXPORT_API FAR PASCAL MVGroupLoad(HTITLE hTitle, LPSTR lpszFile, LPERR lpErr);
ERR EXPORT_API FAR PASCAL nMVGroupClear(MVGROUP lpGroup);


//
// 
VOID   EXPORT_API FAR PASCAL MVSetFileSystem(LPMV lpMv, HANDLE hfs);

// Title Service Enhancments

// can be used to determine if an HANDLE, HFILE, HANDLE or HANDLE is for an
// MVB that exists on the local system.
// if it is local, it returns TRUE.  MAC, Win16 and Static library versions will
// always return TRUE.
UINT EXPORT_API FAR PASCAL nMVHandleGetDriver(HANDLE);
UINT FAR PASCAL EXPORT_API nMVTitleAddDriver (LPCSTR lpsz);
HANDLE FAR PASCAL EXPORT_API hMVUnwrapHandle (HANDLE h);
void FAR PASCAL EXPORT_API MVTitleNotifyLayout(HANDLE h, HWND hWnd, BOOL fStart);
DWORD FAR PASCAL EXPORT_API MVTitlePreNotify(HANDLE h, WORD wType, LPBYTE lpBuf, DWORD dwBufLen);
ERR FAR PASCAL EXPORT_API MVTitleConnection (UINT nDrvNum, BOOL fConnect, LPCSTR lpszService);


#endif // MEDV14_H

#ifdef __cplusplus
}
#endif
