/*+ queue.h
 *
 *   routines for FIFO thread safe queueing code
 *
 *     Copyright (C) 1994, Microsoft Corporation, all rights reserved
 *-=====================================================================*/

#if !defined QUEUE_H
#define QUEUE_H

#ifndef DEBUG
#pragma message ("defining DEBUG in queue.h")
#define DEBUG
#endif

// include this struct as a field in any code that is to be enqueued.
//
typedef struct _qelm * PQELM;
typedef struct _qelm {
    PQELM pNext;
    PQELM pPrev;
    } QELM;

// use this for the head/tail of a queue.
//
typedef struct _qhead * PQHEAD;
typedef struct _qhead {
    HANDLE           hEvtElms;     // optional Semaphore that has element count
    CRITICAL_SECTION csList;       // list synchronization lock
    QELM             qe;           // head/tail pointers
    } QHEAD;

// Initalize the queue.
//
BOOL WINAPI QueueInitialize (
    PQHEAD  pHead
    );

// de-Initalize the queue
//
BOOL WINAPI QueueDelete (
    PQHEAD  pHead
    );

// insert an element in the queue. If a thread is waiting on the queue
// it will be awakened.
//
VOID WINAPI QueueInsert (
    PQHEAD pHead,
    PQELM  pqe
    );

// remove an element from the queue.  if the queue is empty.
// wait for an element to be inserted.  A timeout of 0 can be
// used to POLL the queue.
//
PQELM  WINAPI QueueRemove (
    PQHEAD pHead,
    DWORD  dwTimeout
    );

#ifdef DEBUG
void WINAPI QueueDump (
    PQHEAD pHead
    );
#else
 #define QueueDump(a)
#endif

#endif // QUEUE_H
