/*+ perftest.h
 *
 *  Copyright (C) 1994, Microsoft Corporation, all rights reserved
 *
 *-=====================================================================*/

#if !defined PERFTEST_H
#define PERFTEST_H

#ifndef NUMELMS
#define NUMELMS(aa) (sizeof(aa)/sizeof((aa)[0]))
#endif

// ======================== Structures =============================

#define MAXTITLE 64

// ==================== Function Prototypes ========================
// wndprocs.c
//
LRESULT WINAPI MainWndProc (
   HWND    hWnd,           // handle of main window
   UINT    wMsgID,         // id of current message
   WPARAM  wParam,         // word argument, depends on message id
   LPARAM  lParam);        // long argument, depends on message id

LONG WINAPI MainCommands(
   HWND    hWnd,           // handle of main window
   WPARAM  wParam,         // word argument, depends on message id
   LPARAM  lParam);        // long argument, depends on message id

// perf.c
//
LPVOID WINAPI AcquirePerfInfo (
    UINT nWho);

LONG WINAPI PerfTest (
   HWND    hWnd,
   LPVOID  lpv);

UINT  GetMethod    (LPVOID lpv);
void  SetMethod    (LPVOID lpv, UINT uMethod);
DWORD GetBlockSize (LPVOID lpv);
void  SetBlockSize (LPVOID lpv, DWORD dwBlockSize);
int   GetTestPrio  (LPVOID lpv);
void  SetTestPrio  (LPVOID lpv, int nPrio);
BOOL  GetFileName  (LPSTR lpszFile, UINT  cbFile);
BOOL  SetDoRead    (LPVOID lpv, BOOL bDoRead);
BOOL  GetDoRead    (LPVOID lpv);

// memperf.c
//
LPVOID WINAPI AcquireMemPerfInfo (
   UINT uCode);

LONG WINAPI TestMem (
    HWND     hWnd,
    LPVOID   lpPerf);

// qperf.c
//
LPVOID WINAPI AcquireQPerfInfo (
   UINT uCode);

LONG WINAPI TestQio (
    HWND     hWnd,
    LPVOID   lpPerf);

// aviperf.c
LPVOID WINAPI AcquireAviPerfInfo (
   UINT uCode);

LONG WINAPI TestAviFile (
    HWND     hWnd,
    LPVOID   lpv);

// init.c
//
BOOL WINAPI  RegClasses (
   HANDLE hInstance);
   
HWND WINAPI  CreateMainWindow (
   int     nCmdShow);      // manner in which to show the window

// winmain.c
//
int  WINAPI ErrorBox(
   UINT    wStringID,      // stringtable ID
   UINT    wType,          // type of message box (MB_xxx flags)
   ...);

#define EB_ERROR (MB_OK | MB_ICONHAND)
#define EB_QUERY (MB_YESNO | MB_ICONQUESTION)
#define EB_INFO  (MB_OK | MB_ICONINFO)

#if !defined SZCODE
  #define SZCODE STATIC CONST TCHAR
#endif

// ======================== Global Variables =======================

// if NO_VARS is defined, dont refer to global variables
// at all.  this is typically used when creating binary
// data using structures defined in this file.
//
#ifndef NO_VARS
//
// if DECLARE_VARS is defined, create global variables
// otherwise just refer to them as externs.  this works
// so long as only one module defines DECLARE_VARS (usually winmain)
//
#ifdef DECLARE_VARS

 #define PUBLIC
 PUBLIC CONST TCHAR cszMainClass[] = "WmmView";
 PUBLIC CONST TCHAR cszViewClass[] = "Viewer";

#else

 #define PUBLIC extern
 PUBLIC CONST TCHAR   cszMainClass[];
 PUBLIC CONST TCHAR   cszViewClass[];

#endif

PUBLIC HINSTANCE hInst;       // WinMain, set from hInstance
PUBLIC HWND      hWndMain;    // WinMain, set from CreateWindow
PUBLIC TCHAR     szApp[32];   // WinMain, set from IDS_APPNAME string
PUBLIC HWND      hWndClient;  // handle to MDI Client

#endif // end of NO_VARS ifdef

#endif // WMMVIEW_H


