/*+ disk32x.h
 *
 *   routines do to queued, asynchrous disk I/O in Win32
 *   (modified to gather performance data)
 *
 *     Copyright (C) 1994, Microsoft Corporation, all rights reserved
 *
 *-========================================================================*/

#if !defined DISK32_H
#define DISK32_H

#include "queue.h"

typedef struct _qiobuf * PQIOBUF;
typedef struct _qiobuf {
    QELM   qe;       // queue pointers, used by queue.c MUST be first field!!
    LPVOID lpv;      // pointer to data
    DWORD  cb;       // size of data
    DWORD  dwError;  // success/fail of write operation
    DWORD  cbWritten; // actual bytes written
    DWORD  dwOffset;  // seek offset to write at
    HANDLE hFile;     // handle to write to
    } QIOBUF;

#define QIO_MAX_THREADS 4

typedef struct _qio * LPQIO;
typedef struct _qio {
    QHEAD   que;     // head for buffers queued to be written
    PQHEAD  pqDone;  // pointer to head of queue for write completion
    HANDLE  hFile;
    DWORD   dwOffset;
    UINT    nThreads;
    struct _qio_thread {
        LPQIO  lpqio;
        HANDLE hThread;
        DWORD  tid;
        UINT   uState;
        UINT   nIOCount;
        int    nPrio;
        }   ath[QIO_MAX_THREADS];
    } QIO;

// open a file and prepare it for QIO write access
//
LPQIO WINAPI QioOpenFile (
    LPSTR  lpsz,
    DWORD  dwFlags,
    PQHEAD pqDone,
    UINT   nThreads,
    int    nPrio
    );

// write a buffer (via QIOBUF) to a file
//
BOOL WINAPI QioWriteFile (
    LPQIO   lpqio,
    PQIOBUF pqBuf
    );

// Close a QIO file and free the QIO structure
//
BOOL WINAPI QioCloseFile (
    LPQIO  lpqio
    );

#endif // DISK32_H
