/*************************************************************************
 *
 * rsh - Remote Shell Module
 *
 * Copyright(C) 1994 William K. W. Cheung
 * All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * WinRSH/WinRSH32 - Remote Shell for Windows
 * Author: William K. W. Cheung (wcheung@ee.ubc.ca)
 * Date:   June 30, 1994
 *
 ************************************************************************/
#ifndef _H_RSH
#define _H_RSH

#define WM_RSH                  (WM_USER + 1)
#define WM_RSHGETHOST           (WM_USER + 2)
#define WM_RSHENDSESSION        (WM_USER + 3)
#define RSHRECV					  (WM_USER + 4)
#define RSHTIMEOUT				  (WM_USER + 5)

typedef struct
{
	char    user[20];
	char    passwd[20];
	char    hostname[40];
	char    cmd[256];
} RSHSTRUCT;

extern RSHSTRUCT        rshStruct;

extern int RshOpen(int nProtocol);
extern void RshClose(void);
extern BOOL RshConnect(HWND hWnd, WPARAM wParam, LPARAM lParam);
extern BOOL RshGetHost(HWND hWnd, BOOL bConnected);
extern void RshDisconnect(void);
extern int RshRecv(LPSTR lpBuf, int nLen);
extern int RshSend(LPSTR lpBuf, int nLen);
extern int DoRsh(HWND hWnd, WPARAM wParam, LPARAM lParam);
extern BOOL RshRecvAsync(HWND hWnd);

#endif

