/*---------------------------------------------------------------------------
    MEMFIX.C - Windows "Out of DOS memory" fixer
    $Author:   Phlash  $
    $Date:   02 Feb 1995 22:43:22  $
    $Revision:   1.0  $

    This software is Copyright (c) Phil Ashby (AshbySoft *) 1995.

    This software is released under the terms of the GNU Public License,
    please see the file COPYING for more information.

---------------------------------------------------------------------------*/
#include <windows.h>

#define MAXSEGS     100

#define IDC_MEMINF  101
#define IDC_BLOCKS  102
#define IDC_ALLOC   103
#define IDC_SCAN    104
#define IDC_EXIT    105
#define IDC_HELP    106

static char szAppName[] = "(AshbySoft *) MemFix 1.0";
static DWORD keepSegs[MAXSEGS];
static DWORD freeSegs[MAXSEGS];
static int nShow, nBlocks, currBlocks=0;
static char buf[256];
static HANDLE hIcon;

BOOL FAR PASCAL DialogProc(HWND hDlg, WORD iMessage, WORD wParam, LONG lParam);
void ScanDosMemory(HANDLE hDlg);
void AllocDosMemory(HANDLE hDlg);

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
FARPROC lpfnDialogProc;

/* Check for number of blocks required (unless already running) */
   if(!hPrevInstance && lpCmdLine[0])
       nBlocks = atoi(lstrcpy(buf, lpCmdLine));
   else
       nBlocks = 0;
   if(nBlocks < 0 || nBlocks > MAXSEGS)
       nBlocks = MAXSEGS-1;

/* Load icon */
   hIcon = LoadIcon(hInstance, "MemFix");

/* Create dialog box and Go! */
   nShow = nCmdShow;
   lpfnDialogProc = MakeProcInstance((FARPROC)DialogProc, hInstance);
   DialogBox(hInstance, "MemFix", NULL, lpfnDialogProc);
   return TRUE;
}

BOOL FAR PASCAL DialogProc(HWND hDlg, WORD iMessage, WORD wParam, LONG lParam)
{
PAINTSTRUCT ps;
HDC hDC;

/* select action */
	switch(iMessage)
	{
    case WM_INITDIALOG:
         SetClassWord(hDlg, GCW_HICON, hIcon);
         SetWindowText(hDlg, szAppName);
         AllocDosMemory(hDlg);
         SetDlgItemInt(hDlg, IDC_BLOCKS, nBlocks, FALSE);
         ShowWindow(hDlg, nShow);
         break;

    case WM_CLOSE:
         nBlocks = 0;
         AllocDosMemory(hDlg);
         EndDialog(hDlg, 0);
         break;
/*
    case WM_PAINT:
         if(IsIconic(hDlg))
         {
            hDC = BeginPaint(hDlg, &ps);
            DrawIcon(hDC, 0, 0, hIcon);
            EndPaint(hDlg, &ps);
         }
         else
         {
            return FALSE;
         }
         break;
*/
    case WM_COMMAND:
         switch(wParam)
         {
         case IDCANCEL:
              break;

         case IDC_BLOCKS:
              nBlocks=GetDlgItemInt(hDlg, IDC_BLOCKS, NULL, FALSE);
              break;

         case IDOK:
         case IDC_ALLOC:
              if(nBlocks > MAXSEGS)
                 MessageBox(hDlg, "Too many blocks!", szAppName, MB_OK);
              else
                 AllocDosMemory(hDlg);
              break;

         case IDC_SCAN:
              ScanDosMemory(hDlg);
              break;

         case IDC_EXIT:
              DestroyWindow(hDlg);
              break;

         case IDC_HELP:
              WinHelp(hDlg, "MEMFIX.HLP", HELP_INDEX, 0L);
              break;

         default:
              wsprintf(buf, "Invalid command: %u, %lu", wParam, lParam);
              MessageBox(hDlg, buf, szAppName, MB_OK);
              break;
         }
         break;

	default:
		return FALSE;
	}
	return TRUE;
}

void ScanDosMemory(HANDLE hDlg)
{
DWORD dosSeg, dosBytes, delta;

/* Show current DOS memory usage */
   dosBytes = 1048576L;
   delta = dosBytes/2L;
   while(delta > 16L)
   {
       dosSeg = GlobalDosAlloc(dosBytes);
       if(dosSeg)
       {
           dosBytes += delta;
           GlobalDosFree(LOWORD(dosSeg));
       }
       else
           dosBytes -= delta;
       delta /= 2L;
   }
   wsprintf(buf, "%ld bytes free", dosBytes);
   SetDlgItemText(hDlg, IDC_MEMINF, buf);
}

void AllocDosMemory(HANDLE hDlg)
{
int i;

   if(currBlocks)
      for(i=0; i<currBlocks; i++)
         GlobalDosFree(LOWORD(keepSegs[i]));

   currBlocks = nBlocks;
   for(i=0; i<currBlocks; i++)
   {
      keepSegs[i] = GlobalDosAlloc(512L);
      if(!keepSegs[i])
      {
         currBlocks = i+1;
         break;
      }
      freeSegs[i] = GlobalDosAlloc(512L);
      if(!freeSegs[i])
      {
         GlobalDosFree(LOWORD(keepSegs[i]));
         currBlocks = i+1;
         break;
      }
   }
   for(i=0; i<currBlocks; i++)
      GlobalDosFree(LOWORD(freeSegs[i]));
   ScanDosMemory(hDlg);
}