unit matchp;
{
 EPSHeader

   File: match.pas
   Author: J. Kercheval
   Translated from C to Pascal by Scott Gifford
   Created: Sat, 01/05/1991  22:21:49
}
{
 EPSRevision History

   J. Kercheval  Wed, 02/20/1991  22:29:01  Released to Public Domain
   J. Kercheval  Fri, 02/22/1991  15:29:01  fix '\' bugs (two :( of them)
   J. Kercheval  Sun, 03/10/1991  19:31:29  add error return to matche()
   J. Kercheval  Sun, 03/10/1991  20:11:11  add is_valid_pattern code
   J. Kercheval  Sun, 03/10/1991  20:37:11  beef up main()
   J. Kercheval  Tue, 03/12/1991  22:25:10  Released as V1.1 to Public Domain
   S. Gifford    Sun, 09/12/1993  02:49:27  Translated to Turbo Pascal
}

{
   Wildcard Pattern Matching
}

interface


const MATCH_PATTERN  =6;    { bad pattern }
const MATCH_LITERAL  =5;    { match failure on literal match }
const MATCH_RANGE    =4;    { match failure on [..] construct }
const MATCH_ABORT    =3;    { premature end of text string }
const MATCH_END      =2;    { premature end of pattern string }
const MATCH_VALID    =1;    { valid match }
{ pattern defines }
const PATTERN_VALID  =0;    { valid pattern }
const PATTERN_ESC   =-1;    { literal escape at end of pattern }
const PATTERN_RANGE =-2;    { malformed range in [..] construct }
const PATTERN_CLOSE =-3;    { no end bracket in [..] construct }
const PATTERN_EMPTY =-4;    { [..] contstruct is empty }



function is_valid_pattern (p:String;var error_type:integer):boolean;
function matche ( p:String;CurP:integer;t:String;CurT:integer):integer;
function IsMatch(p,t:String):boolean;



implementation


function matche_after_star (p:string;CurP:integer;t:String;CurT:integer):integer;
  forward;

{----------------------------------------------------------------------------
*
* Return TRUE if PATTERN has any special wildcard characters
*
----------------------------------------------------------------------------}
function is_pattern(p:String):boolean;
var
  CurPos:integer;
begin
  for CurPos:=1 to Length(p) do
    if (p[CurPos] in ['?','*','[','\']) then begin
      is_pattern:=true;
      exit;
    end;
  is_pattern:=false;
end;      


{----------------------------------------------------------------------------
*
* Return TRUE if PATTERN has is a well formed regular expression according
* to the above syntax
*
* error_type is a return code based on the type of pattern error.  Zero is
* returned in error_type if the pattern is a valid one.  error_type return
* values are as follows:
*
*   PATTERN_VALID - pattern is well formed
*   PATTERN_ESC   - pattern has invalid escape ('\' at end of pattern)
*   PATTERN_RANGE - [..] construct has a no end range in a '-' pair (ie [a-])
*   PATTERN_CLOSE - [..] construct has no end bracket (ie [abc-g )
*   PATTERN_EMPTY - [..] construct is empty (ie [])
*
----------------------------------------------------------------------------}

function is_valid_pattern (p:String;var error_type:integer):boolean;
var
  CurPos:integer;
begin
    CurPos:=1;
    { init error_type }
    error_type := PATTERN_VALID;
    
    { loop through pattern to EOS }
    while CurPos <= Length(p) do begin

        { determine pattern type }
        case p[CurPos] of

            { check literal escape, it cannot be at end of pattern }
            '\':
              begin
                if CurPos = Length(p) then begin
                    error_type := PATTERN_ESC;
                    is_valid_pattern:=false;
                    exit;
                end;
                inc(CurPos);
                inc(CurPos);  {?}
              end;

            { the [..] construct must be well formed }
            '[':
              begin
                inc(CurPos);

                { if the next character is ']' then bad pattern }
                if ( p[CurPos] = ']' ) then begin
                    error_type:= PATTERN_EMPTY;
                    is_valid_pattern:=FALSE;
                    exit;
                end;
                
                { if end of pattern here then bad pattern }
                if ( CurPos>Length(p)) then begin
                    error_type:= PATTERN_CLOSE;
                    is_valid_pattern:= FALSE;
                    exit;
                end;

                { loop to end of [..] construct }
                while( p[CurPos] <> ']' ) do begin

                    { check for literal escape }
                    if( p[CurPos] = '\' ) then begin
                        inc(CurPos);
                        inc(CurPos); {?}

                        { if end of pattern here then bad pattern }
                        if ( CurPos>Length(p) ) then begin
                            error_type:= PATTERN_ESC;
                            is_valid_pattern:= FALSE;
                            exit;
                        end;
                    end
                    else
                        inc(CurPos);

                    { if end of pattern here then bad pattern }
                    if ( CurPos>Length(p) )then begin
                        error_type:= PATTERN_CLOSE;
                        is_valid_pattern:= FALSE;
                        exit;
                    end;

                    { if this a range }
                    if( p[CurPos] = '-' ) then begin

                        { we must have an end of range }
                        inc(CurPos);
                        if ( (CurPos>Length(p)) or (p[CurPos] = ']') ) then begin
                            error_type := PATTERN_RANGE;
                            is_valid_pattern:=FALSE;
                            exit;
                        end
                        else begin

                            { check for literal escape }
                            if( p[CurPos] = '\' )
                                then begin
                                  inc(CurPos);
                                  inc(CurPos); {?}
                                end;
                            { if end of pattern here then bad pattern }
                            if ( CurPos>Length(p) ) then begin
                                error_type := PATTERN_ESC;
                                is_valid_pattern:=false;
                                exit;
                            end;
                        end;
                    end;
                end;
              end;
            { all other characters are valid pattern elements }
            else inc(CurPos);
       end;
     end;

     is_valid_pattern:= TRUE;
end;


{----------------------------------------------------------------------------
*
*  Match the pattern PATTERN against the string TEXT;
*
*  returns MATCH_VALID if pattern matches, or an errorcode as follows
*  otherwise:
*
*            MATCH_PATTERN  - bad pattern
*            MATCH_LITERAL  - match failure on literal mismatch
*            MATCH_RANGE    - match failure on [..] construct
*            MATCH_ABORT    - premature end of text string
*            MATCH_END      - premature end of pattern string
*            MATCH_VALID    - valid match
*
*
*  A match means the entire string TEXT is used up in matching.
*
*  In the pattern string:
*       `*' matches any sequence of characters (zero or more)
*       `?' matches any character
*       [SET] matches any character in the specified set,
*       [!SET] or [^SET] matches any character not in the specified set.
*
*  A set is composed of characters or ranges; a range looks like
*  character hyphen character (as in 0-9 or A-Z).  [0-9a-zA-Z_] is the
*  minimal set of characters allowed in the [..] pattern construct.
*  Other characters are allowed (ie. 8 bit characters) if your system
*  will support them.
*
*  To suppress the special syntactic significance of any of `[]*?!^-\',
*  and match the character exactly, precede it with a `\'.
*
----------------------------------------------------------------------------}

function matche (p:String;CurP:integer; t:String;CurT:Integer):integer;
var
    range_start, range_end:char;  { start and end in range }
    invert:boolean;             { is this [..] or [!..] }
    member_match:boolean;       { have I matched the [..] construct? }
    loop:boolean;               { should I terminate? }
begin
    while (CurP <= Length(p)) do begin

        { if this is the end of the text then this is the end of the match }
        if (CurT>Length(t)) then begin
            if ( (p[CurP] in ['*','?']) and (CurP=Length(p)) ) then matche:=MATCH_VALID
              else if (CurP = Length(p)) and ( p[CurP] = t[CurT]) then matche:=MATCH_VALID
              else if (CurP = length(p)) and ( p[pred(CurP)] = '*')  then matche:=MATCH_VALID
              else matche:=MATCH_ABORT+10;
            exit; 
        end;
        { determine and react to pattern type }
        case ( p[CurP] ) of

            { single any character match }
            '?':;

            { multiple any character match }
            '*':
              begin
                matche:= matche_after_star (p,CurP,t,CurT);
                exit;
              end;

            { [..] construct, single member/exclusion character match }
            '[': 
              begin
                { move to beginning of range }
                inc(CurP);

                { check if this is a member match or exclusion match }
                if ( p[CurP] in ['!','^'] ) then begin
                    invert := TRUE;
                    inc(CurP);
                end
                else invert:= FALSE;

                { if closing bracket here or at range start then we have a
                   malformed pattern }
                if ( p[CurP] = ']' ) then begin
                    matche:=MATCH_PATTERN;
                    exit;
                end;

                member_match:= FALSE;
                loop:= TRUE;

                while ( loop ) do begin

                    { if end of construct then loop is done }
                    if (p[CurP] = ']') then
                        loop := FALSE
                    else begin

                      { matching a '!', '^', '-', '\' or a ']' }
                      if p[CurP]='\' then begin
                          inc(CurP);
                          range_start:=p[CurP];
                          range_end:=range_start;
                      end
                      else begin
                        range_start:=p[CurP];
                        range_end:=range_start;
                      end;
  
                      { if end of pattern then bad pattern (Missing ']') }
                      if CurP>Length(p) then begin
                          matche:=MATCH_PATTERN;
                          exit;
                      end;
  
                      { check for range bar }
                      inc(CurP);
                      if (p[CurP] = '-') then begin
  
                          { get the range end }
                          inc(CurP);
                          range_end:= p[CurP];

                          { if end of pattern or construct then bad pattern }
                          if ( (CurP > Length(P)) or (range_end = ']') )
                            then begin
                              matche:=MATCH_PATTERN;
                              exit;
                            end;

                          { special character range end }
                          if (range_end = '\') then begin
                              inc(CurP);
                              range_end := p[CurP];
  
                              { if end of text then we have a bad pattern }
                              if (CurP > Length(p)) then begin
                                  matche:=MATCH_PATTERN;
                                  exit;
                              end;
                          end;
  
                          { move just beyond this range }
                          inc(CurP);
                      end;
  
                      { if the text character is in range then match found.
                         make sure the range letters have the proper
                         relationship to one another before comparison }
                      if ( range_start < range_end  ) then begin
                          if (t[CurT] >= range_start)  and (t[CurT] <= range_end) then begin
                              member_match := TRUE;
                              loop := FALSE;
                          end;
                      end
                      else begin
                          if (t[CurT] >= range_end) and (t[CurT] <= range_start) then begin
                              member_match := TRUE;
                              loop := FALSE;
                           end;
                      end;
                    end; {else}
                  end; { While (loop) }
  
                  { if there was a match in an exclusion set then no match }
                  { if there was no match in a member set then no match }
                  if ((invert and member_match) or
                     not (invert or member_match))
                      then begin
                        matche:=MATCH_RANGE;
                        exit;
                      end;
  
                  { if this is not an exclusion then skip the rest of the [...]
                      construct that already matched. }
                  if member_match then begin
                      while (p[CurP] <> ']') do begin
  
                          { bad pattern (Missing ']') }
                          if (CurP>Length(p)) then begin
                              matche:=MATCH_PATTERN;
                              exit;
                          end;
  
                         { skip exact match }
                          if (p[CurP] = '\') then begin
                              inc(CurP);
  
                              { if end of text then we have a bad pattern }
                              if (CurP>Length(p)) then begin
                                  matche:= MATCH_PATTERN;
                                  exit;
                              end;
                          end;
  
                          { move to next pattern char }
                         inc(CurP);
                      end;
                  end;
              end; {If it's a '[']
  
              { next character is quoted and must match exactly }
              '\':
                begin
  
                  { move pattern pointer to quoted char and fall through }
                  inc(CurP);
  
                  { if end of text then we have a bad pattern }
                  if (CurP>Length(p)) then begin
                      matche:=MATCH_PATTERN;
                      exit;
                  end;
                  if (t[CurT] <> p[CurP])
                    then begin
                      matche:=MATCH_LITERAL;
                      exit;
                    end;
                end;
              { must match this character exactly }

              else if p[CurP] <> t[CurT] then begin
                      matche:=MATCH_LITERAL;
                      exit;
              end;
          end;

        inc(CurP);
        inc(CurT);

      end; {of While loop}
  
      { if end of text not reached then the pattern fails }
      if ( CurT < Length(t) )
      then
          matche:= MATCH_END
      else
          matche:= MATCH_VALID;
  end;
  
 
{----------------------------------------------------------------------------
*
* recursively call matche() with final segment of PATTERN and of TEXT.
*
----------------------------------------------------------------------------}

function matche_after_star (p:String;CurP:integer;t:String;CurT:integer):integer;
var
    match:integer;
    nextp:char;
begin
     match:=0;

    { pass over existing ? and * in pattern }
    while ( p[CurP] in ['?','*'] ) do begin

        { take one char for each ? and + }
        if ( p[CurP] = '?' ) then begin

            { if end of text then no match }
            if ( CurT=Length(t) )then begin
                matche_after_star:= MATCH_ABORT+20;
                exit;
            end;
        end;

        { move to next char in pattern }
        inc(CurP);
    end;

    { if end of pattern we have matched regardless of text left }
    if ( curP>Length(p) ) then begin
        matche_after_star:=MATCH_VALID;
        exit;
    end;

    { get the next character to match which must be a literal or '[' }
    nextp := p[CurP];
    if ( nextp = '\' ) then begin
        nextp := p[succ(CurP)];

        { if end of text then we have a bad pattern }
        if (CurP = Length(p)) then begin
            matche_after_star:= MATCH_PATTERN;
            exit;
        end;
    end;

    { Continue until we run out of text or definite result seen }
    repeat

        { a precondition for matching is that the next character
           in the pattern match the next character in the text or that
           the next pattern char is the beginning of a range.  Increment
           text pointer as we go here }
        if ( nextp = t[curT]) or (nextp = '[' ) then
            match := matche(p,CurP,t,CurT);

        { if the end of text is reached then no match }
        if (CurT>Length(t)) then match := MATCH_ABORT+30;
        inc(curT);

    until ( (match = MATCH_VALID) or 
              (match = MATCH_ABORT+30) or
              (match = MATCH_PATTERN) );

    { return result }
    matche_after_star:= match;
end;


{----------------------------------------------------------------------------
*
* IsMatch() is a shell to matche() to return only BOOLEAN values.
*
----------------------------------------------------------------------------}



function IsMatch(p,t:String):boolean;
var
    error_type:integer;
begin
    error_type := matche(p,1,t,1);
    IsMatch:=(error_type = MATCH_VALID);
end;



var
  str1,str2:string;

begin
end.