{
  DropOn V1.0 Source Code
  (c) 1993 Scott Gifford
  Please send bugs/comments/suggestions/compliments to ottscay@umcc.umich.edu.

  You are granted to use and modify this program, provided you:
    * Do not distribute modified code or executables without
        including this info at the top, the GNU Public License (COPYING),
        and documentation of any modifications you made.
    * Follow the other instructions in the GNU Public License, included
        in this distribution as COPYING
}
program dropon;
{ Code written in Turbo Pascal for Windows, V1.5.
  I know C is sort of the standard for Windows programming, but I
  don't have a Windows C compiler.  Of course, if someone wanted
  to give me one, I'd be happy to tranlate it... ;) )
}

uses matchp, { Regular expression library; see matchp.pas. }
     winprocs,WinTypes,WinDos,Strings,Win31,WinCRT;
     { /\ This is all TPW library stuff. /\ }

const
  Error='*+ERROR+*'; {If, for some godawful reason, you have a window named
                      *+ERROR+*, you can change this and recompile.}

var
  LaunchMe:array[0..85] of char; {File to be launched } 
  TitleSpec,  { RegExp describing title of dest. window} 
  ClassSpec,  { RE describing class }
  ModuleSpec, { RE describing module}
  CurParam:array[0..100] of char; { File from command-line we're working with }
  RcptWin:hWnd; { Calcualted handle of dest. window }
  EnumProc, { Proc for the callback func to find the top window }
  EnumProc2:TFarProc; { Proc to find the lower window }
  DropLocX,DropLocY:word; { Drop location }
  AppName:array[0..100] of char; { dropon's pseudoname for an app }
  BreakTime, 
  BreakStart:LongInt; { Used to pause before launching. }

function DoItsKidsMatch(WhichWin:hWnd; longTitle:LongInt):integer;
{
  Callback to search the a window's children.]
}
  export;

  var
    TestStr:array[0..80] of char;
  begin
    DoItsKidsMatch:=1;
    GetWindowText(WhichWin,TestStr,80);
    if not IsMatch(StrPas(PChar(longTitle)),StrPas(TestStr)) then exit;
    RcptWin := WhichWin; { Return value in global variable. }
  end;


function DoesItMatch(WhichWin:hWnd; Dummy:LongInt):integer;
{
Callback function to find top-level window
}
  export;

  var
    WinInstance:THandle;
    TestStr,Test2,DontCare:array[0..80] of char;
  begin
    DoesItMatch := 1;

    { Check for module }
    WinInstance:=GetWindowWord(WhichWin,gww_HInstance);
    GetModuleFileName(WinInstance,Test2,80);
    FileSplit(Test2,DontCare,TestStr,DontCare);
    if not IsMatch(StrPas(ModuleSpec),StrPas(TestStr)) then exit;

    { Check for title }
    GetWindowText(WhichWin,TestStr,80);
    if not IsMatch(StrPas(TitleSpec),StrPas(TestStr)) then exit;

    { Check for class; exit if it is not a classy window }
    GetClassName(WhichWin,TestStr,80);
    if not IsMatch(StrPas(ClassSpec),StrPas(TestStr)) then exit;


    { By default, this is the window ... }
    RcptWin := WhichWin;
    { ... but if a child window is specified, our quest must continue }
    GetPrivateProfileString(AppName,'SubWindow',Error,TestStr,80,'dropon.ini');
    if StrComp(TestStr,Error) = 0 then exit;

    { Find child window! }
    EnumProc2:=MakeProcInstance(@DoItsKidsMatch,hInstance);
    EnumChildWindows(RcptWin,EnumProc2,LongInt(@TestStr[0]));
    FreeProcInstance(EnumProc2);
  end;


type
  { Header with Drag 'N' Drop info }
  PDragHeader=^TDragHeader;
  TDragHeader=record
    wStructSize,x,y:Integer;
    fInClient:Boolean;
    Files:array[0..10000] of char;
  end;


procedure SendFilesTo(Me:hWnd);
{
  Performs the pseudodrop
}
  var
    TotalSize:word;
    i:integer;
    DDEMem:THandle;
    DDEPoint:Pointer;
    CurStrPos:word;
    CurParam:array[0..80] of char;
    DragInfo:PDragHeader;
  begin
    if (GetWindowLong(RcptWin,gwl_ExStyle) and ws_ex_AcceptFiles) = 0 then begin
      MessageBox(0,'Window won''t accept files','DropOn',mb_OK);
      exit;
    end;

    { Calculate size of memory block. }
    TotalSize:=10;
    for i:= 2 to ParamCount do begin
      StrPCopy(CurParam,ParamStr(i));
      TotalSize:=TotalSize + StrLen(CurParam);
    end;

    { Get some memory! }
    DDEMem:=GlobalAlloc(GMem_DDEShare,SizeOf(TDragHeader));
    if (DDEMem = 0) then begin
      MessageBox(0,'Couldn''t get memory','DropOn/SendFilesToMe()',mb_OK or mb_IconStop
      halt;
    end;
    DragInfo:=PDragHeader(GlobalLock(DDEMem));

    { Build our structure }
    DragInfo^.wStructSize:=7;
    DragInfo^.fInClient := true; 
    DragInfo^.x:=DropLocX;
    DragInfo^.y:=DropLocY;

    CurStrPos:=0;
    for i:= 2 to ParamCount do begin
      StrPCopy(CurParam,ParamStr(i));
      StrCopy( @DragInfo^.Files[CurStrPos], CurParam);
      CurStrPos:=CurStrPos + StrLen(CurParam) + 1;
    end;
    DragInfo^.Files[CurStrPos] := #0;
    GlobalUnlock(DDEMem);

    { and Drop... }
    SendMessage(RcptWin,wm_DropFiles,DDEMem,0);
    { ... splash}
  end;


begin
  if (ParamCount < 2) then begin
    MessageBox(0,'Invalid number of parameters','DropOn',mb_OK or mb_IconStop);
    exit;
  end;


  { Get our appname from the command-line }
  StrPCopy(CurParam,ParamStr(1));
  GetPrivateProfileString(CurParam,'Launch',Error,LaunchMe,80,'dropon.ini');
  if StrComp(LaunchMe,Error) = 0 then begin
    MessageBox(0,'Couldn''t find file','DropOn',mb_OK or mb_IconStop);
    exit;
  end;
  StrCopy(AppName,CurParam);

  { Get our info from our .ini file. }
  GetPrivateProfileString(AppName,'TitleSpec','*',TitleSpec,80,'dropon.ini');
  GetPrivateProfileString(AppName,'ClassSpec','*',ClassSpec,80,'dropon.ini');
  GetPrivateProfileString(AppName,'ModuleSpec','*',ModuleSpec,80,'dropon.ini');
  DropLocX := GetPrivateProfileInt(AppName,'DropLocX',0,'dropon.ini');
  DropLocY := GetPrivateProfileInt(AppName,'DropLocY',0,'dropon.ini');

  { Start looking; default to 0 = not found. }
  RcptWin := 0;
  EnumProc:=MakeProcInstance(@DoesItMatch,hInstance);
  EnumWindows(EnumProc,0);
  FreeProcInstance(EnumProc);

  if RcptWin <> 0
    then SendFilesTo(RcptWin) { We did it! }
    else begin
      { Launch the file, wait if necessary, and try again. }
      WinExec(LaunchMe,sw_Restore);
      BreakTime:=GetPrivateProfileInt(AppName,'LaunchBreak',0,'dropon.ini') * 100;
      BreakStart:=GetTickCount;
      repeat until (GetTickCount-BreakStart) >= BreakTime;

      RcptWin := 0;
      EnumProc:=MakeProcInstance(@DoesItMatch,hInstance);
      EnumWindows(EnumProc,0);
      FreeProcInstance(EnumProc);

      if RcptWin <> 0
        then SendFilesTo(RcptWin) { We did it! }
        else MessageBox(0,'Couldn''t find window','DropOn',mb_OK + mb_IconStop);
    end;

end.
