// NTLib.c

// (c) 1995 Microsoft Corporation. All rights reserved. 
// 		Developed by hip communications inc., http://info.hip.com/info/


#include <windows.h>
#define WIN32_LEAN_AND_MEAN

#include "EXTERN.h"
#include "perl.h"

#include "XSub.h"

#define CROAK croak

#define TMPBUFSZ 512

#define SUCCESSRETURNED(x)	(x == ERROR_SUCCESS)

#define SETIV(index,value) sv_setiv(ST(index), value)
#define SETPV(index,string) sv_setpv(ST(index), string)
#define SETPVN(index, buffer, length) sv_setpvn(ST(index), (char*)buffer, length)

static char thisFile[] = __FILE__;


XS(NTLoadLibrary)
{
	dXSARGS;
	int length;

	if(items != 1) 
	{
		CROAK ("usage: NTLoadLibrary($libname)\n");
	}

	XSRETURN_IV((long)LoadLibrary((char *) SvPV(ST(0), length)));
}

XS(NTFreeLibrary)
{
	dXSARGS;
	int length;

	if(items != 1) 
	{
		CROAK ("usage: NTFreeLibrary($hinstance)\n");
	}

	if(FreeLibrary((HINSTANCE) SvIV(ST(0))))
	{
		XSRETURN_YES;
	}
	XSRETURN_NO;
}

XS(NTGetProcAddress)
{
	dXSARGS;
	int length;

	if(items != 2) 
	{
		CROAK ("usage: NTGetProcAddress($hinstance, $procedurename)\n");
	}

	XSRETURN_IV((long)GetProcAddress((HINSTANCE) SvIV(ST(0)), (char *) SvPV(ST(1), length)));
}

void NTLibInit(void)
{
	newXS("NTLoadLibrary", NTLoadLibrary, thisFile);
	newXS("NTFreeLibrary", NTFreeLibrary, thisFile);
	newXS("NTGetProcAddress", NTGetProcAddress, thisFile);
}

