// NT.C

// (c) 1995 Microsoft Corporation. All rights reserved. 
// 		Developed by hip communications inc., http://info.hip.com/info/
// Portions (c) 1993 Intergraph Corporation. All rights reserved.

#include <windows.h>
#define WIN32_LEAN_AND_MEAN
#include "EXTERN.h"
#include "perl.h"
#include <fcntl.h>
#include <sys/stat.h>
#include <assert.h>
#include <sys/socket.h>

#define CROAK croak
#define USE_MYPOPEN	// replace to _popen to fix losing env stuff

// Registry access stuff
#define PERL_REGISTRY_KEY "SOFTWARE\\Microsoft\\Resource Kit\\PERL5"

BOOL HasRedirection(char *ptr)
{
	int inquote = 0;
	char quote = '\0';

	//
	// Scan string looking for redirection (< or >) or pipe
	// characters (|) that are not in a quoted string
	//
	while(*ptr) 
	{
		switch(*ptr) 
		{
			case '\'':
			case '\"':
				if(inquote) 
				{
					if(quote == *ptr) 
					{
						inquote = 0;
						quote = '\0';
					}
				}
				else
				{
					quote = *ptr;
					inquote++;
				}
				break;

			case '>':
			case '<':
			case '|':
				if(!inquote)
					return TRUE;

			default:
				break;
		}
		++ptr;
	}
	return FALSE;
}
#if defined(USE_MYPOPEN)

typedef struct _NtCmdLineElement {
    struct _NtCmdLineElement *next, *prev;
    char *str;
    int len;
    int flags;
} NtCmdLineElement;

//
// Possible values for flags
//

#define NTGLOB   0x1    // element contains a wildcard
#define NTMALLOC 0x2    // string in element was malloc'ed
#define NTSTRING 0x4    // element contains a quoted string

NtCmdLineElement *NtCmdHead = NULL, *NtCmdTail = NULL;

void
NtFreeCmdLine(void)
{
    NtCmdLineElement *ptr;
    
    while(NtCmdHead) {
    ptr = NtCmdHead;
    NtCmdHead = NtCmdHead->next;
    Safefree(ptr);
    }
    NtCmdHead = NtCmdTail = NULL;
}

//
// This function expands wild card characters that were spotted 
// during the parse phase. The idea here is to call FindFirstFile and
// FindNextFile with the wildcard pattern specified, and splice in the
// resulting list of new names. If the wildcard pattern doesn\'t match 
// any existing files, just leave it in the list.
//

void
NtCmdGlob (NtCmdLineElement *patt)
{
    WIN32_FIND_DATA fd;
    HANDLE fh;
    char buffer[512];
    char prefix[512];
    int prefixlen = 0;
    char *ptr;
    char root[4] = "x:\\";
    char volume[MAX_PATH];
    DWORD serial, maxname, flags;
    BOOL downcase = TRUE;
    NtCmdLineElement *tmphead, *tmptail, *tmpcurr;

    strncpy(buffer, patt->str, patt->len);
    buffer[patt->len] = '\0';

    //
    // find the prefix string (if any)
    //
    ptr = buffer;
    prefix[0] = '\0';
    while (ptr && *ptr != '*' && *ptr != '?')
        ptr++;
    if (ptr) {
        while(ptr != buffer && *ptr != '\\' && *ptr != '/' && *ptr != ':')
            ptr--;
        if (ptr != buffer) {
            prefixlen = ptr - buffer + 1;
            strncpy(prefix, buffer, prefixlen);
            prefix[prefixlen] = '\0';
        }
    }

    //
    // Now figure out if the file system is case-sensitive, so we know whether to
    // lower-case the names that we get back.
    //
    if (prefixlen && prefix[1] == ':') {
        root[0] = prefix[0];
    }
    else {
        char tbuf[MAX_PATH];
        if (GetFullPathName(".", MAX_PATH, tbuf, &ptr)) {
            strncpy (root, tbuf, 3);
        }
    }
    if (GetVolumeInformation(root, volume, MAX_PATH, &serial, &maxname, &flags, 0, 0)) { 
        downcase = !(flags & FS_CASE_SENSITIVE);
    }

    //
    // Now loop, reading the results of FindFirstFile and FindNextFile
    //

    if ((fh = FindFirstFile (buffer, &fd)) == INVALID_HANDLE_VALUE) {
        return;
    }
    tmphead = tmptail = NULL;
    do {
        New (1301, tmpcurr, 1 , NtCmdLineElement);
        memset (tmpcurr, 0, sizeof(*tmpcurr));
        tmpcurr->len = strlen(fd.cFileName) + prefixlen;
        New(1301, tmpcurr->str, tmpcurr->len+1, char);
        if (prefixlen) {
            strcat(strcpy(tmpcurr->str, prefix), fd.cFileName);
        }
        else {
            strcpy(tmpcurr->str, fd.cFileName);
        }
        if (downcase) strlwr (tmpcurr->str);
        tmpcurr->flags |= NTMALLOC;
        if (tmptail) {
            tmptail->next = tmpcurr;
            tmpcurr->prev = tmptail;
            tmptail = tmpcurr;
        }
        else {
            tmptail = tmphead = tmpcurr;
        }
    } while(FindNextFile(fh, &fd));
    
    //
    // ok, now we\'ve got a list of files that matched the wildcard
    // specification. Put it in place of the pattern structure.
    //
    
    tmphead->prev = patt->prev;
    tmptail->next = patt->next;

    if (tmphead->prev)
    tmphead->prev->next = tmphead;

    if (tmptail->next)
    tmptail->next->prev = tmptail;

    //
    // Now get rid of the pattern structure
    //

    if (patt->flags & NTMALLOC)
    Safefree(patt->str);
    Safefree(patt);
}


int 
NtMakeCmdVector (char *cmdline, char ***vec, int InputCmd)
{
    int cmdlen = strlen(cmdline);
    int done, instring, globbing, quoted, len;
    int newline, need_free = 0, i;
    int elements, strsz;
    int slashes = 0;
    char *ptr, *base, *buffer;
    char **vptr;
    char quote;
    NtCmdLineElement *curr;

    //
    // just return if we don\'t have a command line
    //

    if (cmdlen == 0) {
        *vec = NULL;
        return 0;
    }

    //
    // strip trailing white space
    //

    ptr = cmdline+(cmdlen - 1);
    while(ptr >= cmdline && isspace(*ptr))
        --ptr;
    *++ptr = '\0';
    
    //
    // check for newlines and formfeeds. If we find any, make a new
    // command string that replaces them with escaped sequences (\n or \f)
    //

    for (ptr = cmdline, newline = 0; *ptr; ptr++) {
        if (*ptr == '\n' || *ptr == '\f')
            newline++;
    }

    if (newline) {
        New (1200, base, strlen(cmdline) + 1 + newline + slashes, char);
        for (i = 0, ptr = base; (unsigned) i < strlen(cmdline); i++) {
            switch (cmdline[i]) {
              case '\n':
                *ptr++ = '\\';
                *ptr++ = 'n';
                break;
              default:
                *ptr++ = cmdline[i];
            }
        }
        *ptr = '\0';
        cmdline = base;
        need_free++;
    }
    
    //
    // Ok, parse the command line, building a list of CmdLineElements.
    // When we\'ve finished, and it\'s an input command (meaning that it\'s
    // the processes argv), we\'ll do globing and then build the argument 
    // vector.
    // The outer loop does one interation for each element seen. 
    // The inner loop does one interation for each character in the element.
    //

    for (done = 0, ptr = cmdline; *ptr;) {

        //
        // zap any leading whitespace
        //

        while(isspace(*ptr))
            ptr++;
        base = ptr;
        
        for (done = newline = globbing = instring = quoted = 0; 
             *ptr && !done; ptr++) {
            
            //
            // Switch on the current character. We only care about the
            // white-space characters, the  wild-card characters, and the
            // quote characters.
            //
            
            switch (*ptr) {
              case ' ':
              case '\t':
                //
                // if we\'re not in a string, then we\'re finished with this
                // element
                //
                
                if (!instring)
                    done++;
                break;

              case '*':
              case '?':

                // 
                // record the fact that this element has a wildcard character
                // N.B. Don\'t glob if inside a single quoted string
                //
                
                if (!(instring && quote == '\''))
                    globbing++;
                break;
                
              case '\n':
                
                //
                // If this string contains a newline, mark it as such so
                // we can replace it with the two character sequence "\n"
                // (cmd.exe doesn\'t like raw newlines in strings...sigh).
                //

                newline++;
                break;

              case '\'':
              case '\"':

                //
                // if we\'re already in a string, see if this is the
                // terminating close-quote. If it is, we\'re finished with 
                // the string, but not neccessarily with the element.
                // If we\'re not already in a string, start one.
                //
                
                if (instring) {
                    if (quote == *ptr) {
                        instring = 0;
                        quote = '\0';
                    }
                }
                else {
                    instring++;
                    quote = *ptr;
                    quoted++;
                }
                break;
            }
        }

        //
        // need to back up ptr by one due to last increment of for loop
        // (if we got out by seeing white space)
        //
        
        if (*ptr)
            ptr--;
        
        //
        // when we get here, we\'ve got a pair of pointers to the element,
        // base and ptr. Base points to the start of the element while ptr
        // points to the character following the element.
        //

        New (1201, curr, 1, NtCmdLineElement);
        memset (curr, 0, sizeof(*curr));

        len = ptr - base;

        //
        // if it\'s an input vector element and it\'s enclosed by quotes, 
        // we can remove them.
        //
        
        if (InputCmd &&
            ((base[0] == '\"' && base[len-1] == '\"') ||
             (base[0] == '\'' && base[len-1] == '\''))) {
            base++;
            len -= 2;
        }

        curr->str = base;
        curr->len = len;
        curr->flags |= (globbing ? NTGLOB : 0);

        //
        // Now put it in the list of elements
        //
        if (NtCmdTail) {
            NtCmdTail->next = curr;
            curr->prev = NtCmdTail;
            NtCmdTail = curr;
        }
        else {
            NtCmdHead = NtCmdTail = curr;
        }
    }

    if (InputCmd) {

        //
        // When we get here we\'ve finished parsing the command line. Now 
        // we need to run the list, expanding any globbing patterns.
        //
        
        for(curr = NtCmdHead; curr; curr = curr->next) {
            if (curr->flags & NTGLOB) {
                NtCmdGlob(curr);
            }
        }
    }

    //
    // Almost done! 
    // Count up the elements, then allocate space for a vector of pointers
    // (argv) and a string table for the elements.
    // 
    
    for (elements = 0, strsz = 0, curr = NtCmdHead; curr; curr = curr->next) {
        elements++;
        strsz += (curr->len + 1);
    }

    len = (elements+1)*sizeof(char *) + strsz;
    New (1202, buffer, len, char);
    
    memset (buffer, 0, len);

    //
    // make vptr point to the start of the buffer
    // and ptr point to the area we\'ll consider the string table.
    //

    vptr = (char **) buffer;

    ptr = buffer + (elements+1) * sizeof(char *);

    for (curr =  NtCmdHead; curr;  curr = curr->next) {
        strncpy (ptr, curr->str, curr->len);
        ptr[curr->len] = '\0';
        *vptr++ = ptr;
        ptr += curr->len + 1;
    }
    NtFreeCmdLine();
    *vec = (char **) buffer;
    return elements;
}

// popen stuff
// JCW - Do this so that modifications to %ENV are propogated to child 
// processes run by backticks 


//
// use these so I can remember which index is which
//

#define NtPipeRead  0      // index of pipe read descriptor
#define NtPipeWrite 1      // index of pipe write descriptor

#define NtPipeSize  1024   // size of pipe buffer

#define MYPOPENSIZE 256    // size of book keeping structure

struct 
{
	int inuse;
	int pid;
	FILE *pipe;
} MyPopenRecord[MYPOPENSIZE];

FILE *my_popen (char *cmd, char *mode) 
{
	FILE *fp;
	char *shell;
	int saved, reading;
	int pipemode;
	int pipes[2];
	int pid;
	int slot;
	static initialized = 0;

	//
	// if first time through, intialize our book keeping structure
	//

	if (!initialized++) 
	{
		for (slot = 0; slot < MYPOPENSIZE; slot++)
			MyPopenRecord[slot].inuse = FALSE;
	}

	//
	// find a free popen slot
	//

	for (slot = 0; slot < MYPOPENSIZE && MyPopenRecord[slot].inuse; slot++)
		;

	if (slot > MYPOPENSIZE) 
	{
		return NULL;
	}

	//
	// Figure out what we\'re doing...
	//

	reading = (*mode == 'r') ? TRUE : FALSE;
	pipemode = (*(mode+1) == 'b') ? O_BINARY : O_TEXT;

	//
	// Now get a pipe
	//
    
	if (_pipe(pipes, NtPipeSize, pipemode) == -1) 
	{
		return NULL;
	}

	if (reading) 
	{

		//
		// we\'re reading from the pipe, so we must hook up the
		// write end of the pipe to the new processes stdout.
		// To do this we must save our file handle from stdout
		// by _dup\'ing it, then setting our stdout to be the pipe\'s 
		// write descriptor. We must also make the write handle 
		// inheritable so the new process can use it.

		if ((saved = _dup(fileno(stdout))) == -1) 
		{
			_close(pipes[NtPipeRead]);
			_close(pipes[NtPipeWrite]);
			return NULL;
		}
		if (_dup2 (pipes[NtPipeWrite], fileno(stdout)) == -1) 
		{
			_close(pipes[NtPipeRead]);
			_close(pipes[NtPipeWrite]);
			return NULL;
		}
	}
	else 
	{
		//
		// must be writing to the new process. Do the opposite of
		// the above, i.e. hook up the processes stdin to the read
		// end of the pipe.
		//

		if ((saved = _dup(fileno(stdin))) == -1)
		{
			_close(pipes[NtPipeRead]);
			_close(pipes[NtPipeWrite]);
			return NULL;
		}
		if (_dup2(pipes[NtPipeRead], fileno(stdin)) == -1)
		{
			_close(pipes[NtPipeRead]);
			_close(pipes[NtPipeWrite]);
			return NULL;
		}
	}
    
	//
	// Start the new process.
	//

	if (HasRedirection(cmd)) 
	{
docmd:
		if((shell = getenv("COMSPEC")) == 0)
		    shell = "cmd.exe";

		pid = spawnlpe(_P_NOWAIT, shell, shell, "/c", cmd, 0, environ);
		if (pid == -1)
		{
			_close(pipes[NtPipeRead]);
			_close(pipes[NtPipeWrite]);
			return NULL;
		}
	}
	else
	{
		char **vec;
		int vecc = NtMakeCmdVector(cmd, &vec, FALSE);

		pid = spawnvpe (_P_NOWAIT, vec[0], vec, environ);
		Safefree (vec);

		if (pid == -1) 
		{
			goto docmd;
		}
	}
    
	if (reading)
	{

		//
		// We need to close our instance of the inherited pipe write
		// handle now that it's been inherited so that it will actually close
		// when the child process ends.
		//

		if (_close(pipes[NtPipeWrite]) == -1)
		{
			_close(pipes[NtPipeRead]);
			return NULL;
		}
		if (_dup2 (saved, fileno(stdout)) == -1)
		{
			_close(pipes[NtPipeRead]);
			return NULL;
		}
		_close(saved);

		// 
		// Now get a stream pointer to return to the calling program.
		//

		if ((fp = (FILE *) _fdopen(pipes[NtPipeRead], mode)) == NULL)
		{
			return NULL;
		}
	}
	else
	{

		//
		// writing
		// need to close our read end of the pipe so that it will go 
		// away when the write end is closed.
		//

		if (_close(pipes[NtPipeRead]) == -1)
		{
			_close(pipes[NtPipeWrite]);
			return NULL;
		}
		if (_dup2 (saved, fileno(stdin)) == -1)
		{
			_close(pipes[NtPipeWrite]);
			return NULL;
		}
		_close(saved);

		// 
		// Now get a stream pointer to return to the calling program.
		//

		if ((fp = (FILE *) _fdopen(pipes[NtPipeWrite], mode)) == NULL)
		{
			_close(pipes[NtPipeWrite]);
			return NULL;
		}

		// 
		// For some reason, linebuffering on output pipes doesn\'t
		// seem to work. For now, we\'ll just make output pipes 
		// non-buffered (blechh)

		if (setvbuf(fp, NULL, _IONBF, 0))
		{
			_close(pipes[NtPipeWrite]);
			return NULL;
		}
	}

	//
	// do the book keeping
	//

	MyPopenRecord[slot].inuse = TRUE;
	MyPopenRecord[slot].pipe = fp;
	MyPopenRecord[slot].pid = pid;

	return fp;
}

long my_pclose(FILE *fp)
{
	int i;
	int exitcode;

	for (i = 0; i < MYPOPENSIZE; i++)
	{
		if (MyPopenRecord[i].inuse && MyPopenRecord[i].pipe == fp)
	    	break;
	}
	if (i >= MYPOPENSIZE) 
	{
		CROAK("Invalid file pointer passed to mypclose!\n");
	}

	//
	// get the return status of the process
	//

	if (_cwait(&exitcode, MyPopenRecord[i].pid, WAIT_CHILD) == -1) 
	{
		if (errno == ECHILD) 
		{
			char errorBuffer[256];
			sprintf(errorBuffer, "mypclose: nosuch child as pid %x\n", MyPopenRecord[i].pid);
			CROAK(errorBuffer);
		}
	}

	//
	// close the pipe
	//

	fclose(fp);

	//
	// free this slot
	//

	MyPopenRecord[i].inuse = FALSE;

	return exitcode*256;
}
#else

FILE *my_popen(char *cmd, char *mode)
{
	return _popen(cmd, mode);
}

long my_pclose(FILE *fp)
{
	return _pclose(fp);
}

#endif // defined(USE_MYPOPEN)


BOOL NtGetRegStr(HKEY hkey, LPTSTR lpszValueName, LPSTR lpszDefault, LPSTR lpszData, LPDWORD dwDataLen)
{	// Retrieve a REG_SZ or REG_EXPAND_SZ from the registry
    HKEY handle;
    DWORD type;
    char *subkey = PERL_REGISTRY_KEY;
    long retval;

    retval = RegOpenKeyEx(hkey, subkey, 0, KEY_READ, &handle);
    if(retval != ERROR_SUCCESS) 
    {
        RegCloseKey(handle);
        strcpy(lpszData, lpszDefault);
        return FALSE;
    }
    retval = RegQueryValueEx(handle, lpszValueName, 0, &type, lpszData, dwDataLen);
    if(retval != ERROR_SUCCESS || (type != REG_SZ && type != REG_EXPAND_SZ)) 
    {
        RegCloseKey(handle);
        strcpy(lpszData, lpszDefault);
        return FALSE;
    }
    RegCloseKey(handle);
    return TRUE;
}

char *NtGetLib(void)
{
	static char libpath[MAX_PATH+1];
	static BOOL called = 0;

	if(!called) 
	{
		DWORD bufsz;

		bufsz = sizeof(libpath);
		if(!NtGetRegStr(HKEY_CURRENT_USER, "PRIVLIB", DEFPRIVLIB, libpath, &bufsz))
		{
			NtGetRegStr(HKEY_LOCAL_MACHINE, "PRIVLIB", DEFPRIVLIB, libpath, &bufsz);
		}
		called = TRUE;
	}
	return libpath;
}

char *NtGetBin(void)
{
	static char binpath[MAX_PATH+1];
	static BOOL called = 0;

	if(!called) 
	{
		DWORD bufsz;

		bufsz = sizeof(binpath);
		if(!NtGetRegStr(HKEY_CURRENT_USER, "BIN", DEFBIN, binpath, &bufsz))
		{
			NtGetRegStr(HKEY_LOCAL_MACHINE, "BIN", DEFBIN, binpath, &bufsz);
		}
		called = TRUE;
	}
	return binpath;
}

static char *NTLoginName = NULL;

char *getlogin()
{
	char buffer[200];
	int len = 200;

	if(NTLoginName == NULL) 
	{
		if(GetUserName(buffer, &len)) 
		{
			New(1901, NTLoginName, len+1, char);
			strncpy(NTLoginName, buffer, len);
			NTLoginName[len] = '\0';
		}
		else 
		{
			NTLoginName = "<Unknown>";
		}
	}
	return NTLoginName;
}


int do_aspawn(void* really, void** mark, void** arglast)
{
	char **argv;
	char *strPtr;
	char *cmd;
	int status;
	int length;
	int index = 0;
    SV *sv = (SV*)really;
	SV** pSv = (SV**)mark;

	New(1110, argv, (arglast - mark) + 3, char*);

	if(sv != Nullsv)
	{
		cmd = SvPV(sv, length);
	}
	else
	{
		if((cmd = getenv("COMSPEC")) == 0)
	    	cmd = "cmd.exe";

		argv[index++] = "/c";
	}

	while(pSv <= (SV**)arglast)
	{
		sv = *pSv++;
		strPtr = SvPV(sv, length);
		if(strPtr != NULL && *strPtr != '\0')
			argv[index++] = strPtr;
	}
	argv[index++] = 0;

	status = spawnvpe(P_WAIT, cmd, argv, environ);

	Safefree(argv);

	return status*256;
}

int	do_spawn(char *cmd)
{
	char **a;
	char *s;
	char **argv;
	int status = -1;
	char *shell, *cmd2;

	/* save an extra exec if possible */
	if((shell = getenv("COMSPEC")) == 0)
	    shell = "cmd.exe";

	/* see if there are shell metacharacters in it */
	if(!HasRedirection(cmd)) 
	{
		New(1102,argv, strlen(cmd) / 2 + 2, char*);

		New(1103,cmd2, strlen(cmd) + 1, char);
		strcpy(cmd2, cmd);
		a = argv;
		for(s = cmd2; *s;) 
		{
			while(*s && isspace(*s)) s++;
			if(*s)
				*(a++) = s;
			while(*s && !isspace(*s)) s++;
			if(*s)
				*s++ = '\0';
		}
		*a = Nullch;
		if(argv[0])
		{
			status = spawnvpe(P_WAIT, argv[0], argv, environ);
		}
		Safefree(argv);
		Safefree(cmd2);
	}
	if(status == -1)
        status = spawnle(P_WAIT, shell, shell, "/c", cmd, (char*)0, environ);

	return status*256;
}


#define PATHLEN 1024

// The idea here is to read all the directory names into a string table
// (separated by nulls) and when one of the other dir functions is called
// return the pointer to the current file name. 
DIR *opendir(char *filename)
{
    DIR            *p;
	long            len;
	long            idx;
	char            scannamespc[PATHLEN];
	char       *scanname = scannamespc;
	struct stat     sbuf;
	WIN32_FIND_DATA FindData;
	HANDLE          fh;
	char            root[_MAX_PATH];
	char            volname[_MAX_PATH];
	DWORD           serial, maxname, flags;
	BOOL            downcase;
	char           *dummy;

	// check to see if filename is a directory
	if(stat(filename, &sbuf) < 0 || sbuf.st_mode & _S_IFDIR == 0)
	{
		return NULL;
	}

	// get the file system characteristics
	if(GetFullPathName(filename, MAX_PATH, root, &dummy)) 
	{
		if(dummy = strchr(root, '\\'))
			*++dummy = '\0';
		if(GetVolumeInformation(root, volname, MAX_PATH, &serial, &maxname, &flags, 0, 0)) 
		{
			downcase = !(flags & FS_CASE_SENSITIVE);
		}
	}
	else 
	{
		downcase = TRUE;
	}

	// Get us a DIR structure
	Newz(1501, p, 1, DIR);
	if(p == NULL)
		return NULL;

	// Create the search pattern
	strcpy(scanname, filename);

	if(index("/\\", *(scanname + strlen(scanname) - 1)) == NULL)
		strcat(scanname, "/*");
	else
		strcat(scanname, "*");

	// do the FindFirstFile call
	fh = FindFirstFile(scanname, &FindData);
	if(fh == INVALID_HANDLE_VALUE) 
	{
		return NULL;
	}

	// now allocate the first part of the string table for the filenames that we find.
	idx = strlen(FindData.cFileName)+1;
	New(1502, p->start, idx, char);
	if(p->start == NULL) 
	{
		CROAK("opendir: malloc failed!\n");
	}
	strcpy(p->start, FindData.cFileName);
	if(downcase)
		strlwr(p->start);
	p->nfiles++;

	// loop finding all the files that match the wildcard
	// (which should be all of them in this directory!).
	// the variable idx should point one past the null terminator
	// of the previous string found.
	//
	while(FindNextFile(fh, &FindData)) 
	{
		len = strlen(FindData.cFileName);
		// bump the string table size by enough for the
		// new name and it's null terminator 
		Renew(p->start, idx+len+1, char);
		if(p->start == NULL) 
		{
	    	CROAK("opendir: malloc failed!\n");
		}
		strcpy(&p->start[idx], FindData.cFileName);
		if(downcase) 
	    	strlwr(&p->start[idx]);
		p->nfiles++;
		idx += len+1;
	}
	FindClose(fh);
	p->size = idx;
	p->curr = p->start;
	return p;
}


// Readdir just returns the current string pointer and bumps the
// string pointer to the next entry.
struct direct *readdir(DIR *dirp)
{
	int         len;
	static int  dummy = 0;

	if(dirp->curr) 
	{	// first set up the structure to return
		len = strlen(dirp->curr);
		strcpy(dirp->dirstr.d_name, dirp->curr);
		dirp->dirstr.d_namlen = len;

		// Fake an inode
		dirp->dirstr.d_ino = dummy++;

		// Now set up for the next call to readdir
		dirp->curr += len + 1;
		if(dirp->curr >= (dirp->start + dirp->size)) 
		{
	    	dirp->curr = NULL;
		}

		return &(dirp->dirstr);
	} 
	else
		return NULL;
}

// Telldir returns the current string pointer position
long telldir(DIR *dirp)
{
    return (long) dirp->curr;
}


// Seekdir moves the string pointer to a previously saved position (Saved by telldir).
void seekdir(DIR *dirp, long loc)
{
    dirp->curr = (char *)loc;
}

// Rewinddir resets the string pointer to the start
void rewinddir(DIR *dirp)
{
    dirp->curr = dirp->start;
}

// free the memory allocated by opendir
int closedir(DIR *dirp)
{
    Safefree(dirp->start);
    Safefree(dirp);
	return 1;
}

#ifdef USE_SOCKET_AS_HANDLES
// thanks to Beverly Brown	(beverly@datacube.com)
#define OPEN_SOCKET(x)	_open_osfhandle(x,_O_BINARY)
#define TO_SOCKET(x)	_get_osfhandle(x)

#else

#define OPEN_SOCKET(x)	(x)
#define TO_SOCKET(x)	(x)

#endif	// USE_SOCKET_AS_HANDLES

//
// This is a clone of fdopen so that we can handle the version of sockets that NT gets to use.
//
// The problem is that sockets are not real file handles and 
// cannot be fdopen'ed. This causes problems in the do_socket
// routine in doio.c, since it tries to create two file pointers
// for the socket just created. We'll fake out an fdopen and see
// if we can prevent perl from trying to do stdio on sockets.
//

#ifndef USE_SOCKET_AS_HANDLES
FILE *myfdopen(int fd, char *mode)
{
	FILE *fp;
	char sockbuf[256];
	int optlen = sizeof(sockbuf);
	int retval;

	retval = getsockopt((SOCKET)fd, SOL_SOCKET, SO_TYPE, sockbuf, &optlen);
	if(retval == SOCKET_ERROR && WSAGetLastError() == WSAENOTSOCK) 
	{
		return(_fdopen(fd, mode));
	}

	//
	// If we get here, then fd is actually a socket.
	//
	Newz(1601, fp, 1, FILE);
	if(fp == NULL)
	{
		errno = ENOMEM;
		return NULL;
	}

	fp->_file = fd;
	if(*mode == 'r')
		fp->_flag = _IOREAD;
	else
		fp->_flag = _IOWRT;

	return fp;
}
#endif	// USE_SOCKET_AS_HANDLES


//
// Since the errors returned by the socket error function 
// WSAGetLastError() are not known by the library routine strerror
// we have to roll our own.
//

#undef strerror

char *nt_strerror(int e) 
{
	static char buffer[512];
	extern int sys_nerr;
	DWORD source = 0;

	if(e < 0 || e > sys_nerr) 
	{
		if(e < 0)
			e = GetLastError();

		if(FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, &source, e, 0, buffer, sizeof(buffer), NULL) == 0) 
			strcpy(buffer, "Unknown Error");

		return buffer;
	}

	return strerror(e);
}

//
// various stubs
//


// Ownership
//
// Just pretend that everyone is a superuser. NT will let us know if
// we don\'t really have permission to do something.
//

#define ROOT_UID    ((uid_t)0)
#define ROOT_GID    ((gid_t)0)

uid_t getuid(void)
{
	return ROOT_UID;
}

uid_t geteuid(void)
{
	return ROOT_UID;
}

gid_t getgid(void)
{
	return ROOT_GID;
}

gid_t getegid(void)
{
	return ROOT_GID;
}

int setuid(uid_t uid)
{ 
	return (uid == ROOT_UID ? 0 : -1);
}

int setgid(gid_t gid)
{
	return (gid == ROOT_GID ? 0 : -1);
}

//
// File system stuff
//

int ioctl(int i, unsigned int u, char *data)
{
	CROAK("ioctl not implemented!\n");
	return -1;
}

unsigned int sleep(unsigned int t)
{
	Sleep(t*1000);
	return 0;
}



static int SocketsInitialized = 0;

void StartSockets(void) 
{
    unsigned short version;
    WSADATA retdata;
    int ret;
    int iSockOpt = SO_SYNCHRONOUS_NONALERT;
    
    //
    // initalize the winsock interface and insure that it is
    // cleaned up at exit.
    //
    version = 0x101;
    if(ret = WSAStartup(version, &retdata))
    	CROAK("Unable to locate winsock library!\n");
    if(retdata.wVersion != version)
	    CROAK("could not find version 1.1 of winsock dll\n");

    atexit((void (*)(void)) WSACleanup);

	SocketsInitialized = 1;

#ifdef USE_SOCKET_AS_HANDLES
	//
	// Enable the use of sockets as filehandles
	//
	setsockopt(INVALID_SOCKET, SOL_SOCKET, SO_OPENTYPE, (char *)&iSockOpt, sizeof(iSockOpt));
#endif	// USE_SOCKET_AS_HANDLES
}

#define SOCKET_TEST(x, y)	if(!SocketsInitialized) StartSockets();\
							if((x) == (y)) errno = WSAGetLastError()

#define SOCKET_TEST_ERROR(x) SOCKET_TEST(x,	SOCKET_ERROR)

#undef accept

SOCKET nt_accept(SOCKET s, struct sockaddr *addr, int *addrlen)
{
	SOCKET r;

	SOCKET_TEST((r = accept(TO_SOCKET(s), addr, addrlen)), INVALID_SOCKET);
	return OPEN_SOCKET(r);
}

#undef bind

int nt_bind(SOCKET s, struct sockaddr *addr, int addrlen)
{
	int r;

	SOCKET_TEST_ERROR(r = bind(TO_SOCKET(s), addr, addrlen));
	return r;
}

#undef connect

int nt_connect(SOCKET s, struct sockaddr *addr, int addrlen)
{
	int r;

	SOCKET_TEST_ERROR(r = connect(TO_SOCKET(s), addr, addrlen));
	return r;
}


#undef getpeername

int nt_getpeername(SOCKET s, struct sockaddr *addr, int *addrlen)
{
	int r;

	SOCKET_TEST_ERROR(r = getpeername(TO_SOCKET(s), addr, addrlen));
	return r;
}

#undef getsockname

int nt_getsockname(SOCKET s, struct sockaddr *addr, int *addrlen)
{
	int r;

	SOCKET_TEST_ERROR(r = getsockname(TO_SOCKET(s), addr, addrlen));
	return r;
}

#undef getsockopt

int nt_getsockopt(SOCKET s, int level, int optname, char *optval, int *optlen)
{
	int r;

	SOCKET_TEST_ERROR(r = getsockopt(TO_SOCKET(s), level, optname, optval, optlen));
	return r;
}

#undef ioctlsocket

int nt_ioctlsocket(SOCKET s, long cmd, u_long *argp)
{
	int r;

	SOCKET_TEST_ERROR(r = ioctlsocket(TO_SOCKET(s), cmd, argp));
	return r;
}

#undef listen

int nt_listen(SOCKET s, int backlog)
{
	int r;

	SOCKET_TEST_ERROR(r = listen(TO_SOCKET(s), backlog));
	return r;
}

#undef recv

int nt_recv(SOCKET s, char *buf, int len, int flags)
{
	int r;

	SOCKET_TEST_ERROR(r = recv(TO_SOCKET(s), buf, len, flags));
	return r;
}

#undef recvfrom

int nt_recvfrom(SOCKET s, char *buf, int len, int flags, struct sockaddr *from, int *fromlen)
{
	int r;

	SOCKET_TEST_ERROR(r = recvfrom(TO_SOCKET(s), buf, len, flags, from, fromlen));
	return r;
}

#undef select

long nt_select(int nfds, fd_set *rd, fd_set *wr, fd_set *ex, struct timeval *timeout)
{
	long r;

	SOCKET_TEST_ERROR(r = select(nfds, rd, wr, ex, timeout));
	return r;
}

#undef send

int nt_send(SOCKET s, char *buf, int len, int flags)
{
	int r;

	SOCKET_TEST_ERROR(r = send(TO_SOCKET(s), buf, len, flags));
	return r;
}

#undef sendto

int nt_sendto(SOCKET s, char *buf, int len, int flags, struct sockaddr *to, int tolen)
{
	int r;

	SOCKET_TEST_ERROR(r = sendto(TO_SOCKET(s), buf, len, flags, to, tolen));
	return r;
}

#undef setsockopt

int nt_setsockopt(SOCKET s, int level, int optname, char *optval, int optlen)
{
	int r;

	SOCKET_TEST_ERROR(r = setsockopt(TO_SOCKET(s), level, optname, optval, optlen));
	return r;
}
    
#undef shutdown

int nt_shutdown(SOCKET s, int how)
{
	int r;

	SOCKET_TEST_ERROR(r = shutdown(TO_SOCKET(s), how));
	return r;
}

#undef socket

SOCKET nt_socket(int af, int type, int protocol)
{
	SOCKET s;

#ifndef USE_SOCKET_AS_HANDLES
	SOCKET_TEST(s = socket(af, type, protocol), INVALID_SOCKET);
#else
	if(!SocketsInitialized)
		StartSockets();

	if((s = socket(af, type, protocol)) == INVALID_SOCKET)
		errno = WSAGetLastError();
	else
		s = OPEN_SOCKET(s);
#endif	// USE_SOCKET_AS_HANDLES

	return s;
}

#undef gethostbyaddr

struct hostent *nt_gethostbyaddr(char *addr, int len, int type)
{
	struct hostent *r;

	SOCKET_TEST(r = gethostbyaddr(addr, len, type), NULL);
	return r;
}

#undef gethostbyname

struct hostent *nt_gethostbyname(char *name)
{
	struct hostent *r;

	SOCKET_TEST(r = gethostbyname(name), NULL);
	return r;
}

#undef gethostname

int nt_gethostname(char *name, int len)
{
	int r;

	SOCKET_TEST_ERROR(r = gethostname(name, len));
	return r;
}

#undef getprotobyname

struct protoent *nt_getprotobyname(char *name)
{
	struct protoent *r;

	SOCKET_TEST(r = getprotobyname(name), NULL);
	return r;
}

#undef getprotobynumber

struct protoent *nt_getprotobynumber(int num)
{
	struct protoent *r;

	SOCKET_TEST(r = getprotobynumber(num), NULL);
	return r;
}

#undef getservbyname

struct servent *nt_getservbyname(char *name, char *proto)
{
	struct servent *r;

	SOCKET_TEST(r = getservbyname(name, proto), NULL);
	return r;
}

#undef getservbyport

struct servent *nt_getservbyport(int port, char *proto)
{
	struct servent *r;

	SOCKET_TEST(r = getservbyport(port, proto), NULL);
	return r;
}

//
// Networking stubs
//

void endhostent() 
{
	CROAK("endhostent not implemented!\n");
}

void endnetent()
{
	CROAK("endnetent not implemented!\n");
}

void endprotoent()
{
	CROAK("endprotoent not implemented!\n");
}

void endservent()
{
	CROAK("endservent not implemented!\n");
}


struct netent *getnetent(void) 
{
	CROAK("getnetent not implemented!\n");
	return (struct netent *) NULL;
}

struct netent *getnetbyname(char *name) 
{
	CROAK("getnetbyname not implemented!\n");
	return (struct netent *)NULL;
}

struct netent *getnetbyaddr(long net, int type) 
{
	CROAK("getnetbyaddr not implemented!\n");
	return (struct netent *)NULL;
}

struct protoent *getprotoent(void) 
{
	CROAK("getprotoent not implemented!\n");
	return (struct protoent *) NULL;
}

struct servent *getservent(void) 
{
	CROAK("getservent not implemented!\n");
	return (struct servent *) NULL;
}

void sethostent(int stayopen)
{
	CROAK("sethostent not implemented!\n");
}


void setnetent(int stayopen)
{
	CROAK("setnetent not implemented!\n");
}


void setprotoent(int stayopen)
{
	CROAK("setprotoent not implemented!\n");
}


void setservent(int stayopen)
{
	CROAK("setservent not implemented!\n");
}

