;; pc98.el: PC9801 cursor key and function key mapping
;;
;; Edition History:
;; 1.1 91/11/20 Halca.HIRANO creation
;; 1.3 91/11/27 Halca.Hirano pc98-assign-special-key, ESC _ -> ESC O, DEL=^?
;;
 
;; Copyright (C) 1991 Free Software Foundation, Inc.

;; This file is part of GNU Emacs.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.

;;
;; codes generated by PC98 keyboard
;;
;; ESC O A          F1
;;  ......
;; ESC O O          F15
;;
;; ESC O P          shift F1
;;  ......
;; ESC O ^          shift F15
;;
;; ESC O _          ctrl F1
;;  ......
;; ESC O m          ctrl F15
;;
;; ESC O n		ROLLUP
;; ESC O o		ROLLDOWN
;; ESC O p		INS
;; ^?			DEL
;; ESC O r		up arrow
;; ESC O s		left arrow
;; ESC O t		right arrow
;; ESC O u		down arrow
;; ESC O v		CLR
;; ESC O w		HELP
;; ESC O x 	        HOME


(defvar pc98-map (make-keymap)
  "The pc98-map maps the function keys on the PC9801 keyboard.")

;; function keys

(define-key pc98-map "A" 'help-for-help)		; f.1
(define-key pc98-map "P" 'describe-mode)		; s-f.1
(define-key pc98-map "_" 'describe-key)			; c-f.1

(define-key pc98-map "B" 'other-window)			; f.2
(define-key pc98-map "Q" 'switch-to-buffer)		; s-f.2
(define-key pc98-map "`" 'list-buffers)			; c-f.2

(define-key pc98-map "C" 'delete-other-windows)		; f.3
(define-key pc98-map "R" 'delete-window)		; s-f.3
(define-key pc98-map "a" 'scroll-other-window)		; c-f.3

(define-key pc98-map "D" 'split-window-vertically)	; f.4
(define-key pc98-map "S" 'enlarge-window)		; s-f.4
(define-key pc98-map "b" 'shrink-window)		; c-f.4

(define-key pc98-map "E" 'split-window-horizontally)	; f.5
(define-key pc98-map "T" 'enlarge-window-horizontally)	; s-f.5
(define-key pc98-map "c" 'shrink-window-horizontally)	; c-f.5

(define-key pc98-map "F" 'copy-region-as-kill)		; f.6
(define-key pc98-map "U" 'kill-region)			; s-f.6
(define-key pc98-map "d" 'yank)				; lc-f.6

(define-key pc98-map "G" 'goto-line)			; f.7
(define-key pc98-map "V" 'isearch-forward)		; s-f.7
(define-key pc98-map "e" 'query-replace)		; c-f.7

(define-key pc98-map "H" 'find-file)			; f.8
(define-key pc98-map "W" 'save-buffer)			; s-f.8
(define-key pc98-map "f" 'write-file)			; c-f.8

(define-key pc98-map "I" 'dired)			; f.9
(define-key pc98-map "X" 'compile)			; s-f.9
(define-key pc98-map "g" 'repeat-complex-command)	; c-f.9

(define-key pc98-map "J" 'shell-command)		; f.10
(define-key pc98-map "Y" 'suspend-emacs)		; s-f.10
(define-key pc98-map "h" 'save-buffers-kill-emacs)	; c-f.10

; definition for f.11 - f.15 are commented out for speed

;(define-key pc98-map "K" 'unbound-key)		; f.11
;(define-key pc98-map "Z" 'unbound-key)		; s-f.11
;(define-key pc98-map "i" 'unbound-key)		; c-f.11

;(define-key pc98-map "L" 'unbound-key)		; f.12
;(define-key pc98-map "[" 'unbound-key)		; s-f.12
;(define-key pc98-map "j" 'unbound-key)		; c-f.12

;(define-key pc98-map "M" 'unbound-key)		; f.13
;(define-key pc98-map "\\" 'unbound-key)	; s-f.13
;(define-key pc98-map "k" 'unbound-key)		; c-f.13

;(define-key pc98-map "N" 'unbound-key)		; f.14
;(define-key pc98-map "]" 'unbound-key)		; s-f.14
;(define-key pc98-map "l" 'unbound-key)		; c-f.14

;(define-key pc98-map "O" 'unbound-key)		; f.15
;(define-key pc98-map "^" 'unbound-key)		; s-f.15
;(define-key pc98-map "m" 'unbound-key)		; c-f.15

;; cursor keys
(define-key pc98-map "n" 'scroll-up)		        ; ROLLUP
(define-key pc98-map "o" 'scroll-down)			; ROLLDOWN
(define-key pc98-map "p" 'set-mark-command)		; INS
; now DEL generates ^?
;(define-key pc98-map "q" 'delete-backward-char)		; DEL
(define-key pc98-map "r" 'previous-line)		; up arrow
(define-key pc98-map "s" 'backward-char)		; left arrow
(define-key pc98-map "t" 'forward-char)			; right arrow
(define-key pc98-map "u" 'next-line)			; down arrow
(define-key pc98-map "v" 'recenter)			; CLR
(define-key pc98-map "w" 'help-for-help)		; HELP
(define-key pc98-map "x" 'beginning-of-buffer) 		; HOME

(define-key esc-map "O" pc98-map)

(defvar pc98-map-hooks nil
  "List of forms to evaluate after setting pc98-map.")

(let ((hooks pc98-map-hooks))
  (while hooks
    (eval (car hooks))
    (setq hooks (cdr hooks))))

;;
;; function key label support functions
;;
(defvar console-is-with-function-key-label nil
 "If value is t, the console consists of emacs windows and function key label.")

(defun redraw-display-with-function-key-label ()
  (redraw-display)
  (put-function-key-label))

(defun recenter-with-function-key-label (&optional arg) "\
  recenter and display function key label."
  (interactive)
  (recenter arg)
  (put-function-key-label))

(defun setup-console-with-function-key-label ()
  (delete-other-windows)
  (enlarge-window 100)
  (shrink-window 4)
  (message "")
  (redraw-display-with-function-key-label)
  (send-string-to-terminal "\e[1;1f"))
  
(defun put-function-key-label ()
  (save-excursion
    (message "")
    (send-string-to-terminal
     (convert-string-kanji-code
;; You may find funny symbols. Don't worry these are Kanji characters.      
      (format "\e[%d;1f\
 |  F.1  |  F.2  |  F.3  |  F.4  |  F.5  |  F.6  | F.7 |  F.8  | F.9 | F.10   |\n\
 |wv |ړ |Sʉ | |c |Rs[ |ړ |[h |DIR  |R}h|\n\
s|[h |w | |g |cg |Jbg |T |Z[u |MAKE |VF  |\n\
c| |ꗗ | |k |ck |N |u |Cg |J |I    |\n" (- (screen-height) 3))
      3 1)))
  nil)

(defun erase-system-function-key-label ()
 "Erase system function key label."
  (send-string-to-terminal "\e[>1h"))

(defun appear-system-function-key-label ()
 "Appear system function key label."
  (send-string-to-terminal "\e[>1l"))



(if console-is-with-function-key-label
    (progn
      (global-set-key "\C-l" 'recenter-with-function-key-label)
      (setup-console-with-function-key-label)))

(pc98-assign-special-key)		; set function/cursor key string

