/**
 ** MOUSETST.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/


#include "test.h"
#include "mousex.h"

TESTFUNC(mousetest)
{
	MouseEvent evt;
	int bgc = GrAllocColor(0,0,128);
	int fgc = GrAllocColor(255,255,0);
	int ii,mode;

	if(MouseDetect()) {
	    MouseEventMode(1);
	    MouseInit();
	    MouseSetColors(GrAllocColor(255,0,0),GrBlack());
	    MouseDisplayCursor();
	    GrClearScreen(bgc);
	    ii = 0;
	    mode = M_CUR_NORMAL;
	    for( ; ; ) {
		drawing(ii,ii,GrSizeX()-20,GrSizeY()-20,fgc | GrXOR,GrNOCOLOR);
		MouseGetEvent((M_KEYPRESS | M_POLL),&evt);
		if(evt.flags & M_KEYPRESS) {
		    if(mode == M_CUR_BOX) break;
		    switch(++mode) {
		      case M_CUR_RUBBER:
			MouseSetCursorMode(M_CUR_RUBBER,100,100,GrWhite() ^ bgc);
			break;
		      case M_CUR_LINE:
			MouseSetCursorMode(M_CUR_LINE,20,20,GrWhite() ^ bgc);
			break;
		      case M_CUR_BOX:
			MouseSetCursorMode(M_CUR_BOX,-20,-10,20,10,GrWhite() ^ bgc);
			break;
		    }
		}
		if((ii += 7) > 20) ii -= 20;
	    }
	    MouseUnInit();
	}
}

